/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasManeuverContext;
import com.sap.sailing.datamining.data.HasTrackedLegOfCompetitorContext;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;

public class ManeuverWithContext
implements HasManeuverContext {
    private static final long serialVersionUID = 7717196485074392156L;
    private final HasTrackedLegOfCompetitorContext trackedLegOfCompetitor;
    private final Maneuver maneuver;
    private final TimePoint timePointBeforeForAnalysis;
    private final TimePoint timePointAfterForAnalysis;
    private final double directionChangeInDegreesForAnalysis;
    private final Maneuver previousManeuver;
    private final Maneuver nextManeuver;
    private Wind wind;

    public ManeuverWithContext(HasTrackedLegOfCompetitorContext trackedLegOfCompetitor, Maneuver maneuver, boolean mainCurveAnalysis, Maneuver previousManeuver, Maneuver nextManeuver) {
        this.trackedLegOfCompetitor = trackedLegOfCompetitor;
        this.maneuver = maneuver;
        this.previousManeuver = previousManeuver;
        this.nextManeuver = nextManeuver;
        ManeuverCurveBoundaries enteringAndExistingDetails = mainCurveAnalysis ? maneuver.getMainCurveBoundaries() : maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries();
        this.timePointBeforeForAnalysis = enteringAndExistingDetails.getTimePointBefore();
        this.timePointAfterForAnalysis = enteringAndExistingDetails.getTimePointAfter();
        this.directionChangeInDegreesForAnalysis = enteringAndExistingDetails.getDirectionChangeInDegrees();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maneuver == null ? 0 : this.maneuver.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManeuverWithContext other = (ManeuverWithContext)obj;
        return !(this.maneuver == null ? other.maneuver != null : !this.maneuver.equals(other.maneuver));
    }

    @Override
    public Wind getWindInternal() {
        return this.wind;
    }

    @Override
    public void setWindInternal(Wind wind) {
        this.wind = wind;
    }

    @Override
    public TimePoint getTimePointBeforeForAnalysis() {
        return this.timePointBeforeForAnalysis;
    }

    @Override
    public TimePoint getTimePointAfterForAnalysis() {
        return this.timePointAfterForAnalysis;
    }

    @Override
    public double getDirectionChangeInDegreesForAnalysis() {
        return this.directionChangeInDegreesForAnalysis;
    }

    @Override
    public ManeuverType getTypeOfPreviousManeuver() {
        return this.previousManeuver != null ? this.previousManeuver.getType() : ManeuverType.UNKNOWN;
    }

    @Override
    public ManeuverType getTypeOfNextManeuver() {
        return this.nextManeuver != null ? this.nextManeuver.getType() : ManeuverType.UNKNOWN;
    }

    @Override
    public Double getManeuverEnteringSpeed() {
        return this.getSpeedInKnotsAtTimePoint(this.getTimePointBeforeForAnalysis());
    }

    @Override
    public Double getManeuverExitingSpeed() {
        return this.getSpeedInKnotsAtTimePoint(this.getTimePointAfterForAnalysis());
    }

    @Override
    public Double getManeuverDurationInSeconds() {
        return this.getTimePointBeforeForAnalysis().until(this.getTimePointAfterForAnalysis()).asSeconds();
    }

    @Override
    public Double getAbsTWAAtManeuverClimax() {
        Competitor competitor = this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor().getCompetitor();
        TrackedRace trackedRace = this.getTrackedLegOfCompetitorContext().getTrackedRace();
        Wind wind = trackedRace.getWind(this.maneuver.getPosition(), this.maneuver.getTimePoint());
        SpeedWithBearing speedWithBearing = trackedRace.getTrack(competitor).getEstimatedSpeed(this.maneuver.getTimePoint());
        return Math.abs(wind.getFrom().getDifferenceTo(speedWithBearing.getBearing()).getDegrees());
    }

    @Override
    public HasTrackedLegOfCompetitorContext getTrackedLegOfCompetitorContext() {
        return this.trackedLegOfCompetitor;
    }

    @Override
    public Maneuver getManeuver() {
        return this.maneuver;
    }

    @Override
    public Double getAbsoluteDirectionChangeInDegrees() {
        return Math.abs(this.getDirectionChangeInDegreesForAnalysis());
    }

    @Override
    public Distance getManeuverLossDistanceLost() {
        return this.getManeuver().getManeuverLoss() == null ? null : this.getManeuver().getManeuverLoss().getProjectedDistanceLost();
    }

    @Override
    public Double getEnteringAbsTWA() {
        return this.getAbsTWAAtTimepoint(this.getTimePointBeforeForAnalysis());
    }

    @Override
    public Double getExitingAbsTWA() {
        return this.getAbsTWAAtTimepoint(this.getTimePointAfterForAnalysis());
    }

    private Double getAbsTWAAtTimepoint(TimePoint timepoint) {
        Double twa = this.getTWAAtTimepoint(timepoint);
        if (twa == null) {
            return null;
        }
        return Math.abs(twa);
    }

    private Double getTWAAtTimepoint(TimePoint timepoint) {
        Wind wind = this.getTrackedLegOfCompetitorContext().getTrackedRace().getWind(this.maneuver.getPosition(), timepoint);
        GPSFixTrack competitorTrack = this.getTrackedLegOfCompetitorContext().getTrackedRace().getTrack(this.getTrackedLegOfCompetitorContext().getCompetitor());
        if (wind != null) {
            competitorTrack.lockForRead();
            try {
                SpeedWithBearing speedWithBearing = competitorTrack.getEstimatedSpeed(timepoint);
                double twa = wind.getFrom().getDifferenceTo(speedWithBearing.getBearing()).getDegrees();
                Double d = twa;
                return d;
            }
            finally {
                competitorTrack.unlockAfterRead();
            }
        }
        return null;
    }

    @Override
    public Util.Pair<Double, Double> getWindSpeedVsManeuverLoss() {
        Wind wind = this.getTrackedLegOfCompetitorContext().getTrackedRace().getWind(this.maneuver.getPosition(), this.getTimePointBeforeForAnalysis());
        return new Util.Pair((Object)wind.getKnots(), (Object)this.getManeuverLossDistanceLost().getMeters());
    }

    @Override
    public Double getEnteringManeuverSpeedMinusExitingSpeed() {
        return this.getManeuverEnteringSpeed() - this.getManeuverExitingSpeed();
    }

    @Override
    public Double getRatioBetweenManeuverEnteringAndExitingSpeed() {
        return this.getManeuverEnteringSpeed() / this.getManeuverExitingSpeed();
    }

    @Override
    public Tack getTackBeforeManeuver() {
        Double twa = this.getTWAAtTimepoint(this.getTimePointBeforeForAnalysis());
        if (twa == null) {
            return null;
        }
        if (twa < 0.0) {
            return Tack.PORT;
        }
        return Tack.STARBOARD;
    }

    private Double getSpeedInKnotsAtTimePoint(TimePoint timePoint) {
        return this.getGPSFixTrack().getEstimatedSpeed(timePoint).getKnots();
    }

    private GPSFixTrack<Competitor, GPSFixMoving> getGPSFixTrack() {
        Competitor competitor = this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor().getCompetitor();
        TrackedRace trackedRace = this.getTrackedLegOfCompetitorContext().getTrackedRace();
        return trackedRace.getTrack(competitor);
    }

    @Override
    public Double getDurationBetweenStableSpeedWithCourseAndMainCurveBeginningSeconds() {
        return this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore().until(this.maneuver.getMainCurveBoundaries().getTimePointBefore()).asSeconds();
    }

    @Override
    public Double getSpeedRatioBetweenStableSpeedWithCourseAndMainCurveBeginning() {
        return this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingBefore().getKnots() / this.maneuver.getMainCurveBoundaries().getSpeedWithBearingBefore().getKnots();
    }

    @Override
    public Double getAbsCourseDifferenceBetweenStableSpeedWithCourseAndMainCurveBeginningInDegrees() {
        return Math.abs(this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingBefore().getBearing().getDifferenceTo(this.maneuver.getMainCurveBoundaries().getSpeedWithBearingBefore().getBearing()).getDegrees());
    }

    @Override
    public Double getDurationBetweenStableSpeedWithCourseAndMainCurveEndInSeconds() {
        return this.maneuver.getMainCurveBoundaries().getTimePointAfter().until(this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter()).asSeconds();
    }

    @Override
    public Double getSpeedRatioBetweenStableSpeedWithCourseAndMainCurveEnd() {
        return this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingAfter().getKnots() / this.maneuver.getMainCurveBoundaries().getSpeedWithBearingAfter().getKnots();
    }

    @Override
    public Double getAbsCourseDifferenceBetweenStableSpeedWithCourseAndMainCurveEndInDegrees() {
        return Math.abs(this.maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingAfter().getBearing().getDifferenceTo(this.maneuver.getMainCurveBoundaries().getSpeedWithBearingAfter().getBearing()).getDegrees());
    }

    @Override
    public Speed getLowestSpeed() {
        return this.getManeuver().getLowestSpeed();
    }

    @Override
    public Speed getSpeedDifference() {
        return new KnotSpeedImpl(this.getManeuver().getSpeedWithBearingAfter().getKnots() - this.getManeuver().getSpeedWithBearingBefore().getKnots());
    }

    @Override
    public double getMaximimumTurningRateInDegreesPerSecond() {
        return this.getManeuver().getMaxTurningRateInDegreesPerSecond();
    }

    @Override
    public double getAverageTurningRateInDegreesPerSecond() {
        return this.getManeuver().getAvgTurningRateInDegreesPerSecond();
    }
}

