/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.userstore.mongodb.impl;

import com.sap.sse.ServerInfo;
import com.sap.sse.common.Util;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.security.interfaces.AccessControlStore;
import com.sap.sse.security.interfaces.PreferenceConverterRegistrationManager;
import com.sap.sse.security.interfaces.UserStore;
import com.sap.sse.security.subscription.SubscriptionApiService;
import com.sap.sse.security.subscription.SubscriptionDataHandler;
import com.sap.sse.security.userstore.mongodb.AccessControlStoreImpl;
import com.sap.sse.security.userstore.mongodb.UserStoreImpl;
import com.sap.sse.security.userstore.mongodb.impl.CollectionNames;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static BundleContext context;
    private static ServiceTracker<SubscriptionApiService, SubscriptionApiService> subscriptionApiServiceTracker;
    private ServiceRegistration<?> accessControlStoreRegistration;
    private ServiceRegistration<?> userStoreRegistration;
    private PreferenceConverterRegistrationManager preferenceConverterRegistrationManager;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        String defaultServerGroupName = System.getProperty("security.defaultServerGroupName", ServerInfo.getServerGroupName());
        logger.info("Creating user store");
        subscriptionApiServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, SubscriptionApiService.class);
        UserStoreImpl userStore = new UserStoreImpl(defaultServerGroupName);
        AccessControlStoreImpl accessControlStore = new AccessControlStoreImpl(userStore);
        this.accessControlStoreRegistration = context.registerService(AccessControlStore.class.getName(), (Object)accessControlStore, null);
        this.userStoreRegistration = context.registerService(UserStore.class.getName(), (Object)userStore, null);
        this.preferenceConverterRegistrationManager = new PreferenceConverterRegistrationManager(bundleContext, (UserStore)userStore);
        logger.info("User store registered.");
        CollectionNames[] collectionNamesArray = CollectionNames.values();
        int n = collectionNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CollectionNames name = collectionNamesArray[n2];
            MongoDBService.INSTANCE.registerExclusively(CollectionNames.class, name.name());
            ++n2;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.preferenceConverterRegistrationManager.stop();
        this.accessControlStoreRegistration.unregister();
        this.userStoreRegistration.unregister();
        context = null;
    }

    public static SubscriptionDataHandler getSubscriptionDataHandler(String providerName) {
        if (subscriptionApiServiceTracker != null) {
            ServiceReference[] serviceReferences;
            ServiceReference[] serviceReferenceArray = serviceReferences = subscriptionApiServiceTracker.getServiceReferences();
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serviceReference = serviceReferenceArray[n2];
                if (Util.equalsWithNull((Object)serviceReference.getProperty("provider-name"), (Object)providerName)) {
                    return ((SubscriptionApiService)context.getService(serviceReference)).getDataHandler();
                }
                ++n2;
            }
        }
        return null;
    }
}

