/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.persistence.impl;

import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sailing.aiagent.persistence.DomainObjectFactory;
import com.sap.sailing.aiagent.persistence.impl.FieldNames;
import com.sap.sailing.aiagent.persistence.impl.MongoObjectFactoryImpl;
import com.sap.sse.aicore.Credentials;
import com.sap.sse.aicore.CredentialsParser;
import com.sap.sse.common.Util;
import java.util.UUID;
import org.bson.Document;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private final MongoCollection<Document> eventsToCommentCollection;
    private final MongoCollection<Document> credentialsCollection;

    public DomainObjectFactoryImpl(MongoDatabase db) {
        this.eventsToCommentCollection = MongoObjectFactoryImpl.getOrCreateEventsToCommentCollection(db);
        this.credentialsCollection = MongoObjectFactoryImpl.getOrCreateCredentialsCollection(db);
    }

    @Override
    public Iterable<UUID> getEventsToComment(ClientSession clientSessionOrNull) {
        FindIterable documents = clientSessionOrNull == null ? this.eventsToCommentCollection.find() : this.eventsToCommentCollection.find(clientSessionOrNull);
        return Util.map((Iterable)documents, d -> UUID.fromString(d.getString((Object)FieldNames.AIAGENT_EVENTS_TO_COMMENT_EVENT_ID.name())));
    }

    @Override
    public Credentials getCredentials(ClientSession clientSessionOrNull) {
        FindIterable documents = clientSessionOrNull == null ? this.credentialsCollection.find() : this.credentialsCollection.find(clientSessionOrNull);
        Iterable credentials = Util.map((Iterable)documents, d -> CredentialsParser.create().parseFromEncoded((CharSequence)d.getString((Object)FieldNames.AIAGENT_CREDENTIALS_ENCODED_AS_STRING.name()), d.getString((Object)FieldNames.AIAGENT_CRETENTIALS_SALT.name())));
        return (Credentials)Util.first((Iterable)credentials);
    }
}

