/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import java.io.Serializable;

public interface Distance
extends Comparable<Distance>,
Serializable {
    public static final NullDistance NULL = new NullDistance();

    public double getGeographicalMiles();

    public double getSeaMiles();

    public double getNauticalMiles();

    public double getMeters();

    public double getKilometers();

    public double getCentralAngleDeg();

    public double getCentralAngleRad();

    public Distance scale(double var1);

    public Speed inTime(long var1);

    public Speed inTime(Duration var1);

    public Duration atSpeed(Speed var1);

    public Distance add(Distance var1);

    public double divide(Distance var1);

    public Distance abs();

    public static class NullDistance
    implements Distance {
        private static final long serialVersionUID = -3167560884686340893L;

        @Override
        public int compareTo(Distance o) {
            return this.getMeters() > o.getMeters() ? 1 : (this.getMeters() == o.getMeters() ? 0 : -1);
        }

        @Override
        public double getGeographicalMiles() {
            return 0.0;
        }

        @Override
        public double getSeaMiles() {
            return 0.0;
        }

        @Override
        public double getNauticalMiles() {
            return 0.0;
        }

        @Override
        public double getMeters() {
            return 0.0;
        }

        @Override
        public Duration atSpeed(Speed speed) {
            return Duration.NULL;
        }

        @Override
        public double getKilometers() {
            return 0.0;
        }

        @Override
        public double getCentralAngleDeg() {
            return 0.0;
        }

        @Override
        public double getCentralAngleRad() {
            return 0.0;
        }

        @Override
        public Distance scale(double factor) {
            return this;
        }

        @Override
        public Speed inTime(long milliseconds) {
            return Speed.NULL;
        }

        @Override
        public Speed inTime(Duration duration) {
            return Speed.NULL;
        }

        @Override
        public Distance add(Distance d) {
            return d;
        }

        public String toString() {
            return "0m";
        }

        @Override
        public double divide(Distance other) {
            double result = other.getMeters() == 0.0 ? Double.NaN : 0.0;
            return result;
        }

        @Override
        public Distance abs() {
            return this;
        }
    }
}

