/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.MWVSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DataStatus;
import net.sf.marineapi.nmea.util.Units;

class MWVParser
extends SentenceParser
implements MWVSentence {
    private static final int WIND_ANGLE = 0;
    private static final int REFERENCE = 1;
    private static final int WIND_SPEED = 2;
    private static final int SPEED_UNITS = 3;
    private static final int DATA_STATUS = 4;

    public MWVParser(String nmea) {
        super(nmea, SentenceId.MWV);
    }

    public MWVParser(TalkerId talker) {
        super(talker, SentenceId.MWV, 5);
        this.setCharValue(4, DataStatus.VOID.toChar());
    }

    @Override
    public double getAngle() {
        return this.getDoubleValue(0);
    }

    @Override
    public double getSpeed() {
        return this.getDoubleValue(2);
    }

    @Override
    public Units getSpeedUnit() {
        return Units.valueOf(this.getCharValue(3));
    }

    @Override
    public DataStatus getStatus() {
        return DataStatus.valueOf(this.getCharValue(4));
    }

    @Override
    public boolean isTrue() {
        char ch = this.getCharValue(1);
        return ch == 'T';
    }

    @Override
    public void setAngle(double angle) {
        this.setDegreesValue(0, angle);
    }

    @Override
    public void setSpeed(double speed) {
        if (speed < 0.0) {
            throw new IllegalArgumentException("Speed must be positive");
        }
        this.setDoubleValue(2, speed, 1, 1);
    }

    @Override
    public void setSpeedUnit(Units unit) {
        if (unit == Units.METER || unit == Units.KMH || unit == Units.KNOT) {
            this.setCharValue(3, unit.toChar());
            return;
        }
        throw new IllegalArgumentException("Invalid unit for speed");
    }

    @Override
    public void setStatus(DataStatus status) {
        this.setCharValue(4, status.toChar());
    }

    @Override
    public void setTrue(boolean isTrue) {
        if (isTrue) {
            this.setCharValue(1, 'T');
        } else {
            this.setCharValue(1, 'R');
        }
    }
}

