/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import java.text.DecimalFormat;
import net.sf.marineapi.ais.message.AISPositionReportB;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.AISRuleViolation;
import net.sf.marineapi.ais.util.Angle12;
import net.sf.marineapi.ais.util.Angle9;
import net.sf.marineapi.ais.util.Latitude27;
import net.sf.marineapi.ais.util.Longitude28;
import net.sf.marineapi.ais.util.PositionInfo;
import net.sf.marineapi.ais.util.Sixbit;
import net.sf.marineapi.ais.util.TimeStamp;

class AISPositionReportBParser
extends AISMessageParser
implements AISPositionReportB {
    protected static final String SEPARATOR = "\n\t";
    private static final int SPEEDOVERGROUND = 0;
    private static final int POSITIONACCURACY = 1;
    private static final int LONGITUDE = 2;
    private static final int LATITUDE = 3;
    private static final int COURSEOVERGROUND = 4;
    private static final int TRUEHEADING = 5;
    private static final int TIMESTAMP = 6;
    private static final int[] FROM = new int[]{46, 56, 57, 85, 112, 124, 133};
    private static final int[] TO = new int[]{56, 57, 85, 112, 124, 133, 139};
    private int fSOG;
    private boolean fPositionAccuracy;
    private double fLongitude;
    private double fLatitude;
    private int fCOG;
    private int fTrueHeading;
    private int fTimeStamp;

    public AISPositionReportBParser(Sixbit content) {
        super(content);
        this.fSOG = content.getInt(FROM[0], TO[0]);
        this.fPositionAccuracy = content.getBoolean(FROM[1]);
        this.fLongitude = Longitude28.toDegrees(content.getAs28BitInt(FROM[2], TO[2]));
        if (!PositionInfo.isLongitudeCorrect(this.fLongitude)) {
            this.fViolations.add(new AISRuleViolation("LongitudeInDegrees", this.fLongitude, "[-180.0, 180.0] + {181}"));
        }
        this.fLatitude = Latitude27.toDegrees(content.getAs27BitInt(FROM[3], TO[3]));
        if (!PositionInfo.isLatitudeCorrect(this.fLatitude)) {
            this.fViolations.add(new AISRuleViolation("LatitudeInDegrees", this.fLatitude, "[-90.0, 90.0] + {91}"));
        }
        this.fCOG = content.getInt(FROM[4], TO[4]);
        if (!Angle12.isCorrect(this.fCOG)) {
            this.fViolations.add(new AISRuleViolation("getCourseOverGround", this.fCOG, "[0,3599] + {3600}"));
        }
        this.fTrueHeading = content.getInt(FROM[5], TO[5]);
        if (!Angle9.isCorrect(this.fTrueHeading)) {
            this.fViolations.add(new AISRuleViolation("getTrueHeading", this.fTrueHeading, "[0,359] + {511}"));
        }
        this.fTimeStamp = content.getInt(FROM[6], TO[6]);
    }

    @Override
    public int getSpeedOverGround() {
        return this.fSOG;
    }

    @Override
    public boolean getPositionAccuracy() {
        return this.fPositionAccuracy;
    }

    @Override
    public double getLongitudeInDegrees() {
        return this.fLongitude;
    }

    @Override
    public double getLatitudeInDegrees() {
        return this.fLatitude;
    }

    @Override
    public int getCourseOverGround() {
        return this.fCOG;
    }

    @Override
    public int getTrueHeading() {
        return this.fTrueHeading;
    }

    @Override
    public int getTimeStamp() {
        return this.fTimeStamp;
    }

    public String getSOGString() {
        String msg = this.fSOG == 1023 ? "no SOG" : (this.fSOG == 1022 ? ">=102.2" : new DecimalFormat("##0.0").format((double)this.fSOG / 10.0));
        return msg;
    }

    public String toString() {
        String result = "\tSOG:     " + this.getSOGString();
        result = String.valueOf(result) + "\n\tPos acc: " + (this.fPositionAccuracy ? "high" : "low") + " accuracy";
        result = String.valueOf(result) + "\n\tLat:     " + PositionInfo.longitudeToString(this.fLongitude);
        result = String.valueOf(result) + "\n\tLon:     " + PositionInfo.latitudeToString(this.fLatitude);
        result = String.valueOf(result) + "\n\tCOG:     " + Angle12.toString(this.fCOG);
        result = String.valueOf(result) + "\n\tHeading: " + Angle9.getTrueHeadingString(this.fTrueHeading);
        result = String.valueOf(result) + "\n\tTime:    " + TimeStamp.toString(this.fTimeStamp);
        return result;
    }
}

