/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.datamining.data.impl;

import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.WindSpeedSteppingWithMaxDistance;
import com.sap.sse.common.Speed;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.data.ClusterBoundary;
import com.sap.sse.datamining.data.ClusterGroup;
import com.sap.sse.datamining.impl.data.ClusterWithLowerAndUpperBoundaries;
import com.sap.sse.datamining.impl.data.ComparableClusterBoundary;
import com.sap.sse.datamining.impl.data.ComparisonStrategy;
import com.sap.sse.datamining.impl.data.FixClusterGroup;
import java.util.ArrayList;
import java.util.Collection;

public class SpeedClusterGroup
extends FixClusterGroup<Speed> {
    private static final long serialVersionUID = -3428022721991223921L;

    public SpeedClusterGroup(double[] levelMidsInKnots, double maxDistanceInKnots) {
        super(SpeedClusterGroup.createClustersForLevelMids(levelMidsInKnots, maxDistanceInKnots));
    }

    private static Collection<Cluster<Speed>> createClustersForLevelMids(double[] levelMidsInKnots, double maxDistanceInKnots) {
        ArrayList<Cluster<Speed>> clusterList = new ArrayList<Cluster<Speed>>();
        int index = 0;
        while (index < levelMidsInKnots.length) {
            ClusterBoundary<Speed> lowerBoundary = SpeedClusterGroup.createLowerBoundary(levelMidsInKnots, maxDistanceInKnots, index);
            ClusterBoundary<Speed> upperBoundary = SpeedClusterGroup.createUpperBoundary(levelMidsInKnots, maxDistanceInKnots, index);
            ClusterWithLowerAndUpperBoundaries cluster = new ClusterWithLowerAndUpperBoundaries(lowerBoundary, upperBoundary);
            clusterList.add((Cluster<Speed>)cluster);
            ++index;
        }
        return clusterList;
    }

    private static ClusterBoundary<Speed> createUpperBoundary(double[] levelMidsInKnots, double maxDistanceInKnots, int index) {
        double midBetweenCurrentLevelMidAndUpperLevelMid;
        double biggestPossibleUpperBoundary;
        double upperBoundaryValue = index == levelMidsInKnots.length - 1 ? levelMidsInKnots[index] + maxDistanceInKnots : ((biggestPossibleUpperBoundary = levelMidsInKnots[index] + maxDistanceInKnots) < (midBetweenCurrentLevelMidAndUpperLevelMid = levelMidsInKnots[index] + 0.5 * (levelMidsInKnots[index + 1] - levelMidsInKnots[index])) ? biggestPossibleUpperBoundary : midBetweenCurrentLevelMidAndUpperLevelMid);
        ComparableClusterBoundary upperBoundary = new ComparableClusterBoundary((Comparable)new KnotSpeedImpl(upperBoundaryValue), ComparisonStrategy.LOWER_THAN);
        return upperBoundary;
    }

    private static ClusterBoundary<Speed> createLowerBoundary(double[] levelMidsInKnots, double maxDistanceInKnots, int index) {
        double midBetweenLowerLevelMidAndCurrentLevelMid;
        double lowestPossibleLowerBoundary;
        double lowerBoundaryValue = index > 0 ? ((lowestPossibleLowerBoundary = levelMidsInKnots[index] - maxDistanceInKnots) > (midBetweenLowerLevelMidAndCurrentLevelMid = levelMidsInKnots[index - 1] + 0.5 * (levelMidsInKnots[index] - levelMidsInKnots[index - 1])) ? lowestPossibleLowerBoundary : midBetweenLowerLevelMidAndCurrentLevelMid) : ((lowestPossibleLowerBoundary = levelMidsInKnots[index] - maxDistanceInKnots) <= 0.0 ? 0.0 : lowestPossibleLowerBoundary);
        ComparableClusterBoundary lowerBoundary = new ComparableClusterBoundary((Comparable)new KnotSpeedImpl(lowerBoundaryValue), ComparisonStrategy.GREATER_EQUALS_THAN);
        return lowerBoundary;
    }

    public static ClusterGroup<Speed> createSpeedClusterGroupFrom(WindSpeedSteppingWithMaxDistance windStepping) {
        double maxDistance = windStepping.getMaxDistance();
        double[] rawIntegerStepping = windStepping.getRawStepping();
        double[] rawDoubleLevelMids = new double[rawIntegerStepping.length];
        int i = 0;
        while (i < rawIntegerStepping.length) {
            rawDoubleLevelMids[i] = rawIntegerStepping[i];
            ++i;
        }
        return new SpeedClusterGroup(rawDoubleLevelMids, maxDistance);
    }
}

