/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.datamining.data.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.polars.datamining.shared.PolarDataMiningSettings;
import com.sap.sailing.polars.datamining.shared.PolarStatistic;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import java.util.HashSet;
import java.util.Set;

public class PolarStatisticImpl
implements PolarStatistic {
    private final SpeedWithBearing boatSpeed;
    private final Wind windSpeed;
    private final double trueWindAngleDeg;
    private final PolarDataMiningSettings settings;

    public PolarStatisticImpl(TrackedRace trackedRace, Competitor competitor, GPSFixMoving fix, PolarDataMiningSettings settings, Wind windSpeed) {
        this.settings = settings;
        this.windSpeed = windSpeed;
        GPSFixTrack track = trackedRace.getTrack(competitor);
        this.boatSpeed = track.getEstimatedSpeed(fix.getTimePoint());
        Bearing bearing = this.boatSpeed.getBearing();
        Position position = fix.getPosition();
        Set<WindSource> windSourcesToExclude = settings.useOnlyEstimatedForWindDirection() ? PolarStatisticImpl.collectWindSourcesToIgnoreForBearing(trackedRace, true) : new HashSet<WindSource>();
        Wind windEstimated = trackedRace.getWind(position, fix.getTimePoint(), windSourcesToExclude);
        if (windEstimated == null) {
            windSourcesToExclude = PolarStatisticImpl.collectWindSourcesToIgnoreForBearing(trackedRace, false);
            windEstimated = trackedRace.getWind(position, fix.getTimePoint(), windSourcesToExclude);
        }
        if (windEstimated == null) {
            windEstimated = windSpeed;
        }
        Bearing windBearing = windEstimated.getFrom();
        this.trueWindAngleDeg = bearing.getDifferenceTo(windBearing).getDegrees();
    }

    public SpeedWithBearing getBoatSpeed() {
        return this.boatSpeed;
    }

    public Speed getWindSpeed() {
        return this.windSpeed;
    }

    public double getTrueWindAngleDeg() {
        return this.trueWindAngleDeg;
    }

    public static Set<WindSource> collectWindSourcesToIgnoreForBearing(TrackedRace race, boolean excludeCourseBased) {
        HashSet<WindSource> windSourcesToExclude = new HashSet<WindSource>();
        Set combinedSources = race.getWindSources(WindSourceType.COMBINED);
        for (WindSource combinedSource : combinedSources) {
            windSourcesToExclude.add(combinedSource);
        }
        if (excludeCourseBased) {
            Set courseSources = race.getWindSources(WindSourceType.COURSE_BASED);
            for (WindSource courseSource : courseSources) {
                windSourcesToExclude.add(courseSource);
            }
        }
        Set expSources = race.getWindSources(WindSourceType.EXPEDITION);
        for (WindSource expSource : expSources) {
            windSourcesToExclude.add(expSource);
        }
        Set rcSources = race.getWindSources(WindSourceType.RACECOMMITTEE);
        for (WindSource rcSource : rcSources) {
            windSourcesToExclude.add(rcSource);
        }
        Set webSources = race.getWindSources(WindSourceType.WEB);
        for (WindSource webSource : webSources) {
            windSourcesToExclude.add(webSource);
        }
        return windSourcesToExclude;
    }

    public static Set<WindSource> collectWindSourcesToIgnoreForSpeed(TrackedRace race, boolean useOnlyWindGaugesForWindSpeed) {
        HashSet<WindSource> windSourcesToExclude = new HashSet<WindSource>();
        if (useOnlyWindGaugesForWindSpeed) {
            Set combinedSources = race.getWindSources(WindSourceType.COMBINED);
            for (WindSource combinedSource : combinedSources) {
                windSourcesToExclude.add(combinedSource);
            }
            Set courseSources = race.getWindSources(WindSourceType.COURSE_BASED);
            for (WindSource courseSource : courseSources) {
                windSourcesToExclude.add(courseSource);
            }
            Set trackBasedSources = race.getWindSources(WindSourceType.TRACK_BASED_ESTIMATION);
            for (WindSource trackBasedSource : trackBasedSources) {
                windSourcesToExclude.add(trackBasedSource);
            }
            Set maneuverBasedSources = race.getWindSources(WindSourceType.MANEUVER_BASED_ESTIMATION);
            for (WindSource maneuverBasedSource : maneuverBasedSources) {
                windSourcesToExclude.add(maneuverBasedSource);
            }
            Set rcSources = race.getWindSources(WindSourceType.RACECOMMITTEE);
            for (WindSource rcSource : rcSources) {
                windSourcesToExclude.add(rcSource);
            }
            Set webSources = race.getWindSources(WindSourceType.WEB);
            for (WindSource webSource : webSources) {
                windSourcesToExclude.add(webSource);
            }
        }
        return windSourcesToExclude;
    }

    public PolarDataMiningSettings getSettings() {
        return this.settings;
    }
}

