/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.AbstractPosition;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.tracking.impl.AbstractCompactWindImpl;
import com.sap.sse.common.AbstractBearing;
import com.sap.sse.common.Bearing;

public class PreciseCompactWindImpl
extends AbstractCompactWindImpl {
    private static final long serialVersionUID = -5059956032663387929L;
    private final double latDeg;
    private final double lngDeg;
    private final double speedInKnots;
    private final double degBearing;

    public PreciseCompactWindImpl(Wind wind) {
        super(wind);
        this.degBearing = wind.getBearing() == null ? 0.0 : wind.getBearing().getDegrees();
        if (wind.getPosition() == null) {
            this.latDeg = 0.0;
            this.lngDeg = 0.0;
        } else {
            this.latDeg = wind.getPosition().getLatDeg();
            this.lngDeg = wind.getPosition().getLngDeg();
        }
        this.speedInKnots = wind.getKnots();
    }

    @Override
    public double getKnots() {
        return this.speedInKnots;
    }

    @Override
    protected Position getCompactPosition() {
        return new CompactPosition();
    }

    @Override
    protected Bearing getCompactBearing() {
        return new CompactBearing();
    }

    private class CompactBearing
    extends AbstractBearing {
        private static final long serialVersionUID = -6474909210513108635L;

        private CompactBearing() {
        }

        public double getDegrees() {
            return PreciseCompactWindImpl.this.degBearing;
        }
    }

    public class CompactPosition
    extends AbstractPosition {
        private static final long serialVersionUID = 5621506820766614178L;

        @Override
        public double getLatDeg() {
            return PreciseCompactWindImpl.this.latDeg;
        }

        @Override
        public double getLngDeg() {
            return PreciseCompactWindImpl.this.lngDeg;
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o instanceof Position && this.getLatDeg() == ((Position)o).getLatDeg() && this.getLngDeg() == ((Position)o).getLngDeg();
        }
    }
}

