/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.impl.AbstractRaceRankComparator;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import java.util.HashMap;
import java.util.Map;

public class RaceRankComparator
extends AbstractRaceRankComparator<Distance> {
    private final Map<Competitor, Distance> windwardDistanceToGoInLegCache;
    private final WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache;

    public RaceRankComparator(TrackedRace trackedRace, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        super(trackedRace, timePoint, true);
        this.cache = cache;
        this.windwardDistanceToGoInLegCache = new HashMap<Competitor, Distance>();
    }

    @Override
    protected Distance getComparisonValueForSameLeg(Competitor competitor) {
        TrackedLegOfCompetitor trackedLegOfCompetitor;
        Distance result = this.windwardDistanceToGoInLegCache.get(competitor);
        if (result == null && (trackedLegOfCompetitor = this.getTrackedRace().getTrackedLeg(competitor, this.getTimePoint())) != null) {
            result = trackedLegOfCompetitor.getWindwardDistanceToGo(this.getTimePoint(), WindPositionMode.LEG_MIDDLE, this.cache);
            this.windwardDistanceToGoInLegCache.put(competitor, result);
        }
        return result;
    }
}

