/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.tracking.DynamicGPSFixTrack;
import com.sap.sailing.domain.tracking.impl.DynamicGPSFixMovingTrackImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.Iterator;

public class OutlierFilter {
    public Util.Pair<Integer, DynamicGPSFixTrack<Competitor, GPSFixMoving>> findAndRemoveInconsistenciesOnRawFixes(DynamicGPSFixTrack<Competitor, GPSFixMoving> track) {
        int numberOfInconsistencies = 0;
        DynamicGPSFixMovingTrackImpl<Competitor> replacedTrack = new DynamicGPSFixMovingTrackImpl<Competitor>((Competitor)track.getTrackedItem(), 5000L, true);
        replacedTrack.suspendValidityAndMaxSpeedCaching();
        GPSFixMoving previous = null;
        GPSFixMoving fix = null;
        track.lockForRead();
        try {
            for (GPSFixMoving next : track.getRawFixes()) {
                if (previous != null && fix != null) {
                    Util.Pair<GPSFixMoving, Double> adjusted = this.isLikelyOutlierWithCorrectableTimepoint(track, previous, fix, next);
                    if (adjusted != null) {
                        ++numberOfInconsistencies;
                        GPSFixMoving replacementFix = (GPSFixMoving)adjusted.getA();
                        replacedTrack.add(replacementFix);
                    } else {
                        replacedTrack.add(fix);
                    }
                }
                previous = fix;
                fix = next;
            }
        }
        finally {
            track.unlockAfterRead();
        }
        return new Util.Pair((Object)numberOfInconsistencies, replacedTrack);
    }

    private Util.Pair<GPSFixMoving, Double> isLikelyOutlierWithCorrectableTimepoint(DynamicGPSFixTrack<Competitor, GPSFixMoving> track, GPSFixMoving previous, GPSFixMoving fix, GPSFixMoving next) {
        Util.Pair<GPSFixMoving, Double> adjustedFixAndDistance;
        int HOW_MANY_CRITERIA_TO_FULFILL = 2;
        double DISTANCE_RATIO_TOLERANCE = 0.5;
        int criteriaFulfilled = 0;
        if (this.hasNonZeroMilliseconds(fix.getTimePoint())) {
            ++criteriaFulfilled;
        }
        if (this.isInconsistentWithSamplingRate(track, previous, fix, next)) {
            ++criteriaFulfilled;
        }
        if (OutlierFilter.hasInconsistentCogSog(previous, fix, next, 0.1, 10.0)) {
            ++criteriaFulfilled;
        }
        if (criteriaFulfilled >= 2) {
            Util.Pair<GPSFixMoving, Double> adjusted = this.adjust(previous, fix, track);
            if ((Double)adjusted.getB() > 0.5) {
                adjustedFixAndDistance = null;
            } else {
                adjustedFixAndDistance = adjusted;
                ++criteriaFulfilled;
            }
        } else {
            adjustedFixAndDistance = null;
        }
        assert (criteriaFulfilled >= 2 || adjustedFixAndDistance == null);
        return adjustedFixAndDistance;
    }

    public static boolean hasInconsistentCogSog(GPSFixMoving previous, GPSFixMoving fix, GPSFixMoving next, double SPEED_RATIO_TOLERANCE, double COURSE_DEGREE_TOLERANCE) {
        SpeedWithBearing inferredBetweenPreviousAndFix = previous.getSpeedAndBearingRequiredToReach((GPSFix)fix);
        SpeedWithBearing inferredBetweenFixAndNext = fix.getSpeedAndBearingRequiredToReach((GPSFix)next);
        SpeedWithBearing reportedByPrevious = previous.getSpeed();
        SpeedWithBearing reportedByFix = fix.getSpeed();
        SpeedWithBearing reportedByNext = next.getSpeed();
        return OutlierFilter.isConsistent(reportedByPrevious, reportedByNext, SPEED_RATIO_TOLERANCE, COURSE_DEGREE_TOLERANCE) && !OutlierFilter.isConsistent(reportedByPrevious, inferredBetweenPreviousAndFix, SPEED_RATIO_TOLERANCE, COURSE_DEGREE_TOLERANCE) && !OutlierFilter.isConsistent(inferredBetweenFixAndNext, reportedByFix, SPEED_RATIO_TOLERANCE, COURSE_DEGREE_TOLERANCE) && !OutlierFilter.isConsistent(inferredBetweenFixAndNext, reportedByNext, SPEED_RATIO_TOLERANCE, COURSE_DEGREE_TOLERANCE);
    }

    public static boolean isConsistent(double ratio, double tolerance) {
        return ratio < 1.0 + tolerance && ratio > 1.0 - tolerance;
    }

    public static boolean isConsistent(SpeedWithBearing a, SpeedWithBearing b, double SPEED_RATIO_TOLERANCE, double COURSE_DEGREE_TOLERANCE) {
        return OutlierFilter.isConsistent(a.getKnots() / b.getKnots(), SPEED_RATIO_TOLERANCE) && a.getBearing().getDifferenceTo(b.getBearing()).abs().getDegrees() < COURSE_DEGREE_TOLERANCE;
    }

    private boolean isInconsistentWithSamplingRate(DynamicGPSFixTrack<Competitor, GPSFixMoving> track, GPSFixMoving previous, GPSFixMoving fix, GPSFixMoving next) {
        double RATIO_TOLERANCE = 0.05;
        Duration averageIntervalBetweenFixes = track.getAverageIntervalBetweenFixes();
        double ratioPreviousToFix = previous.getTimePoint().until(fix.getTimePoint()).divide(averageIntervalBetweenFixes);
        double ratioFixToNext = fix.getTimePoint().until(next.getTimePoint()).divide(averageIntervalBetweenFixes);
        return !OutlierFilter.isConsistent(ratioPreviousToFix, 0.05) || !OutlierFilter.isConsistent(ratioFixToNext, 0.05);
    }

    private boolean hasNonZeroMilliseconds(TimePoint timePoint) {
        return timePoint.asMillis() % 1000L != 0L;
    }

    private Util.Pair<GPSFixMoving, Double> adjust(GPSFixMoving previous, GPSFixMoving fix, DynamicGPSFixTrack<Competitor, GPSFixMoving> track) {
        Iterator ascendingIterator = track.getFixesIterator(previous.getTimePoint(), true);
        Util.Pair<GPSFixMoving, Double> ascendingBestMatch = this.findBestMatch(fix, ascendingIterator);
        Iterator descendingIterator = track.getFixesDescendingIterator(fix.getTimePoint(), false);
        Util.Pair<GPSFixMoving, Double> descendingBestMatch = this.findBestMatch(fix, descendingIterator);
        return ascendingBestMatch != null && (descendingBestMatch == null || ((Double)ascendingBestMatch.getB()).compareTo((Double)descendingBestMatch.getB()) < 0) ? ascendingBestMatch : descendingBestMatch;
    }

    private Util.Pair<GPSFixMoving, Double> findBestMatch(GPSFixMoving fix, Iterator<GPSFixMoving> iterator) {
        Position fixPosition = fix.getPosition();
        GPSFixMoving lastFix = null;
        GPSFixMovingImpl result = null;
        MeterDistance minimum = new MeterDistance(Double.MAX_VALUE);
        boolean foundMinimum = false;
        Double distanceRatio = null;
        while (!foundMinimum && iterator.hasNext()) {
            GPSFixMoving currentFix = iterator.next();
            if (currentFix == fix) continue;
            if (lastFix != null) {
                Distance distanceFromSegment = fixPosition.getDistanceToLine(lastFix.getPosition(), currentFix.getPosition()).abs();
                if (distanceFromSegment.compareTo((Object)minimum) < 0) {
                    minimum = distanceFromSegment;
                    Bearing bearingFromLastToCurrent = lastFix.getPosition().getBearingGreatCircle(currentFix.getPosition());
                    Distance alongTrackDistanceFromLastFix = fixPosition.alongTrackDistance(lastFix.getPosition(), bearingFromLastToCurrent);
                    Distance distanceFromLastFixToCurrentFix = lastFix.getPosition().getDistance(currentFix.getPosition());
                    TimePoint inferredTimePointForFix = lastFix.getTimePoint().plus(lastFix.getTimePoint().until(currentFix.getTimePoint()).times(distanceFromLastFixToCurrentFix.equals(Distance.NULL) ? 0.5 : alongTrackDistanceFromLastFix.divide(distanceFromLastFixToCurrentFix)));
                    result = new GPSFixMovingImpl(fixPosition, inferredTimePointForFix, fix.getSpeed(), fix.getOptionalTrueHeading());
                    distanceRatio = distanceFromSegment.divide(distanceFromLastFixToCurrentFix);
                } else {
                    foundMinimum = true;
                }
            }
            lastFix = currentFix;
        }
        return foundMinimum ? new Util.Pair(result, distanceRatio) : null;
    }
}

