/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.tracking.MarkPositionAtTimePointCache;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;

public class NonCachingMarkPositionAtTimePointCache
implements MarkPositionAtTimePointCache {
    private final TrackedRace trackedRace;
    private final TimePoint timePoint;

    public NonCachingMarkPositionAtTimePointCache(TrackedRace trackedRace, TimePoint timePoint) {
        this.trackedRace = trackedRace;
        this.timePoint = timePoint;
    }

    @Override
    public Position getEstimatedPosition(Mark mark) {
        return this.trackedRace.getOrCreateTrack(mark).getEstimatedPosition(this.timePoint, false);
    }

    @Override
    public Position getApproximatePosition(Waypoint waypoint) {
        return this.trackedRace.getApproximatePosition(waypoint, this.timePoint, this);
    }

    @Override
    public Bearing getLegBearing(TrackedLeg trackedLeg) {
        return trackedLeg.getLegBearing(this.timePoint, this);
    }

    @Override
    public TrackedRace getTrackedRace() {
        return this.trackedRace;
    }

    @Override
    public TimePoint getTimePoint() {
        return this.timePoint;
    }
}

