/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.base.impl.SpeedWithBearingWithConfidenceImpl;
import com.sap.sailing.domain.base.impl.SpeedWithConfidenceImpl;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.confidence.BearingWithConfidenceCluster;
import com.sap.sailing.domain.common.confidence.ConfidenceBasedAverager;
import com.sap.sailing.domain.common.confidence.ConfidenceFactory;
import com.sap.sailing.domain.common.confidence.HasConfidence;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.confidence.impl.BearingWithConfidenceImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.NauticalMileDistance;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.shared.tracking.AddResult;
import com.sap.sailing.domain.shared.tracking.Track;
import com.sap.sailing.domain.shared.tracking.impl.MappedTrackImpl;
import com.sap.sailing.domain.shared.tracking.impl.PartialNavigableSetView;
import com.sap.sailing.domain.shared.tracking.impl.TimeRangeCache;
import com.sap.sailing.domain.shared.tracking.impl.TrackImpl;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.GPSTrackListener;
import com.sap.sailing.domain.tracking.SpeedWithBearingStep;
import com.sap.sailing.domain.tracking.SpeedWithBearingStepsIterable;
import com.sap.sailing.domain.tracking.impl.MaxSpeedCache;
import com.sap.sailing.domain.tracking.impl.SpeedWithBearingStepImpl;
import com.sap.sailing.domain.tracking.impl.TrackListenerCollection;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.TimeRangeImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GPSFixTrackImpl<ItemType, FixType extends GPSFix>
extends MappedTrackImpl<ItemType, FixType>
implements GPSFixTrack<ItemType, FixType> {
    private static final Logger logger = Logger.getLogger(GPSFixTrackImpl.class.getName());
    private static final long serialVersionUID = 2115321069242514378L;
    protected final Speed maxSpeedForSmoothing;
    private long millisecondsOverWhichToAverage;
    private final TrackListenerCollection<ItemType, FixType, GPSTrackListener<ItemType, FixType>> listeners;
    private boolean validityCachingSuspended;
    private transient TimeRangeCache<Distance> distanceCache;
    private transient MaxSpeedCache<ItemType, FixType> maxSpeedCache;
    private int estimatedSpeedCacheHits;
    private int estimatedSpeedCacheMisses;
    private final boolean losslessCompaction;

    protected GPSFixTrackImpl(ItemType trackedItem, long millisecondsOverWhichToAverage, boolean losslessCompaction) {
        this(trackedItem, millisecondsOverWhichToAverage, DEFAULT_MAX_SPEED_FOR_SMOOTHING, losslessCompaction);
    }

    protected GPSFixTrackImpl(ItemType trackedItem, long millisecondsOverWhichToAverage, Speed maxSpeedForSmoothening, boolean losslessCompaction) {
        super(trackedItem, String.valueOf(GPSFixTrackImpl.class.getSimpleName()) + (trackedItem == null ? "" : " for " + trackedItem.toString()));
        this.millisecondsOverWhichToAverage = millisecondsOverWhichToAverage;
        this.maxSpeedForSmoothing = maxSpeedForSmoothening;
        this.listeners = new TrackListenerCollection();
        this.distanceCache = new TimeRangeCache(trackedItem == null ? "null" : trackedItem.toString());
        this.maxSpeedCache = this.createMaxSpeedCache();
        this.validityCachingSuspended = false;
        this.losslessCompaction = losslessCompaction;
    }

    protected boolean isLosslessCompaction() {
        return this.losslessCompaction;
    }

    @Override
    public void suspendValidityAndMaxSpeedCaching() {
        this.validityCachingSuspended = true;
        this.removeListener(this.maxSpeedCache);
    }

    @Override
    public void resumeValidityAndMaxSpeedCaching() {
        this.lockForWrite();
        try {
            this.validityCachingSuspended = false;
            for (GPSFix fix : this.getRawFixes()) {
                fix.invalidateCache();
            }
        }
        finally {
            this.unlockAfterWrite();
        }
        this.maxSpeedCache = this.createMaxSpeedCache();
        this.getDistanceCache().clear();
    }

    protected MaxSpeedCache<ItemType, FixType> createMaxSpeedCache() {
        return new MaxSpeedCache(this);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.distanceCache = new TimeRangeCache(this.getTrackedItem().toString());
        this.maxSpeedCache = this.createMaxSpeedCache();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " for " + this.getTrackedItem();
    }

    @Override
    public void addListener(GPSTrackListener<ItemType, FixType> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeListener(GPSTrackListener<ItemType, FixType> listener) {
        this.listeners.removeListener(listener);
    }

    protected Iterable<GPSTrackListener<ItemType, FixType>> getListeners() {
        return this.listeners.getListeners();
    }

    protected FixType getDummyFix(TimePoint timePoint) {
        DummyGPSFix result = new DummyGPSFix(timePoint);
        return (FixType)((Object)result);
    }

    @Override
    public long getMillisecondsOverWhichToAverageSpeed() {
        return this.millisecondsOverWhichToAverage;
    }

    private Util.Pair<FixType, FixType> getFixesForPositionEstimation(TimePoint timePoint, boolean inclusive) {
        this.lockForRead();
        try {
            GPSFix lastFixBefore = inclusive ? (GPSFix)this.getLastFixAtOrBefore(timePoint) : (GPSFix)this.getLastFixBefore(timePoint);
            GPSFix firstFixAfter = inclusive ? (GPSFix)this.getFirstFixAtOrAfter(timePoint) : (GPSFix)this.getFirstFixAfter(timePoint);
            Util.Pair pair = new Util.Pair((Object)lastFixBefore, (Object)firstFixAfter);
            return pair;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public Iterator<Position> getEstimatedPositions(Iterable<Timed> timeds, boolean extrapolate) {
        return new EstimatedPositionIterator(timeds, extrapolate);
    }

    @Override
    public Position getEstimatedPosition(TimePoint timePoint, boolean extrapolate) {
        this.lockForRead();
        try {
            Util.Pair<FixType, FixType> fixesForPositionEstimation = this.getFixesForPositionEstimation(timePoint, true);
            Position position = this.getEstimatedPosition(timePoint, extrapolate, (GPSFix)fixesForPositionEstimation.getA(), (GPSFix)fixesForPositionEstimation.getB());
            return position;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public TimeRange getEstimatedPositionTimePeriodAffectedBy(GPSFix fix) {
        if (fix == null) {
            throw new IllegalArgumentException("fix must not be null");
        }
        this.lockForRead();
        try {
            Util.Pair<FixType, FixType> fixesForPositionEstimation = this.getFixesForPositionEstimation(fix.getTimePoint(), false);
            Object start = fix.equals(fixesForPositionEstimation.getA()) ? (this.getLastFixBefore(fix.getTimePoint()) == null ? new MillisecondsTimePoint(0L) : fix.getTimePoint()) : (fixesForPositionEstimation.getA() == null ? new MillisecondsTimePoint(0L) : ((GPSFix)fixesForPositionEstimation.getA()).getTimePoint());
            Object end = fix.equals(fixesForPositionEstimation.getB()) ? (this.getFirstFixAfter(fix.getTimePoint()) == null ? new MillisecondsTimePoint(Long.MAX_VALUE) : fix.getTimePoint()) : (fixesForPositionEstimation.getB() == null ? new MillisecondsTimePoint(Long.MAX_VALUE) : ((GPSFix)fixesForPositionEstimation.getB()).getTimePoint());
            TimeRangeImpl timeRangeImpl = new TimeRangeImpl(start, end);
            return timeRangeImpl;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public Position getEstimatedRawPosition(TimePoint timePoint, boolean extrapolate) {
        this.lockForRead();
        try {
            GPSFix lastFixAtOrBefore = (GPSFix)this.getLastRawFixAtOrBefore(timePoint);
            GPSFix firstFixAtOrAfter = (GPSFix)this.getFirstRawFixAtOrAfter(timePoint);
            Position position = this.getEstimatedPosition(timePoint, extrapolate, lastFixAtOrBefore, firstFixAtOrAfter);
            return position;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    Position getEstimatedPosition(TimePoint timePoint, boolean extrapolate, FixType lastFixAtOrBefore, FixType firstFixAtOrAfter) {
        assert (timePoint != null);
        assert (lastFixAtOrBefore == null || !timePoint.before(lastFixAtOrBefore.getTimePoint()));
        assert (firstFixAtOrAfter == null || !timePoint.after(firstFixAtOrAfter.getTimePoint()));
        Position result = lastFixAtOrBefore == null ? (firstFixAtOrAfter == null ? null : this.getEstimatedPosition(timePoint, firstFixAtOrAfter, extrapolate)) : (firstFixAtOrAfter == null ? this.getEstimatedPosition(timePoint, lastFixAtOrBefore, extrapolate) : this.getEstimatedPositionBetweenTwoValidFixes(timePoint, lastFixAtOrBefore, firstFixAtOrAfter));
        return result;
    }

    protected Position getEstimatedPositionBetweenTwoValidFixes(TimePoint timePoint, FixType lastFixAtOrBefore, FixType firstFixAtOrAfter) {
        assert (lastFixAtOrBefore != null);
        assert (firstFixAtOrAfter != null);
        assert (!timePoint.before(lastFixAtOrBefore.getTimePoint()));
        assert (!timePoint.after(firstFixAtOrAfter.getTimePoint()));
        return lastFixAtOrBefore.getPosition();
    }

    private Position getEstimatedPosition(TimePoint timePoint, FixType fix, boolean extrapolate) {
        Position result;
        assert (fix != null);
        if (extrapolate && fix instanceof GPSFixMoving) {
            SpeedWithBearing estimatedSpeed = ((GPSFixMoving)fix).getSpeed();
            Distance distance = estimatedSpeed.travel(fix.getTimePoint(), timePoint);
            result = fix.getPosition().translateGreatCircle(estimatedSpeed.getBearing(), distance);
        } else {
            result = fix.getPosition();
        }
        return result;
    }

    @Override
    public Util.Pair<FixType, Speed> getMaximumSpeedOverGround(TimePoint from, TimePoint to) {
        return this.maxSpeedCache.getMaxSpeed(from, to);
    }

    private NavigableSet<GPSFix> getGPSFixes() {
        NavigableSet<GPSFix> result = this.getInternalFixes();
        return result;
    }

    @Override
    public Duration getLongestIntervalBetweenTwoFixes(TimePoint from, TimePoint to) {
        long maxIntervalMillis = 0L;
        this.lockForRead();
        try {
            GPSFix previousFix = null;
            for (GPSFix fix : this.getFixes(from, true, to, true)) {
                if (previousFix == null) {
                    previousFix = fix;
                    continue;
                }
                long intervalMillis = fix.getTimePoint().asMillis() - previousFix.getTimePoint().asMillis();
                if (maxIntervalMillis < intervalMillis) {
                    maxIntervalMillis = intervalMillis;
                }
                previousFix = fix;
            }
        }
        finally {
            this.unlockAfterRead();
        }
        return new MillisecondsDurationImpl(maxIntervalMillis);
    }

    @Override
    public Distance getDistanceTraveled(TimePoint from, TimePoint to) {
        return (Distance)this.getValueSum(from, to, Distance.NULL, Distance::add, this.getDistanceCache(), (Track.TimeRangeValueCalculator)new Track.TimeRangeValueCalculator<Distance>(){

            public Distance calculate(TimePoint from, TimePoint to) {
                Distance.NullDistance distance = Distance.NULL;
                Position fromPos = GPSFixTrackImpl.this.getEstimatedPosition(from, false);
                if (fromPos != null) {
                    NavigableSet<DummyGPSFix> subset = GPSFixTrackImpl.this.getGPSFixes().subSet(new DummyGPSFix(from), false, new DummyGPSFix(to), false);
                    for (GPSFix gPSFix : subset) {
                        Distance distanceBetweenAdjacentFixes = fromPos.getDistance(gPSFix.getPosition());
                        distance = distance.add(distanceBetweenAdjacentFixes);
                        fromPos = gPSFix.getPosition();
                    }
                    Position position = GPSFixTrackImpl.this.getEstimatedPosition(to, false);
                    distance = distance.add(fromPos.getDistance(position));
                }
                return distance;
            }
        });
    }

    @Override
    public Distance getRawDistanceTraveled(TimePoint from, TimePoint to) {
        this.lockForRead();
        try {
            double distanceInNauticalMiles = 0.0;
            if (from.compareTo((Object)to) < 0) {
                Position fromPos = this.getEstimatedRawPosition(from, false);
                if (fromPos == null) {
                    Distance.NullDistance nullDistance = Distance.NULL;
                    return nullDistance;
                }
                NavigableSet<DummyGPSFix> subset = this.getInternalRawFixes().subSet(new DummyGPSFix(from), false, new DummyGPSFix(to), false);
                for (GPSFix gPSFix : subset) {
                    distanceInNauticalMiles += fromPos.getDistance(gPSFix.getPosition()).getNauticalMiles();
                    fromPos = gPSFix.getPosition();
                }
                Position position = this.getEstimatedRawPosition(to, false);
                NauticalMileDistance nauticalMileDistance = new NauticalMileDistance(distanceInNauticalMiles += fromPos.getDistance(position).getNauticalMiles());
                return nauticalMileDistance;
            }
            Distance.NullDistance nullDistance = Distance.NULL;
            return nullDistance;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public SpeedWithBearing getEstimatedSpeed(TimePoint at) {
        this.lockForRead();
        GPSFix ceil = (GPSFix)this.getInternalFixes().ceiling(this.createDummyGPSFix(at));
        try {
            SpeedWithBearing result;
            if (ceil != null && ceil.getTimePoint().equals(at) && ceil.isEstimatedSpeedCached()) {
                ++this.estimatedSpeedCacheHits;
                result = ceil.getCachedEstimatedSpeed();
            } else {
                ++this.estimatedSpeedCacheMisses;
                SpeedWithBearingWithConfidence<TimePoint> estimatedSpeed = this.getEstimatedSpeed(at, this.getInternalFixes(), (Weigher<TimePoint>)ConfidenceFactory.INSTANCE.createExponentialTimeDifferenceWeigher(this.getMillisecondsOverWhichToAverageSpeed() / 2L, 1.0E-8));
                SpeedWithBearing speedWithBearing = result = estimatedSpeed == null ? null : estimatedSpeed.getObject();
                if (estimatedSpeed != null && ceil != null && ceil.getTimePoint().equals(at)) {
                    ceil.cacheEstimatedSpeed(result);
                }
            }
            if (logger.isLoggable(Level.FINEST) && (this.estimatedSpeedCacheHits + this.estimatedSpeedCacheMisses) % 1000 == 0) {
                logger.finest("estimated speed cache hits/misses: " + this.estimatedSpeedCacheHits + "/" + this.estimatedSpeedCacheMisses);
            }
            SpeedWithBearing speedWithBearing = result;
            return speedWithBearing;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public SpeedWithBearing getRawEstimatedSpeed(TimePoint at) {
        this.lockForRead();
        try {
            SpeedWithBearing speedWithBearing = this.getEstimatedSpeed(at, this.getRawFixes(), (Weigher<TimePoint>)ConfidenceFactory.INSTANCE.createExponentialTimeDifferenceWeigher(this.getMillisecondsOverWhichToAverageSpeed(), 1.0E-8)).getObject();
            return speedWithBearing;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public SpeedWithBearingWithConfidence<TimePoint> getEstimatedSpeed(TimePoint at, Weigher<TimePoint> weigher) {
        this.lockForRead();
        try {
            SpeedWithBearingWithConfidence<TimePoint> speedWithBearingWithConfidence = this.getEstimatedSpeed(at, this.getInternalFixes(), weigher);
            return speedWithBearingWithConfidence;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public SpeedWithBearingWithConfidence<TimePoint> getRawEstimatedSpeed(TimePoint at, Weigher<TimePoint> weigher) {
        this.lockForRead();
        try {
            SpeedWithBearingWithConfidence<TimePoint> speedWithBearingWithConfidence = this.getEstimatedSpeed(at, this.getRawFixes(), weigher);
            return speedWithBearingWithConfidence;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    protected SpeedWithBearingWithConfidence<TimePoint> getEstimatedSpeed(TimePoint at, NavigableSet<FixType> fixesToUseForSpeedEstimation, Weigher<TimePoint> weigher) {
        this.lockForRead();
        try {
            SpeedWithBearingWithConfidenceImpl<TimePoint> result;
            List<FixType> relevantFixes = this.getFixesRelevantForSpeedEstimation(at, fixesToUseForSpeedEstimation);
            ArrayList<SpeedWithConfidence<TimePoint>> speeds = new ArrayList<SpeedWithConfidence<TimePoint>>();
            BearingWithConfidenceCluster bearingCluster = new BearingWithConfidenceCluster(weigher);
            GPSFix last = null;
            for (GPSFix next : relevantFixes) {
                if (last != null) {
                    this.aggregateSpeedAndBearingFromLastToNext(speeds, (BearingWithConfidenceCluster<TimePoint>)bearingCluster, last, next);
                }
                last = next;
            }
            ConfidenceBasedAverager speedAverager = ConfidenceFactory.INSTANCE.createAverager(weigher);
            HasConfidence speedWithConfidence = speedAverager.getAverage(speeds, (Object)at);
            BearingWithConfidence bearingAverage = bearingCluster.getAverage((Object)at);
            Bearing bearing = bearingAverage == null ? null : (Bearing)bearingAverage.getObject();
            KnotSpeedWithBearingImpl avgSpeed = speedWithConfidence == null || bearing == null ? null : new KnotSpeedWithBearingImpl(((Speed)speedWithConfidence.getObject()).getKnots(), bearing);
            SpeedWithBearingWithConfidenceImpl<TimePoint> speedWithBearingWithConfidenceImpl = result = avgSpeed == null ? null : new SpeedWithBearingWithConfidenceImpl<TimePoint>((SpeedWithBearing)avgSpeed, (bearingAverage.getConfidence() + speedWithConfidence.getConfidence()) / 2.0, at);
            return speedWithBearingWithConfidenceImpl;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    protected void aggregateSpeedAndBearingFromLastToNext(List<SpeedWithConfidence<TimePoint>> speeds, BearingWithConfidenceCluster<TimePoint> bearingCluster, GPSFix last, GPSFix next) {
        MillisecondsTimePoint relativeTo = new MillisecondsTimePoint((last.getTimePoint().asMillis() + next.getTimePoint().asMillis()) / 2L);
        Speed speed = last.getPosition().getDistance(next.getPosition()).inTime(next.getTimePoint().asMillis() - last.getTimePoint().asMillis());
        SpeedWithConfidenceImpl<MillisecondsTimePoint> speedWithConfidence = new SpeedWithConfidenceImpl<MillisecondsTimePoint>(speed, 0.9, relativeTo);
        speeds.add(speedWithConfidence);
        double bearingConfidence = 0.9;
        if (speed.getKnots() < 0.001) {
            bearingConfidence = 0.0;
        }
        bearingCluster.add((BearingWithConfidence)new BearingWithConfidenceImpl(last.getPosition().getBearingGreatCircle(next.getPosition()), bearingConfidence, (Object)relativeTo));
    }

    /*
     * Unable to fully structure code
     */
    protected TimeRange getTimeIntervalWhoseEstimatedSpeedMayHaveChangedAfterAddingFix(FixType fix) {
        intervalStart = null;
        intervalEnd = null;
        this.lockForRead();
        try {
            beforeSet = this.getInternalRawFixes().headSet(fix, false);
            afterSet = this.getInternalRawFixes().tailSet(fix, true);
            beforeFix = null;
            beforeFixIter = beforeSet.descendingIterator();
            if (true) ** GOTO lbl12
            do {
                intervalStart = beforeFix.getTimePoint();
lbl12:
                // 2 sources

                if (!beforeFixIter.hasNext()) break;
                beforeFix = (GPSFix)beforeFixIter.next();
            } while (fix.getTimePoint().asMillis() - beforeFix.getTimePoint().asMillis() < this.getMillisecondsOverWhichToAverage() / 2L);
            if (intervalStart == null && beforeFixIter.hasNext()) {
                intervalStartCandidate = ((GPSFix)beforeFixIter.next()).getTimePoint();
                if (beforeFixIter.hasNext()) {
                    nextNeighboursTimePoint = ((GPSFix)beforeFixIter.next()).getTimePoint();
                    if (intervalStartCandidate.asMillis() - nextNeighboursTimePoint.asMillis() > fix.getTimePoint().asMillis() - intervalStartCandidate.asMillis()) {
                        intervalStart = intervalStartCandidate;
                    }
                } else {
                    intervalStart = intervalStartCandidate;
                }
            }
            if (intervalStart == null) {
                intervalStart = fix.getTimePoint();
            }
            afterFix = null;
            afterFixIter = afterSet.iterator();
            while (afterFixIter.hasNext() && (afterFix = (GPSFix)afterFixIter.next()).getTimePoint().asMillis() - fix.getTimePoint().asMillis() < this.getMillisecondsOverWhichToAverage() / 2L) {
                intervalEnd = afterFix.getTimePoint();
            }
            if (intervalEnd == null && afterFixIter.hasNext()) {
                intervalEndCandidate = ((GPSFix)afterFixIter.next()).getTimePoint();
                if (afterFixIter.hasNext()) {
                    nextNeighboursTimePoint = ((GPSFix)afterFixIter.next()).getTimePoint();
                    if (nextNeighboursTimePoint.asMillis() - intervalEndCandidate.asMillis() > intervalEndCandidate.asMillis() - fix.getTimePoint().asMillis()) {
                        intervalEnd = intervalEndCandidate;
                    }
                } else {
                    intervalEnd = intervalEndCandidate;
                }
            }
            if (intervalEnd == null) {
                intervalEnd = fix.getTimePoint();
            }
        }
        finally {
            this.unlockAfterRead();
        }
        return new TimeRangeImpl(intervalStart, intervalEnd, true);
    }

    protected FixType createDummyGPSFix(TimePoint at) {
        DummyGPSFix result = new DummyGPSFix(at);
        return (FixType)((Object)result);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected List<FixType> getFixesRelevantForSpeedEstimation(TimePoint at, NavigableSet<FixType> fixesToUseForSpeedEstimation) {
        this.lockForRead();
        try {
            atTimed = this.createDummyGPSFix(at);
            relevantFixes = new LinkedList<GPSFix>();
            beforeSet = fixesToUseForSpeedEstimation.headSet(atTimed, false);
            afterSet = fixesToUseForSpeedEstimation.tailSet(atTimed, true);
            beforeFix /* !! */  = null;
            beforeFixIter = beforeSet.descendingIterator();
            noBeforeFixUsedYet = true;
            if (true) ** GOTO lbl15
            do {
                relevantFixes.add(0, beforeFix /* !! */ );
                noBeforeFixUsedYet = false;
                beforeFix /* !! */  = null;
lbl15:
                // 2 sources

                if (!beforeFixIter.hasNext()) break;
                beforeFix /* !! */  = (GPSFix)beforeFixIter.next();
            } while (at.asMillis() - beforeFix /* !! */ .getTimePoint().asMillis() < this.getMillisecondsOverWhichToAverage() / 2L || noBeforeFixUsedYet);
            afterFix = null;
            afterFixIter = afterSet.iterator();
            noAfterFixUsedYet = true;
            while (afterFixIter.hasNext() && ((afterFix = (GPSFix)afterFixIter.next()).getTimePoint().asMillis() - at.asMillis() < this.getMillisecondsOverWhichToAverage() / 2L || noAfterFixUsedYet)) {
                relevantFixes.add(afterFix);
                noAfterFixUsedYet = false;
                afterFix = null;
            }
            while (relevantFixes.size() < 2 && (beforeFix /* !! */  != null || afterFix != null)) {
                if (afterFix == null) {
                    if (beforeFix /* !! */  == null) continue;
                    relevantFixes.add(0, beforeFix /* !! */ );
                    if (beforeFixIter.hasNext()) {
                        beforeFix /* !! */  = (GPSFix)beforeFixIter.next();
                        continue;
                    }
                    beforeFix /* !! */  = null;
                    continue;
                }
                if (beforeFix /* !! */  == null) {
                    relevantFixes.add(afterFix);
                    if (afterFixIter.hasNext()) {
                        afterFix = (GPSFix)afterFixIter.next();
                        continue;
                    }
                    afterFix = null;
                    continue;
                }
                if (afterFix.getTimePoint().asMillis() - at.asMillis() < beforeFix /* !! */ .getTimePoint().asMillis() - at.asMillis()) {
                    relevantFixes.add(afterFix);
                    if (afterFixIter.hasNext()) {
                        afterFix = (GPSFix)afterFixIter.next();
                        continue;
                    }
                    afterFix = null;
                    continue;
                }
                relevantFixes.add(0, beforeFix /* !! */ );
                beforeFix /* !! */  = beforeFixIter.hasNext() != false ? (GPSFix)beforeFixIter.next() : null;
            }
            var14_13 = relevantFixes;
            return var14_13;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    protected long getMillisecondsOverWhichToAverage() {
        return this.millisecondsOverWhichToAverage;
    }

    protected NavigableSet<FixType> getInternalFixes() {
        this.assertReadLock();
        return new PartialNavigableSetView<FixType>(super.getInternalFixes()){

            protected boolean isValid(FixType e) {
                return GPSFixTrackImpl.this.isValid(GPSFixTrackImpl.this.getRawFixes(), e);
            }
        };
    }

    @Override
    public boolean isValid(FixType e) {
        return this.isValid(this.getInternalFixes(), e);
    }

    protected boolean isValid(NavigableSet<FixType> rawFixes, FixType e) {
        boolean isValid;
        this.assertReadLock();
        if (this.maxSpeedForSmoothing == null) {
            isValid = true;
        } else if (e.isValidityCached()) {
            isValid = e.isValidCached();
        } else {
            GPSFix previous = (GPSFix)rawFixes.lower(e);
            boolean atLeastOnePreviousFixInRange = previous != null && e.getTimePoint().asMillis() - previous.getTimePoint().asMillis() <= this.getMillisecondsOverWhichToAverageSpeed();
            Speed speedToPrevious = null;
            boolean foundValidPreviousFixInRange = false;
            while (previous != null && !foundValidPreviousFixInRange && e.getTimePoint().asMillis() - previous.getTimePoint().asMillis() <= this.getMillisecondsOverWhichToAverageSpeed()) {
                speedToPrevious = previous.getPosition().getDistance(e.getPosition()).inTime(e.getTimePoint().asMillis() - previous.getTimePoint().asMillis());
                foundValidPreviousFixInRange = speedToPrevious.compareTo((Object)this.maxSpeedForSmoothing) <= 0;
                previous = rawFixes.lower(previous);
            }
            boolean foundValidNextFixInRange = false;
            boolean atLeastOneNextFixInRange = false;
            if (!atLeastOnePreviousFixInRange || foundValidPreviousFixInRange) {
                GPSFix next = (GPSFix)rawFixes.higher(e);
                atLeastOneNextFixInRange = next != null && next.getTimePoint().asMillis() - e.getTimePoint().asMillis() <= this.getMillisecondsOverWhichToAverageSpeed();
                Speed speedToNext = null;
                while (next != null && !foundValidNextFixInRange && next.getTimePoint().asMillis() - e.getTimePoint().asMillis() <= this.getMillisecondsOverWhichToAverageSpeed()) {
                    speedToNext = e.getPosition().getDistance(next.getPosition()).inTime(next.getTimePoint().asMillis() - e.getTimePoint().asMillis());
                    foundValidNextFixInRange = speedToNext.compareTo((Object)this.maxSpeedForSmoothing) <= 0;
                    next = rawFixes.higher(next);
                }
            }
            isValid = !(atLeastOnePreviousFixInRange && !foundValidPreviousFixInRange || atLeastOneNextFixInRange && !foundValidNextFixInRange);
            e.cacheValidity(isValid);
        }
        return isValid;
    }

    private void invalidateValidityAndEstimatedSpeedAndDistanceCaches(FixType gpsFix) {
        this.assertWriteLock();
        TimePoint distanceCacheInvalidationStart = gpsFix.getTimePoint();
        GPSFix last = (GPSFix)this.getInternalFixes().lower(gpsFix);
        if (last != null) {
            distanceCacheInvalidationStart = last.getTimePoint().plus(1L);
        }
        gpsFix.invalidateCache();
        for (GPSFix fixOnWhichToInvalidateEstimatedSpeed : this.getFixesRelevantForSpeedEstimation(gpsFix.getTimePoint(), this.getInternalRawFixes())) {
            fixOnWhichToInvalidateEstimatedSpeed.invalidateEstimatedSpeedCache();
        }
        Iterable<FixType> lowers = this.getEarlierFixesWhoseValidityMayBeAffected(gpsFix);
        for (GPSFix lower : lowers) {
            boolean lowerWasValid = this.isValid(this.getRawFixes(), lower);
            lower.invalidateCache();
            boolean lowerIsValid = this.isValid(this.getRawFixes(), lower);
            if (lowerIsValid == lowerWasValid || !lower.getTimePoint().before(distanceCacheInvalidationStart)) continue;
            distanceCacheInvalidationStart = lower.getTimePoint();
        }
        this.getDistanceCache().invalidateAllAtOrLaterThan(distanceCacheInvalidationStart);
        Iterable<FixType> highers = this.getLaterFixesWhoseValidityMayBeAffected(gpsFix);
        for (GPSFix higher : highers) {
            higher.invalidateCache();
        }
    }

    protected Iterable<FixType> getLaterFixesWhoseValidityMayBeAffected(FixType gpsFix) {
        GPSFix higher = (GPSFix)this.getInternalRawFixes().higher(gpsFix);
        if (higher == null) {
            return Collections.emptySet();
        }
        ArrayList<GPSFix> result = new ArrayList<GPSFix>();
        while (higher != null && higher.getTimePoint().asMillis() - gpsFix.getTimePoint().asMillis() <= this.getMillisecondsOverWhichToAverageSpeed()) {
            result.add(higher);
            higher = this.getInternalRawFixes().higher(higher);
        }
        return result;
    }

    protected Iterable<FixType> getEarlierFixesWhoseValidityMayBeAffected(FixType gpsFix) {
        GPSFix lower = (GPSFix)this.getInternalRawFixes().lower(gpsFix);
        if (lower == null) {
            return Collections.emptySet();
        }
        ArrayList<GPSFix> result = new ArrayList<GPSFix>();
        while (lower != null && gpsFix.getTimePoint().asMillis() - lower.getTimePoint().asMillis() <= this.getMillisecondsOverWhichToAverageSpeed()) {
            result.add(lower);
            lower = this.getInternalRawFixes().lower(lower);
        }
        return result;
    }

    @Override
    public boolean hasDirectionChange(TimePoint at, double minimumDegreeDifference) {
        this.lockForRead();
        try {
            boolean result = false;
            MillisecondsTimePoint start = new MillisecondsTimePoint(at.asMillis() - this.getMillisecondsOverWhichToAverageSpeed());
            MillisecondsTimePoint end = new MillisecondsTimePoint(at.asMillis() + this.getMillisecondsOverWhichToAverageSpeed());
            SpeedWithBearing estimatedSpeedAtStart = this.getEstimatedSpeed((TimePoint)start);
            if (estimatedSpeedAtStart != null) {
                Bearing bearingAtStart = estimatedSpeedAtStart.getBearing();
                MillisecondsTimePoint next = new MillisecondsTimePoint(start.asMillis() + Math.max(1000L, this.getMillisecondsOverWhichToAverageSpeed() / 2L));
                while (!result && next.compareTo((Object)end) <= 0) {
                    SpeedWithBearing estimatedSpeedAtNext = this.getEstimatedSpeed((TimePoint)next);
                    if (estimatedSpeedAtNext != null) {
                        Bearing bearingAtNext = estimatedSpeedAtNext.getBearing();
                        result = Math.abs(bearingAtStart.getDifferenceTo(bearingAtNext).getDegrees()) > minimumDegreeDifference;
                    }
                    next = new MillisecondsTimePoint(next.asMillis() + Math.max(1000L, this.getMillisecondsOverWhichToAverageSpeed() / 2L));
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    protected TimeRangeCache<Distance> getDistanceCache() {
        return this.distanceCache;
    }

    protected boolean add(FixType fix, boolean replace) {
        boolean result;
        AddResult addResult;
        boolean firstFixInTrack;
        this.lockForWrite();
        try {
            firstFixInTrack = this.getRawFixes().isEmpty();
            addResult = this.addWithoutLocking((Timed)fix, replace);
            if (addResult != AddResult.NOT_ADDED && !this.validityCachingSuspended) {
                this.invalidateValidityAndEstimatedSpeedAndDistanceCaches(fix);
            }
        }
        finally {
            this.unlockAfterWrite();
        }
        if (logger.isLoggable(Level.FINEST)) {
            this.lockForRead();
            try {
                GPSFix gPSFix = (GPSFix)this.getInternalRawFixes().lower(fix);
                logger.finest("GPS fix " + fix + " for " + this.getTrackedItem() + ", isValid=" + this.isValid(this.getInternalRawFixes(), fix) + ", time/distance/speed from last: " + (gPSFix == null ? "null" : String.valueOf(fix.getTimePoint().asMillis() - gPSFix.getTimePoint().asMillis()) + "ms/" + fix.getPosition().getDistance(gPSFix.getPosition()) + "/" + fix.getPosition().getDistance(gPSFix.getPosition()).inTime(fix.getTimePoint().asMillis() - gPSFix.getTimePoint().asMillis())));
            }
            finally {
                this.unlockAfterRead();
            }
        }
        boolean bl = result = addResult == AddResult.ADDED || addResult == AddResult.REPLACED;
        if (result) {
            for (GPSTrackListener<Object, FixType> gPSTrackListener : this.getListeners()) {
                gPSTrackListener.gpsFixReceived(fix, this.getTrackedItem(), firstFixInTrack, addResult);
            }
        }
        return result;
    }

    protected void setMillisecondsOverWhichToAverage(long millisecondsOverWhichToAverage) {
        long oldMillis = this.getMillisecondsOverWhichToAverage();
        this.millisecondsOverWhichToAverage = millisecondsOverWhichToAverage;
        for (GPSTrackListener<ItemType, FixType> listener : this.getListeners()) {
            listener.speedAveragingChanged(oldMillis, millisecondsOverWhichToAverage);
        }
    }

    public static Speed getDefaultMaxSpeedForSmoothing() {
        return DEFAULT_MAX_SPEED_FOR_SMOOTHING;
    }

    @Override
    public SpeedWithBearingStepsIterable getSpeedWithBearingSteps(TimePoint fromTimePoint, TimePoint toTimePoint) {
        ArrayList<SpeedWithBearingStep> speedWithBearingSteps = new ArrayList<SpeedWithBearingStep>();
        Bearing lastCourse = null;
        TimePoint lastTimePoint = null;
        double lastCourseChangeAngleInDegrees = 0.0;
        try {
            this.lockForRead();
            GPSFix firstFix = (GPSFix)this.getLastFixAtOrBefore(fromTimePoint);
            TimePoint currentTimePoint = firstFix == null ? fromTimePoint : firstFix.getTimePoint();
            Iterator iterator = this.getFixesIterator(currentTimePoint, false);
            while (iterator.hasNext()) {
                SpeedWithBearing estimatedSpeed = this.getEstimatedSpeed(currentTimePoint);
                if (estimatedSpeed != null) {
                    Bearing course = estimatedSpeed.getBearing();
                    double courseChangeAngleInDegrees = lastCourse == null ? 0.0 : lastCourse.getDifferenceTo(course, (Bearing)new DegreeBearingImpl(lastCourseChangeAngleInDegrees)).getDegrees();
                    double turningRateInDegreesPerSecond = lastTimePoint == null ? 0.0 : Math.abs(courseChangeAngleInDegrees / lastTimePoint.until(currentTimePoint).asSeconds());
                    speedWithBearingSteps.add(new SpeedWithBearingStepImpl(currentTimePoint, estimatedSpeed, courseChangeAngleInDegrees, turningRateInDegreesPerSecond));
                    if (currentTimePoint.after(toTimePoint)) {
                        break;
                    }
                    lastCourse = course;
                    lastCourseChangeAngleInDegrees = courseChangeAngleInDegrees;
                    lastTimePoint = currentTimePoint;
                }
                if (!currentTimePoint.before(toTimePoint)) {
                    break;
                }
                currentTimePoint = ((GPSFix)iterator.next()).getTimePoint();
            }
        }
        finally {
            this.unlockAfterRead();
        }
        return new SpeedWithBearingStepsIterable(speedWithBearingSteps);
    }

    private class DummyGPSFix
    extends TrackImpl.DummyTimed
    implements GPSFix {
        private static final long serialVersionUID = -6258506654181816698L;

        public DummyGPSFix(TimePoint timePoint) {
            super(timePoint);
        }

        public Position getPosition() {
            return null;
        }

        public SpeedWithBearing getSpeedAndBearingRequiredToReach(GPSFix to) {
            return null;
        }

        public boolean isValidityCached() {
            return false;
        }

        public boolean isValidCached() {
            return false;
        }

        public void invalidateCache() {
        }

        public void cacheValidity(boolean isValid) {
        }

        public boolean isEstimatedSpeedCached() {
            return false;
        }

        public SpeedWithBearing getCachedEstimatedSpeed() {
            return null;
        }

        public void invalidateEstimatedSpeedCache() {
        }

        public void cacheEstimatedSpeed(SpeedWithBearing estimatedSpeed) {
        }
    }

    private class EstimatedPositionIterator
    implements Iterator<Position> {
        private final Iterator<Timed> timedsIter;
        private final boolean extrapolate;
        private final NavigableSet<FixType> fixes;
        private Iterator<FixType> subSetIterator;
        private FixType earlierFix;
        private FixType laterFix;

        public EstimatedPositionIterator(Iterable<Timed> timeds, boolean extrapolate) {
            this.timedsIter = timeds.iterator();
            this.extrapolate = extrapolate;
            this.fixes = GPSFixTrackImpl.this.getFixes();
        }

        @Override
        public boolean hasNext() {
            return this.timedsIter.hasNext();
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public Position next() {
            block1: {
                nextTimePoint = this.timedsIter.next().getTimePoint();
                if (this.subSetIterator != null) ** GOTO lbl9
                this.earlierFix = (GPSFix)GPSFixTrackImpl.this.getLastFixAtOrBefore(nextTimePoint);
                this.subSetIterator = this.fixes.subSet(GPSFixTrackImpl.this.createDummyGPSFix(nextTimePoint), true, (GPSFix)this.fixes.last(), true).iterator();
                this.laterFix = this.subSetIterator.hasNext() != false ? (GPSFix)this.subSetIterator.next() : null;
                break block1;
lbl-1000:
                // 1 sources

                {
                    this.earlierFix = this.laterFix;
                    v0 /* !! */  = this.laterFix = this.subSetIterator.hasNext() != false ? (GPSFix)this.subSetIterator.next() : null;
lbl9:
                    // 2 sources

                    ** while (this.laterFix != null && this.laterFix.getTimePoint().before((TimePoint)nextTimePoint))
                }
            }
            return GPSFixTrackImpl.this.getEstimatedPosition(nextTimePoint, this.extrapolate, this.earlierFix, this.laterFix);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

