/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.MarkPositionAtTimePointCache;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.LinkedHashMap;

public interface TrackedLeg
extends Serializable {
    public Leg getLeg();

    public Iterable<TrackedLegOfCompetitor> getTrackedLegsOfCompetitors();

    public TrackedLegOfCompetitor getTrackedLeg(Competitor var1);

    public TrackedRace getTrackedRace();

    public boolean isUpOrDownwindLeg(TimePoint var1) throws NoWindException;

    public LegType getLegType(TimePoint var1) throws NoWindException;

    public LinkedHashMap<Competitor, Integer> getRanks(TimePoint var1);

    public LinkedHashMap<Competitor, Integer> getRanks(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Bearing getLegBearing(TimePoint var1);

    public Bearing getLegBearing(TimePoint var1, MarkPositionAtTimePointCache var2);

    public Distance getAbsoluteCrossTrackError(Position var1, TimePoint var2);

    public Distance getSignedCrossTrackError(Position var1, TimePoint var2);

    public Distance getUnsignedCrossTrackErrorToWindAxis(Position var1, TimePoint var2);

    public Distance getSignedCrossTrackErrorToWindAxis(Position var1, TimePoint var2);

    public void waypointsMayHaveChanges();

    public Distance getGreatCircleDistance(TimePoint var1);

    public Distance getGreatCircleDistance(TimePoint var1, MarkPositionAtTimePointCache var2);

    public Distance getAbsoluteWindwardDistance(Position var1, Position var2, TimePoint var3, WindPositionMode var4);

    public Distance getAbsoluteWindwardDistance(Position var1, Position var2, TimePoint var3, WindPositionMode var4, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var5);

    public Distance getWindwardDistance(Position var1, Position var2, TimePoint var3, WindPositionMode var4, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var5);

    public Distance getWindwardDistance(Position var1, Position var2, TimePoint var3, WindPositionMode var4);

    public Distance getWindwardDistance(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Distance getWindwardDistance(LegType var1, TimePoint var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    public Distance getAbsoluteWindwardDistance(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Distance getWindwardDistance();

    public Distance getWindwardDistance(WindLegTypeAndLegBearingAndORCPerformanceCurveCache var1);

    public Distance getWindwardDistance(LegType var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Distance getAbsoluteWindwardDistance(WindLegTypeAndLegBearingAndORCPerformanceCurveCache var1);

    public Position getMiddleOfLeg(TimePoint var1);

    public Position getMiddleOfLeg(TimePoint var1, MarkPositionAtTimePointCache var2);

    public Iterable<Position> getEquidistantSectionsOfLeg(TimePoint var1, int var2);

    public TargetTimeInfo.LegTargetTimeInfo getEstimatedTimeAndDistanceToComplete(PolarDataService var1, TimePoint var2, MarkPositionAtTimePointCache var3) throws NotEnoughDataHasBeenAddedException, NoWindException;

    public Distance getAbsoluteWindwardDistanceFromLegStart(Position var1);

    public Distance getAbsoluteWindwardDistanceFromLegStart(Position var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Distance getWindwardDistanceFromLegStart(Position var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Distance getWindwardDistanceFromLegStart(LegType var1, Position var2, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var3);

    public WindWithConfidence<Util.Pair<Position, TimePoint>> getAverageTrueWindDirection();

    public TimePoint getReferenceTimePoint();

    public Iterable<TimePoint> getEquidistantReferenceTimePoints(int var1);

    public WindWithConfidence<Util.Pair<Position, TimePoint>> getAverageWind(int var1);

    public Competitor getLeader(TimePoint var1);

    public Competitor getLeader(TimePoint var1, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var2);

    public Bearing getTWA(TimePoint var1) throws NoWindException;

    default public Bearing getTWA() throws NoWindException {
        return this.getTWA(this.getReferenceTimePoint());
    }
}

