/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.orc.ORCPerformanceCurve;
import com.sap.sailing.domain.orc.impl.ORCPerformanceCurveByImpliedWindRankingMetric;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math.FunctionEvaluationException;

public class ORCPerformanceCurveRankingMetric
extends ORCPerformanceCurveByImpliedWindRankingMetric {
    private static final Logger logger = Logger.getLogger(ORCPerformanceCurveRankingMetric.class.getName());
    private static final long serialVersionUID = -439454462181040266L;

    public ORCPerformanceCurveRankingMetric(TrackedRace trackedRace) {
        super(trackedRace);
    }

    @Override
    public RankingMetrics getType() {
        return RankingMetrics.ORC_PERFORMANCE_CURVE;
    }

    @Override
    public Comparator<Competitor> getRaceRankingComparator(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getRaceRankingComparator(timePoint, this.getRelativeCorrectedTimesByCompetitor(timePoint, cache));
    }

    private Comparator<Competitor> getRaceRankingComparator(TimePoint timePoint, Map<Competitor, Duration> relativeCorrectedTimesByCompetitor) {
        return (c1, c2) -> Comparator.nullsLast((correctedTime1, correctedTime2) -> correctedTime1.compareTo(correctedTime2)).compare((Duration)relativeCorrectedTimesByCompetitor.get(c1), (Duration)relativeCorrectedTimesByCompetitor.get(c2));
    }

    @Override
    public Comparator<TrackedLegOfCompetitor> getLegRankingComparator(TrackedLeg trackedLeg, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        HashMap<Competitor, Duration> relativeCorrectedTimeByCompetitor = new HashMap<Competitor, Duration>();
        for (Competitor competitor : this.getTrackedRace().getRace().getCompetitors()) {
            Duration relativeCorrectedTime = trackedLeg.getTrackedLeg(competitor).hasFinishedLeg(timePoint) ? cache.getRelativeCorrectedTime(competitor, this.getTrackedRace(), trackedLeg.getTrackedLeg(competitor).getFinishTime(), (c, t) -> this.getRelativeCorrectedTime((Competitor)c, (TimePoint)t, cache)) : cache.getRelativeCorrectedTime(competitor, this.getTrackedRace(), timePoint, (c, t) -> this.getRelativeCorrectedTime((Competitor)c, (TimePoint)t, cache));
            relativeCorrectedTimeByCompetitor.put(competitor, relativeCorrectedTime);
        }
        return (tloc1, tloc2) -> {
            boolean hasStarted1 = tloc1.hasStartedLeg(timePoint);
            boolean hasStarted2 = tloc2.hasStartedLeg(timePoint);
            int result = !hasStarted1 ? (!hasStarted2 ? 0 : 1) : (!hasStarted2 ? -1 : Comparator.nullsLast((relativeCorrectedTime1, relativeCorrectedTime2) -> relativeCorrectedTime1.compareTo(relativeCorrectedTime2)).compare((Duration)relativeCorrectedTimeByCompetitor.get(tloc1.getCompetitor()), (Duration)relativeCorrectedTimeByCompetitor.get(tloc2.getCompetitor())));
            return result;
        };
    }

    private Map<Competitor, Duration> getRelativeCorrectedTimesByCompetitor(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        HashMap<Competitor, Duration> relativeCorrectedTimesByCompetitor = new HashMap<Competitor, Duration>();
        for (Competitor competitor : this.getTrackedRace().getRace().getCompetitors()) {
            relativeCorrectedTimesByCompetitor.put(competitor, cache.getRelativeCorrectedTime(competitor, this.getTrackedRace(), timePoint, (c, t) -> this.getRelativeCorrectedTime((Competitor)c, (TimePoint)t, cache)));
        }
        return relativeCorrectedTimesByCompetitor;
    }

    @Override
    public Duration getCorrectedTime(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result;
        Duration competitorDelta = this.getRelativeCorrectedTime(competitor, timePoint, cache);
        if (competitorDelta != null) {
            Competitor baseLineCompetitor = this.getBaseLineCompetitorForAbsoluteCorrectedTimes(timePoint, cache);
            if (baseLineCompetitor != null) {
                Duration baseLineCompetitorRelativeCorrectedTime = this.getRelativeCorrectedTime(baseLineCompetitor, timePoint, cache);
                Duration baseLineCompetitorElapsedTime = this.getTrackedRace().getTimeSailedSinceRaceStart(baseLineCompetitor, timePoint);
                result = baseLineCompetitorElapsedTime != null ? baseLineCompetitorElapsedTime.plus(competitorDelta).minus(baseLineCompetitorRelativeCorrectedTime == null ? Duration.NULL : baseLineCompetitorRelativeCorrectedTime) : null;
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    protected Competitor getBaseLineCompetitorForAbsoluteCorrectedTimes(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Competitor result = this.getExplicitScratchBoat() != null ? this.getExplicitScratchBoat() : this.getTrackedRace().getCompetitorOfBoat(this.getBoatWithLeastGph());
        return result;
    }

    private Duration getRelativeCorrectedTime(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration competitorDelta;
        try {
            BiFunction<TimePoint, Competitor, ORCPerformanceCurve> performanceCurveSupplier = this.getPerformanceCurveSupplier(cache);
            ORCPerformanceCurve competitorPerformanceCurve = cache.getPerformanceCurveForPartialCourse(timePoint, this.getTrackedRace(), competitor, performanceCurveSupplier);
            Speed referenceImpliedWind = this.getReferenceImpliedWind(timePoint, cache);
            if (referenceImpliedWind != null && competitorPerformanceCurve != null) {
                Duration competitorAllowance = competitorPerformanceCurve.getAllowancePerCourse(referenceImpliedWind);
                Duration competitorElapsedTime = this.getTrackedRace().getTimeSailedSinceRaceStart(competitor, timePoint);
                competitorDelta = competitorElapsedTime != null ? competitorElapsedTime.minus(competitorAllowance) : null;
            } else {
                competitorDelta = null;
            }
        }
        catch (FunctionEvaluationException e) {
            logger.log(Level.WARNING, "Problem evaluating performance curve", e);
            competitorDelta = null;
        }
        return competitorDelta;
    }
}

