/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.orc.impl.ORCPublicCertificateDatabaseImpl;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.TimePoint;
import java.io.IOException;
import java.text.ParseException;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public interface ORCPublicCertificateDatabase {
    public static final ORCPublicCertificateDatabase INSTANCE = new ORCPublicCertificateDatabaseImpl();

    public Iterable<CertificateHandle> search(CountryCode var1, Integer var2, String var3, String var4, String var5, String var6, boolean var7) throws Exception;

    public Iterable<ORCCertificate> getCertificates(Iterable<CertificateHandle> var1) throws Exception;

    default public Iterable<ORCCertificate> getCertificates(CertificateHandle ... handles) throws Exception {
        return this.getCertificates(Arrays.asList(handles));
    }

    default public CertificateHandle getCertificateHandle(String referenceNumber) throws Exception {
        return this.search(null, null, referenceNumber, null, null, null, true).iterator().next();
    }

    public ORCCertificate searchForUpdate(ORCCertificate var1) throws Exception;

    public ORCCertificate searchForUpdate(CertificateHandle var1) throws Exception;

    default public ORCCertificate getCertificate(String referenceNumber) throws Exception {
        return this.getCertificate(referenceNumber, CertificateFamily.ORC);
    }

    public ORCCertificate getCertificate(String var1, CertificateFamily var2) throws Exception;

    default public ORCCertificate getCertificate(CertificateHandle certificateHandle) throws Exception {
        Iterable<ORCCertificate> certificates = this.getCertificates(certificateHandle);
        return certificates.iterator().hasNext() ? certificates.iterator().next() : null;
    }

    public Future<Set<ORCCertificate>> search(String var1, String var2, BoatClass var3);

    public Date parseDate(String var1) throws DateTimeParseException;

    public Iterable<CountryOverview> getCountriesWithValidCertificates() throws SAXException, IOException, ParserConfigurationException, DOMException, ParseException;

    public static enum CertificateFamily {
        UNKNOWN(0, ""),
        ORC(1, "ORC"),
        SUPER_YACHT(2, "SY"),
        DOUBLE_HANDED(3, "DH"),
        MULTI_HULL(4, "Mu");

        private final int familyId;
        private final String familyQueryParamValue;
        private static final Map<Integer, CertificateFamily> familyById;

        static {
            familyById = new HashMap<Integer, CertificateFamily>();
            CertificateFamily[] certificateFamilyArray = CertificateFamily.values();
            int n = certificateFamilyArray.length;
            int n2 = 0;
            while (n2 < n) {
                CertificateFamily family = certificateFamilyArray[n2];
                familyById.put(family.getFamilyId(), family);
                ++n2;
            }
        }

        private CertificateFamily(int familyId, String familyQueryParamValue) {
            this.familyId = familyId;
            this.familyQueryParamValue = familyQueryParamValue;
        }

        public int getFamilyId() {
            return this.familyId;
        }

        public String getFamilyQueryParamValue() {
            return this.familyQueryParamValue;
        }

        public static CertificateFamily fromId(int familyId) {
            return familyById.get(familyId);
        }
    }

    public static interface CertificateHandle {
        public CountryCode getIssuingCountry();

        public String getFileId();

        public Double getGPH();

        public String getSSSID();

        public UUID getDatInGID();

        public String getReferenceNumber();

        public CertificateFamily getFamily();

        public String getYachtName();

        public String getSailNumber();

        public String getBoatClassName();

        public String getDesigner();

        public String getBuilder();

        public Integer getYearBuilt();

        public TimePoint getIssueDate();

        public Integer getCertType();

        public Boolean isOd();

        public Boolean isProvisional();

        public Boolean isValid();
    }

    public static interface CountryOverview {
        public CountryCode getIssuingCountry();

        public CertificateFamily getFamily();

        public Integer getCertType();

        public Integer getVPPYear();

        public int getCertCount();

        public TimePoint getLastUpdate();

        public String getCertName();

        public String getRMSCode();
    }
}

