/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.impl.AbstractRaceExecutionOrderProvider;
import com.sap.sailing.domain.base.impl.RegattaLogEventAdditionForwarder;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.LeaderboardType;
import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.FlexibleRaceColumn;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.AbstractLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.DefaultFleetImpl;
import com.sap.sailing.domain.leaderboard.impl.RaceColumnImpl;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.racelog.impl.EmptyRaceLogStore;
import com.sap.sailing.domain.regattalike.BaseRegattaLikeImpl;
import com.sap.sailing.domain.regattalike.FlexibleLeaderboardAsRegattaLikeIdentifier;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.regattalike.RegattaLikeListener;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.regattalog.impl.EmptyRegattaLogStore;
import com.sap.sailing.domain.tracking.RaceExecutionOrderProvider;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.metering.CPUMeter;
import com.sap.sse.metering.CPUMetrics;
import com.sap.sse.metering.CompositeCPUMetrics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public class FlexibleLeaderboardImpl
extends AbstractLeaderboardImpl
implements FlexibleLeaderboard {
    private static Logger logger = Logger.getLogger(FlexibleLeaderboardImpl.class.getName());
    protected static final DefaultFleetImpl defaultFleet = new DefaultFleetImpl();
    private static final long serialVersionUID = -5708971849158747846L;
    private final List<FlexibleRaceColumn> races;
    private final ScoringScheme scoringScheme;
    private final String name;
    private transient RaceLogStore raceLogStore;
    private transient CompositeCPUMetrics cpuMeter;
    private List<CourseArea> courseAreas;
    private RaceExecutionOrderProvider raceExecutionOrderProvider;
    private final IsRegattaLike regattaLikeHelper;

    public FlexibleLeaderboardImpl(String name, ThresholdBasedResultDiscardingRule resultDiscardingRule, ScoringScheme scoringScheme, CourseArea courseArea) {
        this((RaceLogStore)EmptyRaceLogStore.INSTANCE, (RegattaLogStore)EmptyRegattaLogStore.INSTANCE, name, resultDiscardingRule, scoringScheme, courseArea);
    }

    public FlexibleLeaderboardImpl(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, String name, ThresholdBasedResultDiscardingRule resultDiscardingRule, ScoringScheme scoringScheme, CourseArea courseArea) {
        this(raceLogStore, regattaLogStore, name, resultDiscardingRule, scoringScheme, courseArea == null ? Collections.emptySet() : Collections.singleton(courseArea));
    }

    public FlexibleLeaderboardImpl(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, String name, ThresholdBasedResultDiscardingRule resultDiscardingRule, ScoringScheme scoringScheme, Iterable<CourseArea> courseAreas) {
        super(resultDiscardingRule);
        assert (courseAreas != null);
        this.cpuMeter = CompositeCPUMetrics.create();
        this.scoringScheme = scoringScheme;
        if (name == null) {
            throw new IllegalArgumentException("A leaderboard's name must not be null");
        }
        this.name = name;
        this.races = new ArrayList<FlexibleRaceColumn>();
        this.raceLogStore = raceLogStore;
        this.courseAreas = Collections.synchronizedList(new ArrayList());
        Util.addAll(courseAreas, this.courseAreas);
        this.regattaLikeHelper = new BaseRegattaLikeImpl(new FlexibleLeaderboardAsRegattaLikeIdentifier(this), regattaLogStore){
            private static final long serialVersionUID = 4082392360832548953L;

            @Override
            public RaceColumn getRaceColumnByName(String raceColumnName) {
                return this.getRaceColumnByName(raceColumnName);
            }

            @Override
            public void setFleetsCanRunInParallelToTrue() {
            }
        };
        this.regattaLikeHelper.addListener(new RegattaLogEventAdditionForwarder(this.getRaceColumnListeners()));
        this.raceExecutionOrderProvider = new RaceExecutionOrderCache();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.raceLogStore = EmptyRaceLogStore.INSTANCE;
        this.cpuMeter = CompositeCPUMetrics.create();
        for (RaceColumn column : this.getRaceColumns()) {
            column.setRaceLogInformation(this.raceLogStore, new FlexibleLeaderboardAsRegattaLikeIdentifier(this));
            TrackedRace trackedRace = column.getTrackedRace((Fleet)defaultFleet);
            if (trackedRace == null) continue;
            this.cpuMeter.add((CPUMetrics)trackedRace.getTrackedRegatta().getCPUMeter());
        }
        this.regattaLikeHelper.addListener(new RegattaLogEventAdditionForwarder(this.getRaceColumnListeners()));
    }

    protected Object readResolve() throws ObjectStreamException {
        this.raceExecutionOrderProvider.triggerUpdate();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CPUMeter getCPUMeter() {
        return this.cpuMeter;
    }

    @Override
    public void trackedRaceLinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        super.trackedRaceLinked(raceColumn, fleet, trackedRace);
        this.cpuMeter.add((CPUMetrics)trackedRace.getTrackedRegatta().getCPUMeter());
    }

    @Override
    public FlexibleRaceColumn addRace(TrackedRace race, String columnName, boolean medalRace) {
        FlexibleRaceColumn column = this.addRaceColumn(columnName, medalRace, false);
        column.setTrackedRace((Fleet)defaultFleet, race);
        this.cpuMeter.add((CPUMetrics)race.getTrackedRegatta().getCPUMeter());
        return column;
    }

    @Override
    public FlexibleRaceColumn addRaceColumn(String name, boolean medalRace) {
        return this.addRaceColumn(name, medalRace, true);
    }

    private FlexibleRaceColumn addRaceColumn(String name, boolean medalRace, boolean logAlreadyExistingColumn) {
        FlexibleRaceColumn column = this.getRaceColumnByName(name);
        if (column != null) {
            if (logAlreadyExistingColumn) {
                String msg = "Trying to create race column with duplicate name " + name + " in leaderboard " + this.getName();
                logger.severe(msg);
            }
        } else {
            column = this.createRaceColumn(name, medalRace);
            column.addRaceColumnListener(this);
            this.races.add(column);
            column.setRaceLogInformationAndLoad(this.raceLogStore, new FlexibleLeaderboardAsRegattaLikeIdentifier(this));
            column.setRegattaLikeHelper(this.regattaLikeHelper);
            this.getRaceColumnListeners().notifyListenersAboutRaceColumnAddedToContainer(column);
        }
        return column;
    }

    @Override
    public FlexibleRaceColumn getRaceColumnByName(String columnName) {
        return (FlexibleRaceColumn)super.getRaceColumnByName(columnName);
    }

    @Override
    public Fleet getFleet(String fleetName) {
        DefaultFleetImpl result = fleetName == null ? defaultFleet : super.getFleet(fleetName);
        return result;
    }

    @Override
    public void removeRaceColumn(String columnName) {
        FlexibleRaceColumn raceColumn = this.getRaceColumnByName(columnName);
        if (raceColumn != null) {
            for (Fleet fleet : raceColumn.getFleets()) {
                this.raceLogStore.removeRaceLog(raceColumn.getRaceLogIdentifier(fleet));
                if (raceColumn.getTrackedRace(fleet) == null) continue;
                raceColumn.getTrackedRace(fleet).detachRaceExecutionOrderProvider(this.raceExecutionOrderProvider);
            }
            this.races.remove(raceColumn);
            this.getRaceColumnListeners().notifyListenersAboutRaceColumnRemovedFromContainer(raceColumn);
            raceColumn.removeRaceColumnListener(this);
        }
    }

    @Override
    public Iterable<RaceColumn> getRaceColumns() {
        Collection<FlexibleRaceColumn> result = this.races != null ? Collections.unmodifiableCollection(new ArrayList<FlexibleRaceColumn>(this.races)) : null;
        return result;
    }

    protected RaceColumnImpl createRaceColumn(String column, boolean medalRace) {
        return new RaceColumnImpl(column, medalRace, this.raceExecutionOrderProvider);
    }

    protected Iterable<Fleet> turnNullOrEmptyFleetsIntoDefaultFleet(Fleet ... fleets) {
        Collection<DefaultFleetImpl> theFleets;
        if (fleets == null || fleets.length == 0) {
            DefaultFleetImpl defaultfleetCasted = defaultFleet;
            theFleets = Collections.singleton(defaultfleetCasted);
        } else {
            theFleets = Arrays.asList(fleets);
        }
        return theFleets;
    }

    @Override
    public void moveRaceColumnUp(String name) {
        FlexibleRaceColumn race = null;
        for (FlexibleRaceColumn r : this.races) {
            if (!r.getName().equals(name)) continue;
            race = r;
        }
        if (race != null) {
            int index = 0;
            index = this.races.lastIndexOf(race);
            if (--index >= 0) {
                this.races.remove(race);
                this.races.add(index, race);
                this.getRaceColumnListeners().notifyListenersAboutRaceColumnMoved(race, index);
            }
        }
    }

    @Override
    public void moveRaceColumnDown(String name) {
        FlexibleRaceColumn race = null;
        for (FlexibleRaceColumn r : this.races) {
            if (!r.getName().equals(name)) continue;
            race = r;
        }
        if (race != null) {
            int index = 0;
            index = this.races.lastIndexOf(race);
            if (index != -1 && ++index < this.races.size()) {
                this.races.remove(race);
                this.races.add(index, race);
                this.getRaceColumnListeners().notifyListenersAboutRaceColumnMoved(race, index);
            }
        }
    }

    @Override
    public void updateIsMedalRace(String raceName, boolean isMedalRace) {
        FlexibleRaceColumn race = null;
        for (FlexibleRaceColumn r : this.races) {
            if (!r.getName().equals(raceName)) continue;
            race = r;
        }
        if (race != null) {
            race.setIsMedalRace(isMedalRace);
        }
    }

    @Override
    public ScoringScheme getScoringScheme() {
        return this.scoringScheme;
    }

    @Override
    public Iterable<CourseArea> getCourseAreas() {
        return this.courseAreas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCourseAreas(Iterable<CourseArea> newCourseAreas) {
        List<CourseArea> list = this.courseAreas;
        synchronized (list) {
            this.courseAreas.clear();
            Util.addAll(newCourseAreas, this.courseAreas);
        }
    }

    @Override
    public IsRegattaLike getRegattaLike() {
        return this.regattaLikeHelper;
    }

    @Override
    public RegattaLog getRegattaLog() {
        return this.regattaLikeHelper.getRegattaLog();
    }

    @Override
    public RegattaLikeIdentifier getRegattaLikeIdentifier() {
        return this.regattaLikeHelper.getRegattaLikeIdentifier();
    }

    @Override
    public void addListener(RegattaLikeListener listener) {
        this.regattaLikeHelper.addListener(listener);
    }

    @Override
    public void removeListener(RegattaLikeListener listener) {
        this.regattaLikeHelper.removeListener(listener);
    }

    @Override
    public Double getTimeOnTimeFactor(Competitor competitor, Optional<Runnable> changeCallback) {
        return this.regattaLikeHelper.getTimeOnTimeFactor(competitor, changeCallback);
    }

    @Override
    public Duration getTimeOnDistanceAllowancePerNauticalMile(Competitor competitor, Optional<Runnable> changeCallback) {
        return this.regattaLikeHelper.getTimeOnDistanceAllowancePerNauticalMile(competitor, changeCallback);
    }

    @Override
    public LeaderboardType getLeaderboardType() {
        return LeaderboardType.FlexibleLeaderboard;
    }

    @Override
    public boolean canBoatsOfCompetitorsChangePerRace() {
        return false;
    }

    @Override
    public CompetitorRegistrationType getCompetitorRegistrationType() {
        return CompetitorRegistrationType.CLOSED;
    }

    @Override
    public void destroy() {
        super.destroy();
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                raceColumn.setTrackedRace(fleet, null);
            }
        }
    }

    @Override
    public void setFleetsCanRunInParallelToTrue() {
    }

    private class RaceExecutionOrderCache
    extends AbstractRaceExecutionOrderProvider {
        private static final long serialVersionUID = 652833386555762661L;

        public RaceExecutionOrderCache() {
            FlexibleLeaderboardImpl.this.addRaceColumnListener(this);
        }

        @Override
        protected Map<Fleet, Iterable<? extends RaceColumn>> getRaceColumnsOfSeries() {
            HashMap<Fleet, Iterable<? extends RaceColumn>> result = new HashMap<Fleet, Iterable<? extends RaceColumn>>();
            result.put((Fleet)defaultFleet, (Iterable<? extends RaceColumn>)FlexibleLeaderboardImpl.this.getRaceColumns());
            return result;
        }
    }
}

