/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogRegisterBoatEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogRegisterCompetitorEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogBoatDeregistrator;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogBoatsInLogAnalyzer;
import com.sap.sailing.domain.abstractlog.shared.analyzing.CompetitorDeregistrator;
import com.sap.sailing.domain.abstractlog.shared.analyzing.CompetitorsAndBoatsInLogAnalyzer;
import com.sap.sailing.domain.abstractlog.shared.analyzing.CompetitorsInLogAnalyzer;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.RegattaListener;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.impl.AbstractRaceExecutionOrderProvider;
import com.sap.sailing.domain.base.impl.FleetImpl;
import com.sap.sailing.domain.base.impl.MasterDataImportInformation;
import com.sap.sailing.domain.base.impl.RegattaLogEventAdditionForwarder;
import com.sap.sailing.domain.base.impl.SeriesImpl;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.impl.AbstractLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.CompetitorProviderFromRaceColumnsAndRegattaLike;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.racelog.impl.EmptyRaceLogStore;
import com.sap.sailing.domain.ranking.OneDesignRankingMetric;
import com.sap.sailing.domain.ranking.RankingMetricConstructor;
import com.sap.sailing.domain.regattalike.BaseRegattaLikeImpl;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sailing.domain.regattalike.RegattaAsRegattaLikeIdentifier;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.regattalike.RegattaLikeListener;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.regattalog.impl.EmptyRegattaLogStore;
import com.sap.sailing.domain.tracking.RaceExecutionOrderProvider;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.util.impl.RaceColumnListeners;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.NamedImpl;
import com.sap.sse.metering.CPUMeter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegattaImpl
extends NamedImpl
implements Regatta,
RaceColumnListener {
    private static transient ThreadLocal<MasterDataImportInformation> ongoingMasterDataImportInformation = new ThreadLocal<MasterDataImportInformation>(){

        @Override
        protected MasterDataImportInformation initialValue() {
            return null;
        }
    };
    private static final Logger logger = Logger.getLogger(RegattaImpl.class.getName());
    private static final long serialVersionUID = 6509564189552478869L;
    private ConcurrentMap<String, RaceDefinition> races;
    private final BoatClass boatClass;
    private transient Set<RegattaListener> regattaListeners;
    private List<? extends Series> series;
    private final RaceColumnListeners raceColumnListeners;
    private final ScoringScheme scoringScheme;
    private TimePoint startDate;
    private TimePoint endDate;
    private final Serializable id;
    private transient RaceLogStore raceLogStore;
    private final IsRegattaLike regattaLikeHelper;
    private final RankingMetricConstructor rankingMetricConstructor;
    private Double buoyZoneRadiusInHullLengths;
    private List<CourseArea> courseAreas;
    private RegattaConfiguration configuration;
    private RaceExecutionOrderCache raceExecutionOrderCache;
    private String registrationLinkSecret;
    private final boolean persistent;
    private boolean controlTrackingFromStartAndFinishTimes;
    private boolean autoRestartTrackingUponCompetitorSetChange;
    private boolean canBoatsOfCompetitorsChangePerRace;
    private CompetitorRegistrationType competitorRegistrationType;
    private boolean useStartTimeInference;
    private transient CompetitorProviderFromRaceColumnsAndRegattaLike competitorsProvider;
    private AbstractLogEventAuthor regattaLogEventAuthorForRegatta = new LogEventAuthorImpl(AbstractLeaderboardImpl.class.getName(), 0);
    private transient CPUMeter cpuMeter = CPUMeter.create();

    public static void setOngoingMasterDataImport(MasterDataImportInformation information) {
        ongoingMasterDataImportInformation.set(information);
    }

    public RegattaImpl(String name, BoatClass boatClass, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, TimePoint startDate, TimePoint endDate, Iterable<? extends Series> series, boolean persistent, ScoringScheme scoringScheme, Serializable id, CourseArea courseArea, RankingMetricConstructor rankingMetricConstructor, String registrationLinkSecret) {
        this((RaceLogStore)EmptyRaceLogStore.INSTANCE, (RegattaLogStore)EmptyRegattaLogStore.INSTANCE, name, boatClass, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, startDate, endDate, series, persistent, scoringScheme, id, courseArea, (Double)0.0, true, false, false, rankingMetricConstructor, registrationLinkSecret);
    }

    public RegattaImpl(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, String name, BoatClass boatClass, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, TimePoint startDate, TimePoint endDate, TrackedRegattaRegistry trackedRegattaRegistry, ScoringScheme scoringScheme, Serializable id, CourseArea courseArea, String registrationLinkSecret) {
        this(raceLogStore, regattaLogStore, name, boatClass, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, startDate, endDate, trackedRegattaRegistry, scoringScheme, id, courseArea, false, false, OneDesignRankingMetric::new, registrationLinkSecret);
    }

    public RegattaImpl(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, String name, BoatClass boatClass, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, TimePoint startDate, TimePoint endDate, TrackedRegattaRegistry trackedRegattaRegistry, ScoringScheme scoringScheme, Serializable id, CourseArea courseArea, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, RankingMetricConstructor rankingMetricConstructor, String registrationLinkSecret) {
        this(raceLogStore, regattaLogStore, name, boatClass, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, startDate, endDate, Collections.singletonList(new SeriesImpl("Default", false, true, Collections.singletonList(new FleetImpl("Default")), new ArrayList<String>(), trackedRegattaRegistry)), false, scoringScheme, id, courseArea, (Double)2.0, true, controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange, rankingMetricConstructor, registrationLinkSecret);
    }

    public <S extends Series> RegattaImpl(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, String name, BoatClass boatClass, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, TimePoint startDate, TimePoint endDate, Iterable<S> series, boolean persistent, ScoringScheme scoringScheme, Serializable id, CourseArea courseArea, Double buoyZoneRadiusInHullLengths, boolean useStartTimeInference, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, RankingMetricConstructor rankingMetricConstructor, String registrationLinkSecret) {
        this(raceLogStore, regattaLogStore, name, boatClass, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, startDate, endDate, series, persistent, scoringScheme, id, courseArea == null ? Collections.emptySet() : Collections.singleton(courseArea), buoyZoneRadiusInHullLengths, useStartTimeInference, controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange, rankingMetricConstructor, registrationLinkSecret);
    }

    public <S extends Series> RegattaImpl(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, String name, BoatClass boatClass, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, TimePoint startDate, TimePoint endDate, Iterable<S> series, boolean persistent, ScoringScheme scoringScheme, Serializable id, Iterable<CourseArea> courseAreas, Double buoyZoneRadiusInHullLengths, boolean useStartTimeInference, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, RankingMetricConstructor rankingMetricConstructor, String registrationLinkSecret) {
        super(name);
        this.registrationLinkSecret = registrationLinkSecret;
        this.rankingMetricConstructor = rankingMetricConstructor;
        this.useStartTimeInference = useStartTimeInference;
        this.controlTrackingFromStartAndFinishTimes = controlTrackingFromStartAndFinishTimes;
        this.autoRestartTrackingUponCompetitorSetChange = autoRestartTrackingUponCompetitorSetChange;
        this.id = id;
        this.raceLogStore = raceLogStore;
        this.races = new ConcurrentHashMap<String, RaceDefinition>();
        this.regattaListeners = new HashSet<RegattaListener>();
        this.raceColumnListeners = new RaceColumnListeners();
        this.boatClass = boatClass;
        this.canBoatsOfCompetitorsChangePerRace = canBoatsOfCompetitorsChangePerRace;
        this.startDate = startDate;
        this.endDate = endDate;
        ArrayList<? extends Series> seriesList = new ArrayList<Series>();
        for (Series s : series) {
            seriesList.add(s);
        }
        this.series = seriesList;
        for (Series s : series) {
            this.linkToRegattaAndConnectRaceLogsAndAddListeners(s, true);
        }
        this.persistent = persistent;
        this.scoringScheme = scoringScheme;
        this.courseAreas = Collections.synchronizedList(new ArrayList());
        Util.addAll(courseAreas, this.courseAreas);
        this.configuration = null;
        this.buoyZoneRadiusInHullLengths = buoyZoneRadiusInHullLengths;
        this.regattaLikeHelper = new BaseRegattaLikeImpl(new RegattaAsRegattaLikeIdentifier(this), regattaLogStore){
            private static final long serialVersionUID = 8546222568682770206L;

            @Override
            public RaceColumn getRaceColumnByName(String raceColumnName) {
                for (Series series : RegattaImpl.this.getSeries()) {
                    for (RaceColumn raceColumn : series.getRaceColumns()) {
                        if (!raceColumn.getName().equals(raceColumnName)) continue;
                        return raceColumn;
                    }
                }
                return null;
            }

            @Override
            public void setFleetsCanRunInParallelToTrue() {
                RegattaImpl.this.setFleetsCanRunInParallelToTrue();
            }
        };
        this.regattaLikeHelper.addListener(new RegattaLogEventAdditionForwarder(this.raceColumnListeners));
        this.raceExecutionOrderCache = new RaceExecutionOrderCache();
        this.competitorRegistrationType = competitorRegistrationType;
    }

    @Override
    public RankingMetricConstructor getRankingMetricConstructor() {
        return this.rankingMetricConstructor == null ? OneDesignRankingMetric::new : this.rankingMetricConstructor;
    }

    private void registerRaceLogsOnRaceColumns(Series series, boolean loadRaceLogs) {
        for (RaceColumn raceColumn : series.getRaceColumns()) {
            this.setRaceLogInformationOnRaceColumn(raceColumn, loadRaceLogs);
        }
    }

    private void setRaceLogInformationOnRaceColumn(RaceColumn raceColumn, boolean loadRaceLogs) {
        RegattaAsRegattaLikeIdentifier regattaLikeIdentifier = new RegattaAsRegattaLikeIdentifier(this);
        if (loadRaceLogs) {
            raceColumn.setRaceLogInformationAndLoad(this.raceLogStore, regattaLikeIdentifier);
        } else {
            raceColumn.setRaceLogInformation(this.raceLogStore, regattaLikeIdentifier);
        }
    }

    public Serializable getId() {
        return this.id;
    }

    public CPUMeter getCPUMeter() {
        return this.cpuMeter;
    }

    public static String getDefaultName(String baseName, String boatClassName) {
        return String.valueOf(baseName.replace('/', '_')) + (boatClassName == null ? "" : " (" + boatClassName + ")").replace('/', '_');
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.cpuMeter = CPUMeter.create();
        this.regattaListeners = new HashSet<RegattaListener>();
        MasterDataImportInformation masterDataImportInformation = ongoingMasterDataImportInformation.get();
        if (masterDataImportInformation != null) {
            this.raceLogStore = masterDataImportInformation.getRaceLogStore();
            this.races = new ConcurrentHashMap<String, RaceDefinition>();
        } else {
            this.raceLogStore = EmptyRaceLogStore.INSTANCE;
        }
        this.regattaLikeHelper.addListener(new RegattaLogEventAdditionForwarder(this.raceColumnListeners));
    }

    protected Object readResolve() throws ObjectStreamException {
        this.raceExecutionOrderCache.triggerUpdate();
        return this;
    }

    public void initializeSeriesAfterDeserialize() {
        for (Series series : this.getSeries()) {
            this.linkToRegattaAndConnectRaceLogsAndAddListeners(series, false);
            if (series.getRaceColumns() != null) continue;
            logger.warning("Race Columns were null during deserialization. This should not happen.");
        }
    }

    @Override
    public Iterable<? extends Series> getSeries() {
        Collection<? extends Series> result = this.series != null ? Collections.unmodifiableCollection(this.series) : null;
        return result;
    }

    @Override
    public Series getSeriesByName(String name) {
        for (Series series : this.getSeries()) {
            if (!series.getName().equals(name)) continue;
            return series;
        }
        return null;
    }

    @Override
    public Iterable<RaceDefinition> getAllRaces() {
        return this.races.values();
    }

    @Override
    public RegattaIdentifier getRegattaIdentifier() {
        return new RegattaName(this.getName());
    }

    @Override
    public RegattaAndRaceIdentifier getRaceIdentifier(RaceDefinition race) {
        return new RegattaNameAndRaceName(this.getName(), race.getName());
    }

    @Override
    public RaceDefinition getRaceByName(String raceName) {
        return (RaceDefinition)this.races.get(raceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRace(RaceDefinition race) {
        logger.info("Adding race " + race.getName() + " to regatta " + this.getName() + " (" + this.hashCode() + ")");
        if (this.getBoatClass() != null && race.getBoatClass() != this.getBoatClass()) {
            throw new IllegalArgumentException("Boat class " + race.getBoatClass() + " doesn't match regatta's boat class " + this.getBoatClass());
        }
        this.races.put(race.getName(), race);
        Set<RegattaListener> set = this.regattaListeners;
        synchronized (set) {
            for (RegattaListener l : this.regattaListeners) {
                l.raceAdded(this, race);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRace(RaceDefinition race) {
        logger.info("Removing race " + race.getName() + " from regatta " + this.getName() + " (" + this.hashCode() + ")");
        this.races.remove(race.getName());
        Set<RegattaListener> set = this.regattaListeners;
        synchronized (set) {
            for (RegattaListener l : this.regattaListeners) {
                l.raceRemoved(this, race);
            }
        }
    }

    @Override
    public BoatClass getBoatClass() {
        return this.boatClass;
    }

    @Override
    public CompetitorProviderFromRaceColumnsAndRegattaLike getOrCreateCompetitorsProvider() {
        if (this.competitorsProvider == null) {
            this.competitorsProvider = new CompetitorProviderFromRaceColumnsAndRegattaLike(this);
        }
        return this.competitorsProvider;
    }

    @Override
    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered() {
        if (this.competitorsProvider == null) {
            this.competitorsProvider = new CompetitorProviderFromRaceColumnsAndRegattaLike(this);
        }
        Util.Pair allCompetitorsWithRaceDefinitionsConsidered = this.competitorsProvider.getAllCompetitorsWithRaceDefinitionsConsidered();
        HashSet newResult = null;
        HashSet<RaceDefinition> newRaceDefinitions = null;
        Iterable racesConsideredSoFar = (Iterable)allCompetitorsWithRaceDefinitionsConsidered.getA();
        for (RaceDefinition race : this.getAllRaces()) {
            if (Util.contains((Iterable)racesConsideredSoFar, (Object)race)) continue;
            if (newResult == null) {
                newRaceDefinitions = new HashSet<RaceDefinition>();
                Util.addAll((Iterable)((Iterable)allCompetitorsWithRaceDefinitionsConsidered.getA()), newRaceDefinitions);
                newResult = new HashSet();
                Util.addAll((Iterable)((Iterable)allCompetitorsWithRaceDefinitionsConsidered.getB()), newResult);
            }
            Util.addAll(race.getCompetitors(), newResult);
            newRaceDefinitions.add(race);
        }
        return newResult == null ? allCompetitorsWithRaceDefinitionsConsidered : new Util.Pair(newRaceDefinitions, newResult);
    }

    @Override
    public Iterable<Competitor> getAllCompetitors() {
        return (Iterable)this.getAllCompetitorsWithRaceDefinitionsConsidered().getB();
    }

    @Override
    public Iterable<Boat> getAllBoats() {
        HashSet<Boat> result = new HashSet<Boat>();
        HashSet<RaceDefinition> allRaces = new HashSet<RaceDefinition>();
        Util.addAll(this.getAllRaces(), allRaces);
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                RaceDefinition raceDefinition = raceColumn.getRaceDefinition(fleet);
                if (raceDefinition == null) continue;
                allRaces.add(raceDefinition);
            }
        }
        for (RaceDefinition raceDefinition : allRaces) {
            Util.addAll(raceDefinition.getBoats(), result);
        }
        RegattaLog regattaLog = this.getRegattaLog();
        Map regattaLogProvidedCompetitorsAndBoats = (Map)new CompetitorsAndBoatsInLogAnalyzer((AbstractLog)regattaLog).analyze();
        Util.addAll(regattaLogProvidedCompetitorsAndBoats.values(), result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegattaListener(RegattaListener listener) {
        Set<RegattaListener> set = this.regattaListeners;
        synchronized (set) {
            this.regattaListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegattaListener(RegattaListener listener) {
        Set<RegattaListener> set = this.regattaListeners;
        synchronized (set) {
            this.regattaListeners.remove(listener);
        }
    }

    @Override
    public void trackedRaceLinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.raceColumnListeners.notifyListenersAboutTrackedRaceLinked(raceColumn, fleet, trackedRace);
    }

    @Override
    public void trackedRaceUnlinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.raceColumnListeners.notifyListenersAboutTrackedRaceUnlinked(raceColumn, fleet, trackedRace);
    }

    @Override
    public void isMedalRaceChanged(RaceColumn raceColumn, boolean newIsMedalRace) {
        this.raceColumnListeners.notifyListenersAboutIsMedalRaceChanged(raceColumn, newIsMedalRace);
    }

    @Override
    public void isFleetsCanRunInParallelChanged(RaceColumn raceColumn, boolean newIsFleetsCanRunInParallel) {
        this.raceColumnListeners.notifyListenersAboutIsFleetsCanRunInParallelChanged(raceColumn, newIsFleetsCanRunInParallel);
    }

    @Override
    public void isStartsWithZeroScoreChanged(RaceColumn raceColumn, boolean newIsStartsWithZeroScore) {
        this.raceColumnListeners.notifyListenersAboutIsStartsWithZeroScoreChanged(raceColumn, newIsStartsWithZeroScore);
    }

    @Override
    public void isFirstColumnIsNonDiscardableCarryForwardChanged(RaceColumn raceColumn, boolean firstColumnIsNonDiscardableCarryForward) {
        this.raceColumnListeners.notifyListenersAboutIsFirstColumnIsNonDiscardableCarryForwardChanged(raceColumn, firstColumnIsNonDiscardableCarryForward);
    }

    @Override
    public void hasSplitFleetContiguousScoringChanged(RaceColumn raceColumn, boolean hasSplitFleetContiguousScoring) {
        this.raceColumnListeners.notifyListenersAboutHasSplitFleetContiguousScoringChanged(raceColumn, hasSplitFleetContiguousScoring);
    }

    @Override
    public void oneAlwaysStaysOneChanged(RaceColumn raceColumn, boolean oneAlwaysStaysOne) {
        this.raceColumnListeners.notifyListenersAboutOneAlwaysStaysOneChanged(raceColumn, oneAlwaysStaysOne);
    }

    @Override
    public void hasCrossFleetMergedRankingChanged(RaceColumn raceColumn, boolean hasCrossFleetMergedRanking) {
        this.raceColumnListeners.notifyListenersAboutHasCrossFleetMergedRankingChanged(raceColumn, hasCrossFleetMergedRanking);
    }

    @Override
    public boolean canAddRaceColumnToContainer(RaceColumn raceColumn) {
        return this.raceColumnListeners.canAddRaceColumnToContainer(raceColumn);
    }

    @Override
    public void raceColumnAddedToContainer(RaceColumn raceColumn) {
        this.setRaceLogInformationOnRaceColumn(raceColumn, true);
        this.raceColumnListeners.notifyListenersAboutRaceColumnAddedToContainer(raceColumn);
    }

    @Override
    public void raceColumnRemovedFromContainer(RaceColumn raceColumn) {
        for (Fleet fleet : raceColumn.getFleets()) {
            RaceLogIdentifier identifier = raceColumn.getRaceLogIdentifier(fleet);
            this.raceLogStore.removeRaceLog(identifier);
        }
        this.raceColumnListeners.notifyListenersAboutRaceColumnRemovedFromContainer(raceColumn);
    }

    @Override
    public void raceColumnMoved(RaceColumn raceColumn, int newIndex) {
        this.raceColumnListeners.notifyListenersAboutRaceColumnMoved(raceColumn, newIndex);
    }

    @Override
    public void raceColumnNameChanged(RaceColumn raceColumn, String oldName, String newName) {
        this.raceColumnListeners.notifyListenersAboutRaceColumnNameChanged(raceColumn, oldName, newName);
    }

    @Override
    public void factorChanged(RaceColumn raceColumn, Double oldFactor, Double newFactor) {
        this.raceColumnListeners.notifyListenersAboutFactorChanged(raceColumn, oldFactor, newFactor);
    }

    @Override
    public void competitorDisplayNameChanged(Competitor competitor, String oldDisplayName, String displayName) {
        this.raceColumnListeners.notifyListenersAboutCompetitorDisplayNameChanged(competitor, oldDisplayName, displayName);
    }

    @Override
    public void resultDiscardingRuleChanged(ResultDiscardingRule oldDiscardingRule, ResultDiscardingRule newDiscardingRule) {
        this.raceColumnListeners.notifyListenersAboutResultDiscardingRuleChanged(oldDiscardingRule, newDiscardingRule);
    }

    @Override
    public void maximumNumberOfDiscardsChanged(Integer oldMaximumNumberOfDiscards, Integer newMaximumNumberOfDiscards) {
        this.raceColumnListeners.notifyListenersAboutMaximumNumberOfDiscardsChanged(oldMaximumNumberOfDiscards, newMaximumNumberOfDiscards);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void addRaceColumnListener(RaceColumnListener listener) {
        this.raceColumnListeners.addRaceColumnListener(listener);
    }

    @Override
    public void removeRaceColumnListener(RaceColumnListener listener) {
        this.raceColumnListeners.removeRaceColumnListener(listener);
    }

    @Override
    public void raceLogEventAdded(RaceColumn raceColumn, RaceLogIdentifier raceLogIdentifier, RaceLogEvent event) {
        this.raceColumnListeners.notifyListenersAboutRaceLogEventAdded(raceColumn, raceLogIdentifier, event);
    }

    @Override
    public void regattaLogEventAdded(RegattaLogEvent event) {
        this.raceColumnListeners.notifyListenersAboutRegattaLogEventAdded(event);
    }

    @Override
    public ScoringScheme getScoringScheme() {
        return this.scoringScheme;
    }

    @Override
    public TimePoint getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartDate(TimePoint startDate) {
        this.startDate = startDate;
    }

    @Override
    public TimePoint getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(TimePoint endDate) {
        this.endDate = endDate;
    }

    @Override
    public Double getBuoyZoneRadiusInHullLengths() {
        return this.buoyZoneRadiusInHullLengths;
    }

    @Override
    public void setBuoyZoneRadiusInHullLengths(Double buoyZoneRadiusInHullLengths) {
        this.buoyZoneRadiusInHullLengths = buoyZoneRadiusInHullLengths;
    }

    @Override
    public Iterable<CourseArea> getCourseAreas() {
        return this.courseAreas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCourseAreas(Iterable<CourseArea> newCourseAreas) {
        List<CourseArea> list = this.courseAreas;
        synchronized (list) {
            this.courseAreas.clear();
            Util.addAll(newCourseAreas, this.courseAreas);
        }
    }

    @Override
    public boolean isControlTrackingFromStartAndFinishTimes() {
        return this.controlTrackingFromStartAndFinishTimes;
    }

    @Override
    public boolean isAutoRestartTrackingUponCompetitorSetChange() {
        return this.autoRestartTrackingUponCompetitorSetChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setControlTrackingFromStartAndFinishTimes(boolean controlTrackingFromStartAndFinishTimes) {
        if (controlTrackingFromStartAndFinishTimes != this.controlTrackingFromStartAndFinishTimes) {
            this.controlTrackingFromStartAndFinishTimes = controlTrackingFromStartAndFinishTimes;
            Set<RegattaListener> set = this.regattaListeners;
            synchronized (set) {
                for (RegattaListener l : this.regattaListeners) {
                    l.controlTrackingFromStartAndFinishTimesChanged(this, controlTrackingFromStartAndFinishTimes);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoRestartTrackingUponCompetitorSetChange(boolean autoRestartTrackingUponCompetitorSetChange) {
        if (autoRestartTrackingUponCompetitorSetChange != this.autoRestartTrackingUponCompetitorSetChange) {
            this.autoRestartTrackingUponCompetitorSetChange = autoRestartTrackingUponCompetitorSetChange;
            Set<RegattaListener> set = this.regattaListeners;
            synchronized (set) {
                for (RegattaListener l : this.regattaListeners) {
                    l.autoRestartTrackingUponCompetitorSetChangeChanged(this, autoRestartTrackingUponCompetitorSetChange);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseStartTimeInference(boolean useStartTimeInference) {
        if (useStartTimeInference != this.useStartTimeInference) {
            this.useStartTimeInference = useStartTimeInference;
            Set<RegattaListener> set = this.regattaListeners;
            synchronized (set) {
                for (RegattaListener l : this.regattaListeners) {
                    l.useStartTimeInferenceChanged(this, useStartTimeInference);
                }
            }
        }
    }

    @Override
    public RegattaConfiguration getRegattaConfiguration() {
        return this.configuration;
    }

    @Override
    public void setRegattaConfiguration(RegattaConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean definesSeriesDiscardThresholds() {
        for (Series series : this.series) {
            if (!series.definesSeriesDiscardThresholds()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getId() + " " + this.getName() + " " + this.getScoringScheme().getType().name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSeries(Series seriesToAdd) {
        Series existingSeries = this.getSeriesByName(seriesToAdd.getName());
        if (existingSeries == null) {
            this.linkToRegattaAndConnectRaceLogsAndAddListeners(seriesToAdd, true);
            List<? extends Series> list = this.series;
            synchronized (list) {
                ArrayList<? extends Series> newSeriesList = new ArrayList<Series>();
                for (Series series : this.series) {
                    newSeriesList.add(series);
                }
                newSeriesList.add(seriesToAdd);
                this.series = newSeriesList;
            }
        }
    }

    private void linkToRegattaAndConnectRaceLogsAndAddListeners(Series seriesToAdd, boolean loadRaceLogs) {
        seriesToAdd.setRegatta(this);
        seriesToAdd.addRaceColumnListener(this);
        this.registerRaceLogsOnRaceColumns(seriesToAdd, loadRaceLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSeries(Series series) {
        Series existingSeries = this.getSeriesByName(series.getName());
        if (existingSeries != null) {
            ArrayList raceColumns = new ArrayList();
            Util.addAll(series.getRaceColumns(), raceColumns);
            for (RaceColumn column : raceColumns) {
                for (Fleet fleet : column.getFleets()) {
                    column.removeRaceIdentifier(fleet);
                }
                series.removeRaceColumn(column.getName());
            }
            series.removeRaceColumnListener(this);
            List<? extends Series> list = this.series;
            synchronized (list) {
                ArrayList<? extends Series> newSeriesList = new ArrayList<Series>();
                for (Series series2 : this.series) {
                    if (series2.getName().equals(series.getName())) continue;
                    newSeriesList.add(series2);
                }
                this.series = newSeriesList;
            }
        }
    }

    @Override
    public boolean useStartTimeInference() {
        return this.useStartTimeInference;
    }

    @Override
    public boolean canBoatsOfCompetitorsChangePerRace() {
        return this.canBoatsOfCompetitorsChangePerRace;
    }

    protected void setCanBoatsOfCompetitorsChangePerRace(boolean canBoatsOfCompetitorsChangePerRace) {
        this.canBoatsOfCompetitorsChangePerRace = canBoatsOfCompetitorsChangePerRace;
    }

    @Override
    public void setCompetitorRegistrationType(CompetitorRegistrationType competitorRegistrationType) {
        this.competitorRegistrationType = competitorRegistrationType;
    }

    @Override
    public CompetitorRegistrationType getCompetitorRegistrationType() {
        return this.competitorRegistrationType == null ? CompetitorRegistrationType.CLOSED : this.competitorRegistrationType;
    }

    @Override
    public RegattaLog getRegattaLog() {
        return this.regattaLikeHelper.getRegattaLog();
    }

    @Override
    public RegattaLikeIdentifier getRegattaLikeIdentifier() {
        return this.regattaLikeHelper.getRegattaLikeIdentifier();
    }

    @Override
    public void addListener(RegattaLikeListener listener) {
        this.regattaLikeHelper.addListener(listener);
    }

    @Override
    public void removeListener(RegattaLikeListener listener) {
        this.regattaLikeHelper.removeListener(listener);
    }

    @Override
    public Double getTimeOnTimeFactor(Competitor competitor, Optional<Runnable> changeCallback) {
        return this.regattaLikeHelper.getTimeOnTimeFactor(competitor, changeCallback);
    }

    @Override
    public Duration getTimeOnDistanceAllowancePerNauticalMile(Competitor competitor, Optional<Runnable> changeCallback) {
        return this.regattaLikeHelper.getTimeOnDistanceAllowancePerNauticalMile(competitor, changeCallback);
    }

    @Override
    public RaceExecutionOrderProvider getRaceExecutionOrderProvider() {
        return this.raceExecutionOrderCache;
    }

    @Override
    public RaceColumn getRaceColumnByName(String raceColumnName) {
        return this.regattaLikeHelper.getRaceColumnByName(raceColumnName);
    }

    @Override
    public IsRegattaLike getRegattaLike() {
        return this;
    }

    @Override
    public RaceLog getRacelog(String raceColumnName, String fleetName) {
        Fleet fleet;
        RaceColumn raceColumn = this.getRaceColumnByName(raceColumnName);
        RaceLog result = raceColumn == null ? null : ((fleet = raceColumn.getFleetByName(fleetName)) == null ? null : raceColumn.getRaceLog(fleet));
        return result;
    }

    @Override
    public Iterable<? extends RaceColumn> getRaceColumns() {
        Iterable<Object> result = this.series.isEmpty() ? Collections.emptySet() : (this.series.size() == 1 ? this.series.get(0).getRaceColumns() : Util.concat((Iterable)Util.map(this.getSeries(), series -> Util.map(series.getRaceColumns(), rc -> rc))));
        return result;
    }

    @Override
    public Iterable<Competitor> getCompetitorsRegisteredInRegattaLog() {
        RegattaLog regattaLog = this.getRegattaLog();
        CompetitorsInLogAnalyzer analyzer = new CompetitorsInLogAnalyzer((AbstractLog)regattaLog);
        return (Iterable)analyzer.analyze();
    }

    @Override
    public void registerCompetitor(Competitor competitor) {
        this.registerCompetitors(Collections.singletonList(competitor));
    }

    @Override
    public void registerCompetitors(Iterable<Competitor> competitors) {
        RegattaLog regattaLog = this.getRegattaLike().getRegattaLog();
        TimePoint now = MillisecondsTimePoint.now();
        for (Competitor competitor : competitors) {
            regattaLog.add((AbstractLogEvent)new RegattaLogRegisterCompetitorEventImpl(now, now, this.regattaLogEventAuthorForRegatta, (Serializable)UUID.randomUUID(), competitor));
        }
    }

    @Override
    public void deregisterCompetitor(Competitor competitor) {
        this.deregisterCompetitors(Collections.singleton(competitor));
    }

    @Override
    public void deregisterCompetitors(Iterable<Competitor> competitors) {
        RegattaLog regattaLog = this.getRegattaLike().getRegattaLog();
        CompetitorDeregistrator deregisterer = new CompetitorDeregistrator((AbstractLog)regattaLog, competitors, this.regattaLogEventAuthorForRegatta);
        deregisterer.deregister((Set)deregisterer.analyze());
    }

    @Override
    public void setFleetsCanRunInParallelToTrue() {
        for (Series series : this.series) {
            series.setIsFleetsCanRunInParallel(true);
        }
    }

    @Override
    public Iterable<Boat> getBoatsRegisteredInRegattaLog() {
        RegattaLog regattaLog = this.getRegattaLog();
        RegattaLogBoatsInLogAnalyzer analyzer = new RegattaLogBoatsInLogAnalyzer((AbstractLog)regattaLog);
        return (Iterable)analyzer.analyze();
    }

    @Override
    public void registerBoat(Boat boat) {
        this.registerBoats(Collections.singleton(boat));
    }

    @Override
    public void registerBoats(Iterable<Boat> boats) {
        RegattaLog regattaLog = this.getRegattaLike().getRegattaLog();
        TimePoint now = MillisecondsTimePoint.now();
        for (Boat boat : boats) {
            regattaLog.add((AbstractLogEvent)new RegattaLogRegisterBoatEventImpl(now, now, this.regattaLogEventAuthorForRegatta, (Serializable)UUID.randomUUID(), boat));
        }
    }

    @Override
    public void deregisterBoat(Boat boat) {
        this.deregisterBoats(Collections.singleton(boat));
    }

    @Override
    public void deregisterBoats(Iterable<Boat> boats) {
        RegattaLog regattaLog = this.getRegattaLike().getRegattaLog();
        RegattaLogBoatDeregistrator deregisterer = new RegattaLogBoatDeregistrator((AbstractLog)regattaLog, boats, this.regattaLogEventAuthorForRegatta);
        deregisterer.deregister((Set)deregisterer.analyze());
    }

    @Override
    public String getRegistrationLinkSecret() {
        return this.registrationLinkSecret;
    }

    @Override
    public void setRegistrationLinkSecret(String registrationLinkSecret) {
        this.registrationLinkSecret = registrationLinkSecret;
    }

    private class RaceExecutionOrderCache
    extends AbstractRaceExecutionOrderProvider {
        private static final long serialVersionUID = 1658153438012186894L;

        public RaceExecutionOrderCache() {
            RegattaImpl.this.addRaceColumnListener(this);
        }

        @Override
        protected Map<Fleet, Iterable<? extends RaceColumn>> getRaceColumnsOfSeries() {
            HashMap<Fleet, Iterable<? extends RaceColumn>> result = new HashMap<Fleet, Iterable<? extends RaceColumn>>();
            Iterable<? extends Series> mySeries = RegattaImpl.this.getSeries();
            if (mySeries != null) {
                boolean concurrentlyModified = false;
                do {
                    try {
                        for (Series series : mySeries) {
                            if (series.getFleets() == null) continue;
                            for (Fleet fleet : series.getFleets()) {
                                if (series.getRaceColumns() == null) continue;
                                result.put(fleet, series.getRaceColumns());
                            }
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        logger.log(Level.INFO, "Got a ConcurrentModificationException while trying to update the RaceExecutionOrderCache", concurrentModificationException);
                        concurrentlyModified = true;
                    }
                } while (concurrentlyModified);
            }
            return result;
        }
    }
}

