/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpSetResponse extends Wafv2Response implements
        ToCopyableBuilder<CreateIpSetResponse.Builder, CreateIpSetResponse> {
    private static final SdkField<IPSetSummary> SUMMARY_FIELD = SdkField.<IPSetSummary> builder(MarshallingType.SDK_POJO)
            .memberName("Summary").getter(getter(CreateIpSetResponse::summary)).setter(setter(Builder::summary))
            .constructor(IPSetSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IPSetSummary summary;

    private CreateIpSetResponse(BuilderImpl builder) {
        super(builder);
        this.summary = builder.summary;
    }

    /**
     * <p>
     * High-level information about an <a>IPSet</a>, returned by operations like create and list. This provides
     * information like the ID, that you can use to retrieve and manage an <code>IPSet</code>, and the ARN, that you
     * provide to the <a>IPSetReferenceStatement</a> to use the address set in a <a>Rule</a>.
     * </p>
     * 
     * @return High-level information about an <a>IPSet</a>, returned by operations like create and list. This provides
     *         information like the ID, that you can use to retrieve and manage an <code>IPSet</code>, and the ARN, that
     *         you provide to the <a>IPSetReferenceStatement</a> to use the address set in a <a>Rule</a>.
     */
    public final IPSetSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpSetResponse)) {
            return false;
        }
        CreateIpSetResponse other = (CreateIpSetResponse) obj;
        return Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIpSetResponse").add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Summary", SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIpSetResponse, T> g) {
        return obj -> g.apply((CreateIpSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpSetResponse> {
        /**
         * <p>
         * High-level information about an <a>IPSet</a>, returned by operations like create and list. This provides
         * information like the ID, that you can use to retrieve and manage an <code>IPSet</code>, and the ARN, that you
         * provide to the <a>IPSetReferenceStatement</a> to use the address set in a <a>Rule</a>.
         * </p>
         * 
         * @param summary
         *        High-level information about an <a>IPSet</a>, returned by operations like create and list. This
         *        provides information like the ID, that you can use to retrieve and manage an <code>IPSet</code>, and
         *        the ARN, that you provide to the <a>IPSetReferenceStatement</a> to use the address set in a
         *        <a>Rule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(IPSetSummary summary);

        /**
         * <p>
         * High-level information about an <a>IPSet</a>, returned by operations like create and list. This provides
         * information like the ID, that you can use to retrieve and manage an <code>IPSet</code>, and the ARN, that you
         * provide to the <a>IPSetReferenceStatement</a> to use the address set in a <a>Rule</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link IPSetSummary.Builder} avoiding the need
         * to create one manually via {@link IPSetSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IPSetSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #summary(IPSetSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link IPSetSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(IPSetSummary)
         */
        default Builder summary(Consumer<IPSetSummary.Builder> summary) {
            return summary(IPSetSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private IPSetSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpSetResponse model) {
            super(model);
            summary(model.summary);
        }

        public final IPSetSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(IPSetSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(IPSetSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public CreateIpSetResponse build() {
            return new CreateIpSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
