/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventSourceMappingsResponse extends LambdaResponse implements
        ToCopyableBuilder<ListEventSourceMappingsResponse.Builder, ListEventSourceMappingsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListEventSourceMappingsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<EventSourceMappingConfiguration>> EVENT_SOURCE_MAPPINGS_FIELD = SdkField
            .<List<EventSourceMappingConfiguration>> builder(MarshallingType.LIST)
            .memberName("EventSourceMappings")
            .getter(getter(ListEventSourceMappingsResponse::eventSourceMappings))
            .setter(setter(Builder::eventSourceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSourceMappingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSourceMappingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            EVENT_SOURCE_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextMarker;

    private final List<EventSourceMappingConfiguration> eventSourceMappings;

    private ListEventSourceMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.eventSourceMappings = builder.eventSourceMappings;
    }

    /**
     * <p>
     * A pagination token that's returned when the response doesn't contain all event source mappings.
     * </p>
     * 
     * @return A pagination token that's returned when the response doesn't contain all event source mappings.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventSourceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventSourceMappings() {
        return eventSourceMappings != null && !(eventSourceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event source mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventSourceMappings} method.
     * </p>
     * 
     * @return A list of event source mappings.
     */
    public final List<EventSourceMappingConfiguration> eventSourceMappings() {
        return eventSourceMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventSourceMappings() ? eventSourceMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventSourceMappingsResponse)) {
            return false;
        }
        ListEventSourceMappingsResponse other = (ListEventSourceMappingsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasEventSourceMappings() == other.hasEventSourceMappings()
                && Objects.equals(eventSourceMappings(), other.eventSourceMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventSourceMappingsResponse").add("NextMarker", nextMarker())
                .add("EventSourceMappings", hasEventSourceMappings() ? eventSourceMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "EventSourceMappings":
            return Optional.ofNullable(clazz.cast(eventSourceMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("EventSourceMappings", EVENT_SOURCE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEventSourceMappingsResponse, T> g) {
        return obj -> g.apply((ListEventSourceMappingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEventSourceMappingsResponse> {
        /**
         * <p>
         * A pagination token that's returned when the response doesn't contain all event source mappings.
         * </p>
         * 
         * @param nextMarker
         *        A pagination token that's returned when the response doesn't contain all event source mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * A list of event source mappings.
         * </p>
         * 
         * @param eventSourceMappings
         *        A list of event source mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceMappings(Collection<EventSourceMappingConfiguration> eventSourceMappings);

        /**
         * <p>
         * A list of event source mappings.
         * </p>
         * 
         * @param eventSourceMappings
         *        A list of event source mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceMappings(EventSourceMappingConfiguration... eventSourceMappings);

        /**
         * <p>
         * A list of event source mappings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #eventSourceMappings(List<EventSourceMappingConfiguration>)}.
         * 
         * @param eventSourceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSourceMappings(java.util.Collection<EventSourceMappingConfiguration>)
         */
        Builder eventSourceMappings(Consumer<EventSourceMappingConfiguration.Builder>... eventSourceMappings);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<EventSourceMappingConfiguration> eventSourceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventSourceMappingsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            eventSourceMappings(model.eventSourceMappings);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<EventSourceMappingConfiguration.Builder> getEventSourceMappings() {
            List<EventSourceMappingConfiguration.Builder> result = EventSourceMappingsListCopier
                    .copyToBuilder(this.eventSourceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSourceMappings(Collection<EventSourceMappingConfiguration.BuilderImpl> eventSourceMappings) {
            this.eventSourceMappings = EventSourceMappingsListCopier.copyFromBuilder(eventSourceMappings);
        }

        @Override
        public final Builder eventSourceMappings(Collection<EventSourceMappingConfiguration> eventSourceMappings) {
            this.eventSourceMappings = EventSourceMappingsListCopier.copy(eventSourceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSourceMappings(EventSourceMappingConfiguration... eventSourceMappings) {
            eventSourceMappings(Arrays.asList(eventSourceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSourceMappings(Consumer<EventSourceMappingConfiguration.Builder>... eventSourceMappings) {
            eventSourceMappings(Stream.of(eventSourceMappings)
                    .map(c -> EventSourceMappingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEventSourceMappingsResponse build() {
            return new ListEventSourceMappingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
