/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an update to a security group rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityGroupRuleUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityGroupRuleUpdate.Builder, SecurityGroupRuleUpdate> {
    private static final SdkField<String> SECURITY_GROUP_RULE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupRuleId")
            .getter(getter(SecurityGroupRuleUpdate::securityGroupRuleId))
            .setter(setter(Builder::securityGroupRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleId")
                    .unmarshallLocationName("SecurityGroupRuleId").build()).build();

    private static final SdkField<SecurityGroupRuleRequest> SECURITY_GROUP_RULE_FIELD = SdkField
            .<SecurityGroupRuleRequest> builder(MarshallingType.SDK_POJO)
            .memberName("SecurityGroupRule")
            .getter(getter(SecurityGroupRuleUpdate::securityGroupRule))
            .setter(setter(Builder::securityGroupRule))
            .constructor(SecurityGroupRuleRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRule")
                    .unmarshallLocationName("SecurityGroupRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_RULE_ID_FIELD,
            SECURITY_GROUP_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String securityGroupRuleId;

    private final SecurityGroupRuleRequest securityGroupRule;

    private SecurityGroupRuleUpdate(BuilderImpl builder) {
        this.securityGroupRuleId = builder.securityGroupRuleId;
        this.securityGroupRule = builder.securityGroupRule;
    }

    /**
     * <p>
     * The ID of the security group rule.
     * </p>
     * 
     * @return The ID of the security group rule.
     */
    public final String securityGroupRuleId() {
        return securityGroupRuleId;
    }

    /**
     * <p>
     * Information about the security group rule.
     * </p>
     * 
     * @return Information about the security group rule.
     */
    public final SecurityGroupRuleRequest securityGroupRule() {
        return securityGroupRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupRuleUpdate)) {
            return false;
        }
        SecurityGroupRuleUpdate other = (SecurityGroupRuleUpdate) obj;
        return Objects.equals(securityGroupRuleId(), other.securityGroupRuleId())
                && Objects.equals(securityGroupRule(), other.securityGroupRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityGroupRuleUpdate").add("SecurityGroupRuleId", securityGroupRuleId())
                .add("SecurityGroupRule", securityGroupRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroupRuleId":
            return Optional.ofNullable(clazz.cast(securityGroupRuleId()));
        case "SecurityGroupRule":
            return Optional.ofNullable(clazz.cast(securityGroupRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecurityGroupRuleId", SECURITY_GROUP_RULE_ID_FIELD);
        map.put("SecurityGroupRule", SECURITY_GROUP_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupRuleUpdate, T> g) {
        return obj -> g.apply((SecurityGroupRuleUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityGroupRuleUpdate> {
        /**
         * <p>
         * The ID of the security group rule.
         * </p>
         * 
         * @param securityGroupRuleId
         *        The ID of the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRuleId(String securityGroupRuleId);

        /**
         * <p>
         * Information about the security group rule.
         * </p>
         * 
         * @param securityGroupRule
         *        Information about the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRule(SecurityGroupRuleRequest securityGroupRule);

        /**
         * <p>
         * Information about the security group rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityGroupRuleRequest.Builder}
         * avoiding the need to create one manually via {@link SecurityGroupRuleRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityGroupRuleRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #securityGroupRule(SecurityGroupRuleRequest)}.
         * 
         * @param securityGroupRule
         *        a consumer that will call methods on {@link SecurityGroupRuleRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroupRule(SecurityGroupRuleRequest)
         */
        default Builder securityGroupRule(Consumer<SecurityGroupRuleRequest.Builder> securityGroupRule) {
            return securityGroupRule(SecurityGroupRuleRequest.builder().applyMutation(securityGroupRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String securityGroupRuleId;

        private SecurityGroupRuleRequest securityGroupRule;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupRuleUpdate model) {
            securityGroupRuleId(model.securityGroupRuleId);
            securityGroupRule(model.securityGroupRule);
        }

        public final String getSecurityGroupRuleId() {
            return securityGroupRuleId;
        }

        public final void setSecurityGroupRuleId(String securityGroupRuleId) {
            this.securityGroupRuleId = securityGroupRuleId;
        }

        @Override
        public final Builder securityGroupRuleId(String securityGroupRuleId) {
            this.securityGroupRuleId = securityGroupRuleId;
            return this;
        }

        public final SecurityGroupRuleRequest.Builder getSecurityGroupRule() {
            return securityGroupRule != null ? securityGroupRule.toBuilder() : null;
        }

        public final void setSecurityGroupRule(SecurityGroupRuleRequest.BuilderImpl securityGroupRule) {
            this.securityGroupRule = securityGroupRule != null ? securityGroupRule.build() : null;
        }

        @Override
        public final Builder securityGroupRule(SecurityGroupRuleRequest securityGroupRule) {
            this.securityGroupRule = securityGroupRule;
            return this;
        }

        @Override
        public SecurityGroupRuleUpdate build() {
            return new SecurityGroupRuleUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
