/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device for an EBS volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetEbsBlockDeviceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetEbsBlockDeviceRequest.Builder, FleetEbsBlockDeviceRequest> {
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(FleetEbsBlockDeviceRequest::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("Encrypted").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(FleetEbsBlockDeviceRequest::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("DeleteOnTermination").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Iops")
            .getter(getter(FleetEbsBlockDeviceRequest::iops))
            .setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops")
                    .unmarshallLocationName("Iops").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Throughput")
            .getter(getter(FleetEbsBlockDeviceRequest::throughput))
            .setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput")
                    .unmarshallLocationName("Throughput").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId")
            .getter(getter(FleetEbsBlockDeviceRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("KmsKeyId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(FleetEbsBlockDeviceRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSize")
            .getter(getter(FleetEbsBlockDeviceRequest::volumeSize))
            .setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize")
                    .unmarshallLocationName("VolumeSize").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeType")
            .getter(getter(FleetEbsBlockDeviceRequest::volumeTypeAsString))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType")
                    .unmarshallLocationName("VolumeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTED_FIELD,
            DELETE_ON_TERMINATION_FIELD, IOPS_FIELD, THROUGHPUT_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ID_FIELD, VOLUME_SIZE_FIELD,
            VOLUME_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean encrypted;

    private final Boolean deleteOnTermination;

    private final Integer iops;

    private final Integer throughput;

    private final String kmsKeyId;

    private final String snapshotId;

    private final Integer volumeSize;

    private final String volumeType;

    private FleetEbsBlockDeviceRequest(BuilderImpl builder) {
        this.encrypted = builder.encrypted;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotId = builder.snapshotId;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
    }

    /**
     * <p>
     * Indicates whether the encryption state of an EBS volume is changed while being restored from a backing snapshot.
     * The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a
     * snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more
     * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS
     * encryption</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * In no case can you remove encryption from an encrypted volume.
     * </p>
     * <p>
     * Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances"
     * >Supported instance types</a>.
     * </p>
     * <p>
     * This parameter is not returned by <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute"
     * >DescribeImageAttribute</a>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage">CreateImage</a> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterImage">RegisterImage</a>, whether you
     * can include this parameter, and the allowed values differ depending on the type of block device mapping you are
     * creating.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are creating a block device mapping for a <b>new (empty) volume</b>, you can include this parameter, and
     * specify either <code>true</code> for an encrypted volume, or <code>false</code> for an unencrypted volume. If you
     * omit this parameter, it defaults to <code>false</code> (unencrypted).
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are creating a block device mapping from an <b>existing encrypted or unencrypted snapshot</b>, you must
     * omit this parameter. If you include this parameter, the request will fail, regardless of the value that you
     * specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are creating a block device mapping from an <b>existing unencrypted volume</b>, you can include this
     * parameter, but you must specify <code>false</code>. If you specify <code>true</code>, the request will fail. In
     * this case, we recommend that you omit the parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are creating a block device mapping from an <b>existing encrypted volume</b>, you can include this
     * parameter, and specify either <code>true</code> or <code>false</code>. However, if you specify <code>false</code>
     * , the parameter is ignored and the block device mapping is always encrypted. In this case, we recommend that you
     * omit the parameter.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether the encryption state of an EBS volume is changed while being restored from a backing
     *         snapshot. The effect of setting the encryption state to <code>true</code> depends on the volume origin
     *         (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is
     *         enabled. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in
     *         the <i>Amazon EBS User Guide</i>.</p>
     *         <p>
     *         In no case can you remove encryption from an encrypted volume.
     *         </p>
     *         <p>
     *         Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances"
     *         >Supported instance types</a>.
     *         </p>
     *         <p>
     *         This parameter is not returned by <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute"
     *         >DescribeImageAttribute</a>.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage">CreateImage</a> and
     *         <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterImage">RegisterImage</a>,
     *         whether you can include this parameter, and the allowed values differ depending on the type of block
     *         device mapping you are creating.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are creating a block device mapping for a <b>new (empty) volume</b>, you can include this
     *         parameter, and specify either <code>true</code> for an encrypted volume, or <code>false</code> for an
     *         unencrypted volume. If you omit this parameter, it defaults to <code>false</code> (unencrypted).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are creating a block device mapping from an <b>existing encrypted or unencrypted snapshot</b>, you
     *         must omit this parameter. If you include this parameter, the request will fail, regardless of the value
     *         that you specify.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are creating a block device mapping from an <b>existing unencrypted volume</b>, you can include
     *         this parameter, but you must specify <code>false</code>. If you specify <code>true</code>, the request
     *         will fail. In this case, we recommend that you omit the parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are creating a block device mapping from an <b>existing encrypted volume</b>, you can include this
     *         parameter, and specify either <code>true</code> or <code>false</code>. However, if you specify
     *         <code>false</code>, the parameter is ignored and the block device mapping is always encrypted. In this
     *         case, we recommend that you omit the parameter.
     *         </p>
     *         </li>
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * Indicates whether the EBS volume is deleted on instance termination. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/preserving-volumes-on-termination.html">Preserve data
     * when an instance is terminated</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return Indicates whether the EBS volume is deleted on instance termination. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/preserving-volumes-on-termination.html"
     *         >Preserve data when an instance is terminated</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code>
     * volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes,
     * this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits
     * for bursting.
     * </p>
     * <p>
     * The following are the supported values for each volume type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>gp3</code>: 3,000 - 16,000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code>: 100 - 64,000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io2</code>: 100 - 256,000 IOPS
     * </p>
     * </li>
     * </ul>
     * <p>
     * For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">instances
     * built on the Nitro System</a>. On other instances, you can achieve performance up to 32,000 IOPS.
     * </p>
     * <p>
     * This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code>
     * volumes is 3,000 IOPS.
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and
     *         <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For
     *         <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which
     *         the volume accumulates I/O credits for bursting.</p>
     *         <p>
     *         The following are the supported values for each volume type:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>gp3</code>: 3,000 - 16,000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code>: 100 - 64,000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io2</code>: 100 - 256,000 IOPS
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances"
     *         >instances built on the Nitro System</a>. On other instances, you can achieve performance up to 32,000
     *         IOPS.
     *         </p>
     *         <p>
     *         This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for
     *         <code>gp3</code> volumes is 3,000 IOPS.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The throughput that the volume supports, in MiB/s.
     * </p>
     * <p>
     * This parameter is valid only for <code>gp3</code> volumes.
     * </p>
     * <p>
     * Valid Range: Minimum value of 125. Maximum value of 1000.
     * </p>
     * 
     * @return The throughput that the volume supports, in MiB/s.</p>
     *         <p>
     *         This parameter is valid only for <code>gp3</code> volumes.
     *         </p>
     *         <p>
     *         Valid Range: Minimum value of 125. Maximum value of 1000.
     */
    public final Integer throughput() {
        return throughput;
    }

    /**
     * <p>
     * Identifier (key ID, key alias, key ARN, or alias ARN) of the customer managed KMS key to use for EBS encryption.
     * </p>
     * <p>
     * This parameter is only supported on <code>BlockDeviceMapping</code> objects called by <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet.html">CreateFleet</a>, <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html"
     * >RequestSpotInstances</a>, and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.
     * </p>
     * 
     * @return Identifier (key ID, key alias, key ARN, or alias ARN) of the customer managed KMS key to use for EBS
     *         encryption.</p>
     *         <p>
     *         This parameter is only supported on <code>BlockDeviceMapping</code> objects called by <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet.html">CreateFleet</a>, <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">
     *         RequestSpotInstances</a>, and <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a
     * snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the
     * snapshot size.
     * </p>
     * <p>
     * The following are the supported sizes for each volume type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code>: 4 - 16,384 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io2</code>: 4 - 65,536 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>standard</code>: 1 - 1024 GiB
     * </p>
     * </li>
     * </ul>
     * 
     * @return The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a
     *         snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than
     *         the snapshot size.</p>
     *         <p>
     *         The following are the supported sizes for each volume type:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code>: 4 - 16,384 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io2</code>: 4 - 65,536 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>standard</code>: 1 - 1024 GiB
     *         </p>
     *         </li>
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The volume type. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a>
     *         in the <i>Amazon EBS User Guide</i>.
     * @see VolumeType
     */
    public final VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The volume type. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a>
     *         in the <i>Amazon EBS User Guide</i>.
     * @see VolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetEbsBlockDeviceRequest)) {
            return false;
        }
        FleetEbsBlockDeviceRequest other = (FleetEbsBlockDeviceRequest) obj;
        return Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(iops(), other.iops())
                && Objects.equals(throughput(), other.throughput()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetEbsBlockDeviceRequest").add("Encrypted", encrypted())
                .add("DeleteOnTermination", deleteOnTermination()).add("Iops", iops()).add("Throughput", throughput())
                .add("KmsKeyId", kmsKeyId()).add("SnapshotId", snapshotId()).add("VolumeSize", volumeSize())
                .add("VolumeType", volumeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("VolumeSize", VOLUME_SIZE_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetEbsBlockDeviceRequest, T> g) {
        return obj -> g.apply((FleetEbsBlockDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetEbsBlockDeviceRequest> {
        /**
         * <p>
         * Indicates whether the encryption state of an EBS volume is changed while being restored from a backing
         * snapshot. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new
         * or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For
         * more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon
         * EBS encryption</a> in the <i>Amazon EBS User Guide</i>.
         * </p>
         * <p>
         * In no case can you remove encryption from an encrypted volume.
         * </p>
         * <p>
         * Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information,
         * see <a href=
         * "https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances"
         * >Supported instance types</a>.
         * </p>
         * <p>
         * This parameter is not returned by <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute"
         * >DescribeImageAttribute</a>.
         * </p>
         * <p>
         * For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage">CreateImage</a> and <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterImage">RegisterImage</a>, whether
         * you can include this parameter, and the allowed values differ depending on the type of block device mapping
         * you are creating.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are creating a block device mapping for a <b>new (empty) volume</b>, you can include this parameter,
         * and specify either <code>true</code> for an encrypted volume, or <code>false</code> for an unencrypted
         * volume. If you omit this parameter, it defaults to <code>false</code> (unencrypted).
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are creating a block device mapping from an <b>existing encrypted or unencrypted snapshot</b>, you
         * must omit this parameter. If you include this parameter, the request will fail, regardless of the value that
         * you specify.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are creating a block device mapping from an <b>existing unencrypted volume</b>, you can include this
         * parameter, but you must specify <code>false</code>. If you specify <code>true</code>, the request will fail.
         * In this case, we recommend that you omit the parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are creating a block device mapping from an <b>existing encrypted volume</b>, you can include this
         * parameter, and specify either <code>true</code> or <code>false</code>. However, if you specify
         * <code>false</code>, the parameter is ignored and the block device mapping is always encrypted. In this case,
         * we recommend that you omit the parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encrypted
         *        Indicates whether the encryption state of an EBS volume is changed while being restored from a backing
         *        snapshot. The effect of setting the encryption state to <code>true</code> depends on the volume origin
         *        (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is
         *        enabled. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a>
         *        in the <i>Amazon EBS User Guide</i>.</p>
         *        <p>
         *        In no case can you remove encryption from an encrypted volume.
         *        </p>
         *        <p>
         *        Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances"
         *        >Supported instance types</a>.
         *        </p>
         *        <p>
         *        This parameter is not returned by <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute"
         *        >DescribeImageAttribute</a>.
         *        </p>
         *        <p>
         *        For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage">CreateImage</a>
         *        and <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterImage">RegisterImage</a>,
         *        whether you can include this parameter, and the allowed values differ depending on the type of block
         *        device mapping you are creating.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are creating a block device mapping for a <b>new (empty) volume</b>, you can include this
         *        parameter, and specify either <code>true</code> for an encrypted volume, or <code>false</code> for an
         *        unencrypted volume. If you omit this parameter, it defaults to <code>false</code> (unencrypted).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are creating a block device mapping from an <b>existing encrypted or unencrypted snapshot</b>,
         *        you must omit this parameter. If you include this parameter, the request will fail, regardless of the
         *        value that you specify.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are creating a block device mapping from an <b>existing unencrypted volume</b>, you can include
         *        this parameter, but you must specify <code>false</code>. If you specify <code>true</code>, the request
         *        will fail. In this case, we recommend that you omit the parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are creating a block device mapping from an <b>existing encrypted volume</b>, you can include
         *        this parameter, and specify either <code>true</code> or <code>false</code>. However, if you specify
         *        <code>false</code>, the parameter is ignored and the block device mapping is always encrypted. In this
         *        case, we recommend that you omit the parameter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * Indicates whether the EBS volume is deleted on instance termination. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/preserving-volumes-on-termination.html">Preserve
         * data when an instance is terminated</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the EBS volume is deleted on instance termination. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/preserving-volumes-on-termination.html">Preserve
         *        data when an instance is terminated</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code>
         * volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code>
         * volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates
         * I/O credits for bursting.
         * </p>
         * <p>
         * The following are the supported values for each volume type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>gp3</code>: 3,000 - 16,000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code>: 100 - 64,000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io2</code>: 100 - 256,000 IOPS
         * </p>
         * </li>
         * </ul>
         * <p>
         * For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">instances
         * built on the Nitro System</a>. On other instances, you can achieve performance up to 32,000 IOPS.
         * </p>
         * <p>
         * This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for
         * <code>gp3</code> volumes is 3,000 IOPS.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and
         *        <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For
         *        <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which
         *        the volume accumulates I/O credits for bursting.</p>
         *        <p>
         *        The following are the supported values for each volume type:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>gp3</code>: 3,000 - 16,000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code>: 100 - 64,000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io2</code>: 100 - 256,000 IOPS
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For <code>io2</code> volumes, you can achieve up to 256,000 IOPS on <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances"
         *        >instances built on the Nitro System</a>. On other instances, you can achieve performance up to 32,000
         *        IOPS.
         *        </p>
         *        <p>
         *        This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for
         *        <code>gp3</code> volumes is 3,000 IOPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The throughput that the volume supports, in MiB/s.
         * </p>
         * <p>
         * This parameter is valid only for <code>gp3</code> volumes.
         * </p>
         * <p>
         * Valid Range: Minimum value of 125. Maximum value of 1000.
         * </p>
         * 
         * @param throughput
         *        The throughput that the volume supports, in MiB/s.</p>
         *        <p>
         *        This parameter is valid only for <code>gp3</code> volumes.
         *        </p>
         *        <p>
         *        Valid Range: Minimum value of 125. Maximum value of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);

        /**
         * <p>
         * Identifier (key ID, key alias, key ARN, or alias ARN) of the customer managed KMS key to use for EBS
         * encryption.
         * </p>
         * <p>
         * This parameter is only supported on <code>BlockDeviceMapping</code> objects called by <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet.html">CreateFleet</a>, <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html"
         * >RequestSpotInstances</a>, and <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.
         * </p>
         * 
         * @param kmsKeyId
         *        Identifier (key ID, key alias, key ARN, or alias ARN) of the customer managed KMS key to use for EBS
         *        encryption.</p>
         *        <p>
         *        This parameter is only supported on <code>BlockDeviceMapping</code> objects called by <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet.html">CreateFleet</a>, <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">
         *        RequestSpotInstances</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a
         * snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the
         * snapshot size.
         * </p>
         * <p>
         * The following are the supported sizes for each volume type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code>: 4 - 16,384 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io2</code>: 4 - 65,536 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>standard</code>: 1 - 1024 GiB
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeSize
         *        The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you
         *        specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to
         *        or larger than the snapshot size.</p>
         *        <p>
         *        The following are the supported sizes for each volume type:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>gp2</code> and <code>gp3</code>: 1 - 16,384 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code>: 4 - 16,384 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io2</code>: 4 - 65,536 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>st1</code> and <code>sc1</code>: 125 - 16,384 GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>standard</code>: 1 - 1024 GiB
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * The volume type. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in
         * the <i>Amazon EBS User Guide</i>.
         * </p>
         * 
         * @param volumeType
         *        The volume type. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume
         *        types</a> in the <i>Amazon EBS User Guide</i>.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The volume type. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in
         * the <i>Amazon EBS User Guide</i>.
         * </p>
         * 
         * @param volumeType
         *        The volume type. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume
         *        types</a> in the <i>Amazon EBS User Guide</i>.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean encrypted;

        private Boolean deleteOnTermination;

        private Integer iops;

        private Integer throughput;

        private String kmsKeyId;

        private String snapshotId;

        private Integer volumeSize;

        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetEbsBlockDeviceRequest model) {
            encrypted(model.encrypted);
            deleteOnTermination(model.deleteOnTermination);
            iops(model.iops);
            throughput(model.throughput);
            kmsKeyId(model.kmsKeyId);
            snapshotId(model.snapshotId);
            volumeSize(model.volumeSize);
            volumeType(model.volumeType);
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        @Override
        public FleetEbsBlockDeviceRequest build() {
            return new FleetEbsBlockDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
