/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMacModificationTasksRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeMacModificationTasksRequest.Builder, DescribeMacModificationTasksRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeMacModificationTasksRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeMacModificationTasksRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> MAC_MODIFICATION_TASK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MacModificationTaskIds")
            .getter(getter(DescribeMacModificationTasksRequest::macModificationTaskIds))
            .setter(setter(Builder::macModificationTaskIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacModificationTaskId")
                    .unmarshallLocationName("MacModificationTaskId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeMacModificationTasksRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeMacModificationTasksRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, FILTERS_FIELD,
            MAC_MODIFICATION_TASK_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final List<Filter> filters;

    private final List<String> macModificationTaskIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeMacModificationTasksRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.filters = builder.filters;
        this.macModificationTaskIds = builder.macModificationTaskIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies one or more filters for the request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance for which the task was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>task-state</code> - The state of the task (<code>successful</code> | <code>failed</code> |
     * <code>in-progress</code> | <code>pending</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mac-system-integrity-protection-configuration.sip-status</code> - The overall SIP state requested in the
     * task (<code>enabled</code> | <code>disabled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start-time</code> - The date and time the task was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>task-type</code> - The type of task (<code>sip-modification</code> |
     * <code>volume-ownership-delegation</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Specifies one or more filters for the request:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance for which the task was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>task-state</code> - The state of the task (<code>successful</code> | <code>failed</code> |
     *         <code>in-progress</code> | <code>pending</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mac-system-integrity-protection-configuration.sip-status</code> - The overall SIP state requested
     *         in the task (<code>enabled</code> | <code>disabled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start-time</code> - The date and time the task was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>task-type</code> - The type of task (<code>sip-modification</code> |
     *         <code>volume-ownership-delegation</code>).
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the MacModificationTaskIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMacModificationTaskIds() {
        return macModificationTaskIds != null && !(macModificationTaskIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMacModificationTaskIds} method.
     * </p>
     * 
     * @return The ID of task.
     */
    public final List<String> macModificationTaskIds() {
        return macModificationTaskIds;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If
     * <code>maxResults</code> is given a larger value than 500, you receive an error.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the returned <code>nextToken</code> value. This value can be between
     *         5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMacModificationTaskIds() ? macModificationTaskIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMacModificationTasksRequest)) {
            return false;
        }
        DescribeMacModificationTasksRequest other = (DescribeMacModificationTasksRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && hasMacModificationTaskIds() == other.hasMacModificationTaskIds()
                && Objects.equals(macModificationTaskIds(), other.macModificationTaskIds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMacModificationTasksRequest").add("DryRun", dryRun())
                .add("Filters", hasFilters() ? filters() : null)
                .add("MacModificationTaskIds", hasMacModificationTaskIds() ? macModificationTaskIds() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MacModificationTaskIds":
            return Optional.ofNullable(clazz.cast(macModificationTaskIds()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("Filter", FILTERS_FIELD);
        map.put("MacModificationTaskId", MAC_MODIFICATION_TASK_IDS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMacModificationTasksRequest, T> g) {
        return obj -> g.apply((DescribeMacModificationTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMacModificationTasksRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Specifies one or more filters for the request:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance for which the task was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>task-state</code> - The state of the task (<code>successful</code> | <code>failed</code> |
         * <code>in-progress</code> | <code>pending</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-system-integrity-protection-configuration.sip-status</code> - The overall SIP state requested in
         * the task (<code>enabled</code> | <code>disabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The date and time the task was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>task-type</code> - The type of task (<code>sip-modification</code> |
         * <code>volume-ownership-delegation</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Specifies one or more filters for the request:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance for which the task was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>task-state</code> - The state of the task (<code>successful</code> | <code>failed</code> |
         *        <code>in-progress</code> | <code>pending</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mac-system-integrity-protection-configuration.sip-status</code> - The overall SIP state
         *        requested in the task (<code>enabled</code> | <code>disabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The date and time the task was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>task-type</code> - The type of task (<code>sip-modification</code> |
         *        <code>volume-ownership-delegation</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * Specifies one or more filters for the request:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance for which the task was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>task-state</code> - The state of the task (<code>successful</code> | <code>failed</code> |
         * <code>in-progress</code> | <code>pending</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-system-integrity-protection-configuration.sip-status</code> - The overall SIP state requested in
         * the task (<code>enabled</code> | <code>disabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The date and time the task was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>task-type</code> - The type of task (<code>sip-modification</code> |
         * <code>volume-ownership-delegation</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Specifies one or more filters for the request:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance for which the task was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>task-state</code> - The state of the task (<code>successful</code> | <code>failed</code> |
         *        <code>in-progress</code> | <code>pending</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mac-system-integrity-protection-configuration.sip-status</code> - The overall SIP state
         *        requested in the task (<code>enabled</code> | <code>disabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The date and time the task was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>task-type</code> - The type of task (<code>sip-modification</code> |
         *        <code>volume-ownership-delegation</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Specifies one or more filters for the request:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance for which the task was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>task-state</code> - The state of the task (<code>successful</code> | <code>failed</code> |
         * <code>in-progress</code> | <code>pending</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-system-integrity-protection-configuration.sip-status</code> - The overall SIP state requested in
         * the task (<code>enabled</code> | <code>disabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The date and time the task was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>task-type</code> - The type of task (<code>sip-modification</code> |
         * <code>volume-ownership-delegation</code>).
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The ID of task.
         * </p>
         * 
         * @param macModificationTaskIds
         *        The ID of task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macModificationTaskIds(Collection<String> macModificationTaskIds);

        /**
         * <p>
         * The ID of task.
         * </p>
         * 
         * @param macModificationTaskIds
         *        The ID of task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macModificationTaskIds(String... macModificationTaskIds);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and
         * 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the returned <code>nextToken</code> value. This value can be
         *        between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> macModificationTaskIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMacModificationTasksRequest model) {
            super(model);
            dryRun(model.dryRun);
            filters(model.filters);
            macModificationTaskIds(model.macModificationTaskIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getMacModificationTaskIds() {
            if (macModificationTaskIds instanceof SdkAutoConstructList) {
                return null;
            }
            return macModificationTaskIds;
        }

        public final void setMacModificationTaskIds(Collection<String> macModificationTaskIds) {
            this.macModificationTaskIds = MacModificationTaskIdListCopier.copy(macModificationTaskIds);
        }

        @Override
        public final Builder macModificationTaskIds(Collection<String> macModificationTaskIds) {
            this.macModificationTaskIds = MacModificationTaskIdListCopier.copy(macModificationTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macModificationTaskIds(String... macModificationTaskIds) {
            macModificationTaskIds(Arrays.asList(macModificationTaskIds));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMacModificationTasksRequest build() {
            return new DescribeMacModificationTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
