/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.media.mp4;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class MP4ParserFakeFile
extends FileChannel {
    private final long totalSizeOfFile;
    private long currentPos = 0L;
    private byte[] startOfFileByteArray;
    private byte[] endOfFileByteArray;

    public MP4ParserFakeFile(byte[] start, byte[] end, Long skipped) {
        this.startOfFileByteArray = start;
        this.endOfFileByteArray = end;
        this.totalSizeOfFile = (long)(start.length + end.length) + skipped;
    }

    public MP4ParserFakeFile(File tmp) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (SeekableByteChannel inChannel = Files.newByteChannel(tmp.toPath(), new OpenOption[0]);){
                this.totalSizeOfFile = tmp.length();
                if (this.totalSizeOfFile < 20000000L) {
                    throw new IllegalStateException("The file is to small to be analysed < 20000000");
                }
                this.startOfFileByteArray = new byte[10000000];
                this.endOfFileByteArray = new byte[10000000];
                ByteBuffer startOfFileByteBuffer = ByteBuffer.wrap(this.startOfFileByteArray);
                ByteBuffer endOfFileByteBuffer = ByteBuffer.wrap(this.endOfFileByteArray);
                int startRead = inChannel.read(startOfFileByteBuffer);
                if (startRead != startOfFileByteBuffer.capacity()) {
                    throw new IllegalArgumentException("Could not read fileStart");
                }
                inChannel.position(this.totalSizeOfFile - 10000001L);
                int endRead = inChannel.read(endOfFileByteBuffer);
                if (endRead != endOfFileByteBuffer.capacity()) {
                    throw new IllegalArgumentException("Could not read fileStart");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read = 0;
        int toRead = dst.remaining();
        long startOfEndSegment = this.totalSizeOfFile - (long)(this.endOfFileByteArray.length + 1);
        if (this.currentPos < (long)this.startOfFileByteArray.length) {
            dst.put(this.startOfFileByteArray, (int)this.currentPos, toRead);
            read = toRead;
        } else {
            if (this.currentPos < startOfEndSegment) {
                throw new IllegalArgumentException("The nulled part should only be in the skipped boxes, else reading would be corrupt");
            }
            int remaining = (int)(this.totalSizeOfFile - this.currentPos);
            int relative = this.endOfFileByteArray.length - remaining;
            if (this.currentPos + (long)toRead > this.totalSizeOfFile) {
                toRead = (int)(this.totalSizeOfFile - this.currentPos);
            }
            if (toRead > 0) {
                dst.put(this.endOfFileByteArray, relative, toRead);
                read = toRead;
            } else {
                read = -1;
            }
        }
        this.currentPos += (long)read;
        return read;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new IllegalArgumentException("MP4 files should only be read");
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public long position() throws IOException {
        return this.currentPos;
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.currentPos = newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public void force(boolean metaData) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    protected void implCloseChannel() throws IOException {
    }
}

