/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.mining;

import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.impl.SpeedWithBearingWithConfidenceImpl;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.polars.impl.CubicEquation;
import com.sap.sailing.polars.regression.IncrementalLeastSquares;
import com.sap.sailing.polars.regression.impl.IncrementalAnyOrderLeastSquaresImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;

public class AngleAndSpeedRegression
implements Serializable {
    private static final long serialVersionUID = 6343595388753945979L;
    private final IncrementalLeastSquares speedRegression;
    private final IncrementalLeastSquares angleRegression;
    private double maxWindSpeedInKnots;

    public AngleAndSpeedRegression() {
        this.speedRegression = new IncrementalAnyOrderLeastSquaresImpl(3, false);
        this.angleRegression = new IncrementalAnyOrderLeastSquaresImpl(3);
        this.maxWindSpeedInKnots = -1.0;
    }

    public AngleAndSpeedRegression(double maxWindSpeedInKnots, IncrementalLeastSquares speedRegression, IncrementalLeastSquares angleRegression) {
        this.speedRegression = speedRegression;
        this.angleRegression = angleRegression;
        this.maxWindSpeedInKnots = maxWindSpeedInKnots;
    }

    public void addData(WindWithConfidence<Util.Pair<Position, TimePoint>> windSpeed, BearingWithConfidence<Void> angleToTheWind, SpeedWithBearingWithConfidence<TimePoint> boatSpeed) {
        double windSpeedInKnots = ((Wind)windSpeed.getObject()).getKnots();
        if (windSpeedInKnots > this.maxWindSpeedInKnots) {
            this.maxWindSpeedInKnots = windSpeedInKnots;
        }
        this.speedRegression.addData(windSpeedInKnots, boatSpeed.getObject().getKnots());
        this.angleRegression.addData(windSpeedInKnots, ((Bearing)angleToTheWind.getObject()).getDegrees());
    }

    public SpeedWithBearingWithConfidence<Void> estimateSpeedAndAngle(Speed windSpeed) throws NotEnoughDataHasBeenAddedException {
        double windSpeedInKnots = windSpeed.getKnots();
        if (windSpeedInKnots > this.maxWindSpeedInKnots) {
            throw new NotEnoughDataHasBeenAddedException();
        }
        double estimatedSpeed = this.speedRegression.getOrCreatePolynomialFunction().value(windSpeedInKnots);
        double estimatedAngle = this.angleRegression.getOrCreatePolynomialFunction().value(windSpeedInKnots);
        DegreeBearingImpl bearing = new DegreeBearingImpl(estimatedAngle);
        KnotSpeedWithBearingImpl speedWithBearing = new KnotSpeedWithBearingImpl(estimatedSpeed, (Bearing)bearing);
        return new SpeedWithBearingWithConfidenceImpl((SpeedWithBearing)speedWithBearing, Math.min(1.0, (double)this.speedRegression.getNumberOfAddedPoints() / 100.0), null);
    }

    public Set<SpeedWithBearingWithConfidence<Void>> estimateTrueWindSpeedAndAngleCandidates(Speed speedOverGround, LegType legType, Tack tack) throws NotEnoughDataHasBeenAddedException {
        HashSet<SpeedWithBearingWithConfidence<Void>> result = new HashSet<SpeedWithBearingWithConfidence<Void>>();
        double[] coefficients = this.speedRegression.getOrCreatePolynomialFunction().getCoefficients();
        if (coefficients.length > 2) {
            CubicEquation equation = new CubicEquation(coefficients[2], coefficients[1], coefficients[0], -speedOverGround.getKnots());
            double[] windSpeedCandidates = equation.solve();
            int i = 0;
            while (i < windSpeedCandidates.length) {
                double windSpeedCandidateInKnots = windSpeedCandidates[i];
                if (windSpeedCandidateInKnots >= 0.0 && windSpeedCandidateInKnots <= this.maxWindSpeedInKnots) {
                    boolean angleFound;
                    double angle = 0.0;
                    try {
                        angle = this.angleRegression.getOrCreatePolynomialFunction().value(windSpeedCandidateInKnots);
                        if (tack == Tack.PORT) {
                            angle = -angle;
                        }
                        angleFound = true;
                    }
                    catch (NotEnoughDataHasBeenAddedException e) {
                        angleFound = false;
                    }
                    if (angleFound) {
                        result.add((SpeedWithBearingWithConfidence<Void>)new SpeedWithBearingWithConfidenceImpl((SpeedWithBearing)new KnotSpeedWithBearingImpl(windSpeedCandidateInKnots, (Bearing)new DegreeBearingImpl(angle)), 0.5, null));
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public PolynomialFunction getSpeedRegressionFunction() throws NotEnoughDataHasBeenAddedException {
        return this.speedRegression.getOrCreatePolynomialFunction();
    }

    public PolynomialFunction getAngleRegressionFunction() throws NotEnoughDataHasBeenAddedException {
        return this.angleRegression.getOrCreatePolynomialFunction();
    }

    public IncrementalAnyOrderLeastSquaresImpl getSpeedRegression() {
        return (IncrementalAnyOrderLeastSquaresImpl)this.speedRegression;
    }

    public IncrementalAnyOrderLeastSquaresImpl getAngleRegression() {
        return (IncrementalAnyOrderLeastSquaresImpl)this.angleRegression;
    }

    public double getMaxWindSpeedInKnots() {
        return this.maxWindSpeedInKnots;
    }
}

