/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceBoatSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceCompetitorSensorDataMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceBoatExpeditionExtendedMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceCompetitorExpeditionExtendedMappingEventImpl;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.sensordata.ExpeditionExtendedSensorDataMetadata;
import com.sap.sailing.domain.common.tracking.impl.DoubleVectorFixImpl;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.BaseDoubleVectorFixImporter;
import com.sap.sailing.domain.trackimport.DoubleVectorFixImporter;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.server.trackfiles.impl.AbstractDoubleVectorFixImporter;
import com.sap.sailing.server.trackfiles.impl.CompressedStreamsUtil;
import com.sap.sailing.server.trackfiles.impl.ExpeditionImportFileHandler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ExpeditionExtendedDataImporterImpl
extends AbstractDoubleVectorFixImporter
implements DoubleVectorFixImporter {
    private static final Logger logger = Logger.getLogger(ExpeditionExtendedDataImporterImpl.class.getName());
    private static final String ORIGINAL_POSITION_HEADER = "pos[ddd.dd]";
    public static final String BOAT_COL = "boat";
    public static final String COL_NAME_LAT = "lat";
    public static final String COL_NAME_LON = "lon";
    private static final String UTC_COLUMN = "utc";
    private static final String DATE_COLUMN_1 = "dd/mm/yy";
    private static final String DATE_COLUMN_1_PATTERN = "dd/MM/yy";
    private static final String DATE_COLUMN_2 = "mm/dd/yy";
    private static final String DATE_COLUMN_2_PATTERN = "MM/dd/yy";
    private static final String TIME_COLUMN = "hhmmss";
    private static final String GPS_TIME_COLUMN = "gps time";
    private static final Pattern BOAT_CHECK_PATTERN = Pattern.compile("[1-9]?[0-9]");
    private final Map<String, Integer> columnNamesInFileAndTheirValueIndexInResultingDoubleVectorFix = this.getColumnNamesToIndexInDoubleFix();
    private final int trackColumnCount = this.columnNamesInFileAndTheirValueIndexInResultingDoubleVectorFix.values().stream().max((x, y) -> Integer.compare(x, y)).get() + 1;
    private static final Calendar EXCEL_EPOCH_START = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private static final BigDecimal MILLISECONDS_PER_DAY;

    static {
        EXCEL_EPOCH_START.set(1899, 11, 30, 0, 0, 0);
        EXCEL_EPOCH_START.set(14, 0);
        MILLISECONDS_PER_DAY = BigDecimal.valueOf(86400000L);
    }

    public ExpeditionExtendedDataImporterImpl() {
        this("EXPEDITION_EXTENDED");
    }

    protected ExpeditionExtendedDataImporterImpl(String fixType) {
        super(fixType);
    }

    protected Map<String, Integer> getColumnNamesToIndexInDoubleFix() {
        return ExpeditionExtendedSensorDataMetadata.getColumnNamesToIndexInDoubleFix();
    }

    public RegattaLogDeviceCompetitorSensorDataMappingEvent createEvent(TimePoint createdAt, TimePoint logicalTimePoint, AbstractLogEventAuthor author, Serializable id, Competitor mappedTo, DeviceIdentifier device, TimePoint from, TimePoint to) {
        return new RegattaLogDeviceCompetitorExpeditionExtendedMappingEventImpl(createdAt, logicalTimePoint, author, id, mappedTo, device, from, to);
    }

    public RegattaLogDeviceBoatSensorDataMappingEvent createEvent(TimePoint createdAt, TimePoint logicalTimePoint, AbstractLogEventAuthor author, Serializable id, Boat mappedTo, DeviceIdentifier device, TimePoint from, TimePoint to) {
        return new RegattaLogDeviceBoatExpeditionExtendedMappingEventImpl(createdAt, logicalTimePoint, author, id, mappedTo, device, from, to);
    }

    public boolean importFixes(InputStream inputStream, Charset charset, BaseDoubleVectorFixImporter.Callback callback, String filename, String sourceName, boolean downsample) throws FormatNotSupportedException, IOException {
        TrackFileImportDeviceIdentifierImpl trackIdentifier = this.getTrackIdentifier(filename, sourceName);
        AtomicBoolean importedFixes = new AtomicBoolean(false);
        CompressedStreamsUtil.handlePotentiallyCompressedFiles(filename, inputStream, charset, this.getFileHandler((TrackFileImportDeviceIdentifier)trackIdentifier, importedFixes, callback));
        return importedFixes.get();
    }

    protected ExpeditionImportFileHandler getFileHandler(final TrackFileImportDeviceIdentifier trackIdentifier, final AtomicBoolean importedFixes, final BaseDoubleVectorFixImporter.Callback callback) {
        return new ExpeditionImportFileHandler(){

            @Override
            protected void handleExpeditionFile(String fileName, InputStream inputStream, Charset charset) throws IOException, FormatNotSupportedException {
                ExpeditionExtendedDataImporterImpl.this.handleExpeditionFile(fileName, inputStream, charset, trackIdentifier, importedFixes, callback);
            }
        };
    }

    protected void handleExpeditionFile(String fileName, InputStream inputStream, Charset charset, TrackFileImportDeviceIdentifier trackIdentifier, AtomicBoolean importedFixes, BaseDoubleVectorFixImporter.Callback callback) throws IOException, FormatNotSupportedException {
        logger.fine("Start parsing Expedition file");
        AtomicLong lineNr = new AtomicLong();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));
        String headerLine = buffer.readLine();
        lineNr.incrementAndGet();
        logger.fine("Validate and parse header columns");
        Map<String, Integer> colIndices = this.parseHeader(headerLine);
        this.validateHeader(colIndices);
        buffer.lines().forEach(line -> {
            lineNr.incrementAndGet();
            if (!line.trim().isEmpty()) {
                this.parseLine(lineNr.get(), fileName, (String)line, colIndices, (timePoint, lineContentTokens, columnsInFileFromHeader) -> {
                    Double[] trackFixData = new Double[this.trackColumnCount];
                    for (Map.Entry columnFromFile : columnsInFileFromHeader.entrySet()) {
                        Double value;
                        Integer indexInDoubleVectorFix = this.columnNamesInFileAndTheirValueIndexInResultingDoubleVectorFix.get(columnFromFile.getKey());
                        if (indexInDoubleVectorFix == null) continue;
                        trackFixData[indexInDoubleVectorFix.intValue()] = value = (Integer)columnFromFile.getValue() >= lineContentTokens.length ? null : (lineContentTokens[(Integer)columnFromFile.getValue()].trim().isEmpty() ? null : Double.valueOf(Double.parseDouble(lineContentTokens[(Integer)columnFromFile.getValue()])));
                    }
                    importedFixes.set(true);
                    callback.addFixes(Collections.singleton(new DoubleVectorFixImpl(timePoint, trackFixData)), trackIdentifier);
                });
            }
        });
    }

    protected TrackFileImportDeviceIdentifierImpl getTrackIdentifier(String filename, String sourceName) {
        return new TrackFileImportDeviceIdentifierImpl(UUID.randomUUID(), filename, sourceName, MillisecondsTimePoint.now());
    }

    public Map<String, Integer> parseHeader(String headerLine) {
        String[] headerTokens = this.split(headerLine);
        HashMap<String, Integer> colIndicesInFile = new HashMap<String, Integer>();
        int columnInResultingHeader = 0;
        int columnInHeader = 0;
        while (columnInHeader < headerTokens.length) {
            String header = headerTokens[columnInHeader];
            if (header.toLowerCase().equals(ORIGINAL_POSITION_HEADER)) {
                colIndicesInFile.put(COL_NAME_LAT.toLowerCase(), columnInResultingHeader++);
                colIndicesInFile.put(COL_NAME_LON.toLowerCase(), columnInResultingHeader++);
            } else {
                colIndicesInFile.put(header.toLowerCase(), columnInResultingHeader++);
            }
            ++columnInHeader;
        }
        return colIndicesInFile;
    }

    public void validateHeader(Map<String, Integer> colIndicesInFile) throws FormatNotSupportedException {
        boolean dateTimeFormatOk = colIndicesInFile.containsKey(UTC_COLUMN) ? true : (colIndicesInFile.containsKey(DATE_COLUMN_1) || colIndicesInFile.containsKey(DATE_COLUMN_2) ? colIndicesInFile.containsKey(TIME_COLUMN) : colIndicesInFile.containsKey(GPS_TIME_COLUMN));
        if (!dateTimeFormatOk) {
            String msg = "Missing date/time headers; expect either utc or dd/mm/yy with hhmmss or mm/dd/yy with hhmmss or gps time";
            logger.log(Level.SEVERE, "Missing date/time headers; expect either utc or dd/mm/yy with hhmmss or mm/dd/yy with hhmmss or gps time");
            throw new FormatNotSupportedException("Missing date/time headers; expect either utc or dd/mm/yy with hhmmss or mm/dd/yy with hhmmss or gps time");
        }
    }

    public String[] split(String line) {
        return line.split("\\s*,\\s*");
    }

    public void parseLine(long lineNr, String filename, String line, Map<String, Integer> columnsInFileFromHeader, LineParserCallback callback) {
        try {
            String boatToken;
            String[] lineContentTokens = this.split(line);
            Integer boatColumnIndex = columnsInFileFromHeader.get(BOAT_COL);
            if (boatColumnIndex != null && !BOAT_CHECK_PATTERN.matcher(boatToken = lineContentTokens[boatColumnIndex]).matches()) {
                logger.warning("Error, skipping line #" + lineNr + " in file " + filename + ", not a boat id: " + boatToken);
                return;
            }
            TimePoint timePoint = this.getTimePointFromLine(columnsInFileFromHeader, lineContentTokens);
            if (timePoint != null) {
                callback.accept(timePoint, lineContentTokens, columnsInFileFromHeader);
            }
        }
        catch (Exception e) {
            logger.warning("Error parsing line #" + lineNr + " in file " + filename + " with exception: " + e.getMessage());
        }
    }

    public TimePoint getTimePointFromLine(Map<String, Integer> columnsInFileFromHeader, String[] lineContentTokens) throws ParseException {
        TimePoint timePoint;
        String utc;
        Integer gpsTimeColumnIndex = columnsInFileFromHeader.get(GPS_TIME_COLUMN);
        String time_ExcelEpoch = gpsTimeColumnIndex == null ? null : lineContentTokens[gpsTimeColumnIndex];
        Integer utcColumnIndex = columnsInFileFromHeader.get(UTC_COLUMN);
        String string = utc = utcColumnIndex == null ? null : lineContentTokens[utcColumnIndex];
        if (time_ExcelEpoch != null && !time_ExcelEpoch.trim().isEmpty()) {
            timePoint = Double.valueOf(time_ExcelEpoch) < 1.0 && utc != null && !utc.trim().isEmpty() ? ExpeditionExtendedDataImporterImpl.getTimePoint("" + ((double)Double.valueOf(utc.trim()).intValue() + Double.valueOf(time_ExcelEpoch))) : ExpeditionExtendedDataImporterImpl.getTimePoint(time_ExcelEpoch);
        } else if (utc != null && !utc.trim().isEmpty()) {
            timePoint = ExpeditionExtendedDataImporterImpl.getTimePoint(lineContentTokens[utcColumnIndex]);
        } else if (columnsInFileFromHeader.containsKey(DATE_COLUMN_1) && !lineContentTokens[columnsInFileFromHeader.get(DATE_COLUMN_1)].trim().isEmpty() || columnsInFileFromHeader.containsKey(DATE_COLUMN_2) && !lineContentTokens[columnsInFileFromHeader.get(DATE_COLUMN_2)].trim().isEmpty()) {
            String dateFormatPattern;
            String date;
            if (columnsInFileFromHeader.containsKey(DATE_COLUMN_1)) {
                date = lineContentTokens[columnsInFileFromHeader.get(DATE_COLUMN_1)];
                dateFormatPattern = DATE_COLUMN_1_PATTERN;
            } else {
                date = lineContentTokens[columnsInFileFromHeader.get(DATE_COLUMN_2)];
                dateFormatPattern = DATE_COLUMN_2_PATTERN;
            }
            String time = lineContentTokens[columnsInFileFromHeader.get(TIME_COLUMN)];
            SimpleDateFormat df = new SimpleDateFormat(String.valueOf(dateFormatPattern) + "'T'HH:mm:ssX");
            Date timestamp = df.parse(String.valueOf(date) + "T" + time + "+00:00");
            timePoint = new MillisecondsTimePoint(timestamp);
        } else {
            timePoint = null;
        }
        return timePoint;
    }

    public static TimePoint getTimePoint(String time_ExcelEpoch) {
        MillisecondsTimePoint timePoint;
        if (!time_ExcelEpoch.trim().isEmpty()) {
            BigDecimal timeStamp = new BigDecimal(time_ExcelEpoch);
            long millisecondsSinceExcelEpochStart = timeStamp.multiply(MILLISECONDS_PER_DAY).longValue();
            timePoint = new MillisecondsTimePoint(EXCEL_EPOCH_START.getTimeInMillis() + millisecondsSinceExcelEpochStart);
        } else {
            timePoint = null;
        }
        return timePoint;
    }

    @FunctionalInterface
    public static interface LineParserCallback {
        public void accept(TimePoint var1, String[] var2, Map<String, Integer> var3);
    }
}

