/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.common.trackfiles.TrackFilesFormat;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.trackfiles.impl.DataRetriever;
import com.sap.sailing.server.trackfiles.impl.NameReader;
import com.sap.sailing.server.trackfiles.impl.RouteConverter;
import com.sap.sailing.server.trackfiles.impl.TrackReader;
import com.sap.sailing.server.trackfiles.impl.TrackReaderRetriever;
import com.sap.sailing.server.trackfiles.impl.WaypointCreator;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import slash.navigation.base.BaseNavigationFormat;
import slash.navigation.base.BaseRoute;
import slash.navigation.base.MultipleRoutesFormat;
import slash.navigation.base.RouteCharacteristics;
import slash.navigation.gpx.Gpx10Format;
import slash.navigation.gpx.Gpx11Format;
import slash.navigation.gpx.GpxFormat;
import slash.navigation.gpx.GpxPosition;
import slash.navigation.gpx.GpxRoute;
import slash.navigation.kml.Kml20Format;
import slash.navigation.kml.Kml21Format;
import slash.navigation.kml.Kml22Format;
import slash.navigation.kml.Kmz20Format;
import slash.navigation.kml.Kmz21Format;
import slash.navigation.kml.Kmz22Format;
import slash.navigation.mm.MagicMapsIktFormat;
import slash.navigation.ovl.OvlFormat;
import slash.navigation.tcx.Tcx1Format;
import slash.navigation.tcx.Tcx2Format;

public abstract class AbstractDataRetriever
implements DataRetriever {
    public abstract Collection<GpxRoute> getRoutes(TrackFilesFormat var1, TrackedRace var2, boolean var3, boolean var4) throws FormatNotSupportedException, IOException;

    @Override
    public byte[] getData(TrackFilesFormat format, TrackedRace race, boolean dataBeforeAfter, boolean rawFixes) throws FormatNotSupportedException, IOException {
        Collection<GpxRoute> routes = this.getRoutes(format, race, dataBeforeAfter, rawFixes);
        switch (format) {
            case Gpx10: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asGpx10Format();
                    }
                }.convert(routes), new Gpx10Format());
            }
            case Gpx11: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asGpx11Format();
                    }
                }.convert(routes), new Gpx11Format());
            }
            case Kml20: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asKml20Format();
                    }
                }.convert(routes), new Kml20Format());
            }
            case Kml21: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asKml21Format();
                    }
                }.convert(routes), new Kml21Format());
            }
            case Kml22: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asKml22Format();
                    }
                }.convert(routes), new Kml22Format());
            }
            case Kmz20: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asKmz20Format();
                    }
                }.convert(routes), new Kmz20Format());
            }
            case Kmz21: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asKmz21Format();
                    }
                }.convert(routes), new Kmz21Format());
            }
            case Kmz22: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asKmz22Format();
                    }
                }.convert(routes), new Kmz22Format());
            }
            case MagicMapsIkt: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asMagicMapsIktFormat();
                    }
                }.convert(routes), new MagicMapsIktFormat());
            }
            case Ovl: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asOvlFormat();
                    }
                }.convert(routes), new OvlFormat());
            }
            case OziExplorerTrack: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asOvlFormat();
                    }
                }.convert(routes), new OvlFormat());
            }
            case Tcx1: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asTcx1Format();
                    }
                }.convert(routes), new Tcx1Format());
            }
            case Tcx2: {
                return this.getRoutesAsBytes(new RouteConverter(){

                    @Override
                    BaseRoute convert(GpxRoute route) {
                        return route.asTcx2Format();
                    }
                }.convert(routes), new Tcx2Format());
            }
        }
        throw new FormatNotSupportedException(format + " format is not supported");
    }

    private <F extends BaseNavigationFormat<? extends BaseRoute>> byte[] getRoutesAsBytes(List<BaseRoute> routes, F format) throws IOException, FormatNotSupportedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (!(format instanceof MultipleRoutesFormat)) {
            throw new FormatNotSupportedException("Format cannot contain multiple routes per file");
        }
        MultipleRoutesFormat mFormat = (MultipleRoutesFormat)format;
        mFormat.write(routes, (OutputStream)out);
        return out.toByteArray();
    }

    protected <E, F extends Timed, T> Collection<GpxRoute> getRoutes(TrackedRace race, boolean dataBeforeAfter, boolean rawFixes, WaypointCreator<F> creator, Iterable<E> elements, NameReader<E> nameReader, TrackReaderRetriever<E, F> trackRetriever) throws FormatNotSupportedException, IOException {
        ArrayList<GpxRoute> routes = new ArrayList<GpxRoute>();
        TimePoint start = race.getStartOfRace() != null ? race.getStartOfRace() : race.getStartOfTracking();
        TimePoint end = race.getEndOfRace() != null ? race.getEndOfRace() : race.getEndOfTracking();
        for (E element : elements) {
            String name = nameReader.getName(element);
            GpxRoute route = new GpxRoute((GpxFormat)new Gpx11Format(), RouteCharacteristics.Track, name, Collections.emptyList(), new ArrayList());
            TrackReader<E, F> trackReader = trackRetriever.retrieveTrackReader(element);
            trackReader.getLocker().lock();
            try {
                Iterable<F> fixesIter;
                Iterable<F> iterable = fixesIter = rawFixes ? trackReader.getRawTrack(element) : trackReader.getTrack(element);
                if (fixesIter == null) continue;
                int i = 0;
                for (Timed fix : fixesIter) {
                    if (!dataBeforeAfter && fix.getTimePoint().before(start)) continue;
                    if (!dataBeforeAfter && fix.getTimePoint().after(end)) {
                        break;
                    }
                    GpxPosition position = creator.getPosition(fix);
                    if (position == null) continue;
                    route.add(i++, position);
                }
            }
            finally {
                trackReader.getLocker().unlock();
            }
            if (route.getPositions().isEmpty()) continue;
            routes.add(route);
        }
        return routes;
    }
}

