/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.store;

import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.TrainableModel;
import com.sap.sailing.windestimation.model.exception.ModelLoadingException;
import com.sap.sailing.windestimation.model.exception.ModelNotFoundException;
import com.sap.sailing.windestimation.model.exception.ModelPersistenceException;
import com.sap.sailing.windestimation.model.store.AbstractModelStoreImpl;
import com.sap.sailing.windestimation.model.store.ModelDomainType;
import com.sap.sailing.windestimation.model.store.ModelSerializationStrategy;
import com.sap.sailing.windestimation.model.store.PersistableModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class ClassPathReadOnlyModelStoreImpl
extends AbstractModelStoreImpl {
    private final String destinationFolder;
    private final ClassLoader classLoader;
    private final String[] modelFileNames;

    public ClassPathReadOnlyModelStoreImpl(String destinationFolder, ClassLoader classLoader, String[] modelFileNames) {
        this.destinationFolder = destinationFolder;
        this.classLoader = classLoader;
        this.modelFileNames = modelFileNames;
    }

    private List<String> getResourceFiles(String path) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        String[] stringArray = this.modelFileNames;
        int n = this.modelFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            filenames.add(fileName);
            ++n2;
        }
        return filenames;
    }

    private InputStream getResourceAsStream(String resource) {
        InputStream in = this.classLoader.getResourceAsStream(resource);
        return in;
    }

    private String getFilePath(String filename) {
        if (this.destinationFolder.isEmpty()) {
            return filename;
        }
        return String.valueOf(this.destinationFolder) + "/" + filename;
    }

    @Override
    public <InstanceType, T extends ModelContext<InstanceType>, ModelType extends TrainableModel<InstanceType, T>> ModelType loadModel(ModelType newModel) throws ModelPersistenceException {
        ModelSerializationStrategy serializationStrategy = this.checkAndGetModelSerializationStrategy(newModel);
        String fileName = this.getPersistenceKey(newModel);
        String filePath = this.getFilePath(fileName);
        InputStream input = this.getResourceAsStream(filePath);
        if (input != null) {
            TrainableModel trainableModel;
            try {
                TrainableModel loadedModel = (TrainableModel)serializationStrategy.deserializeFromStream(input);
                if (!((ModelContext)newModel.getModelContext()).equals(loadedModel.getModelContext())) {
                    throw new ModelPersistenceException("The configuration of the loaded model is: " + loadedModel.getModelContext() + ". \nExpected: " + newModel.getModelContext());
                }
                trainableModel = loadedModel;
            }
            catch (IOException e) {
                throw new ModelPersistenceException(e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            return (ModelType)trainableModel;
        }
        throw new ModelNotFoundException((ModelContext<?>)newModel.getModelContext());
    }

    @Override
    public void persistModel(PersistableModel<?, ?> trainedModel) throws ModelPersistenceException {
        throw new UnsupportedOperationException();
    }

    public <T extends PersistableModel<?, ?>> void delete(T newModel) throws ModelPersistenceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteAll(ModelDomainType domainType) throws ModelPersistenceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, byte[]> exportAllPersistedModels(ModelDomainType domainType) throws ModelPersistenceException {
        HashMap<String, byte[]> exportedModels = new HashMap<String, byte[]>();
        try {
            for (String fileName : this.getResourceFiles(this.destinationFolder)) {
                byte[] exportedModel;
                if (!this.isPersistenceKeyBelongingToModelDomain(fileName, domainType)) continue;
                String filePath = this.getFilePath(fileName);
                try {
                    Throwable throwable = null;
                    Object var8_11 = null;
                    try (InputStream inputStream = this.getResourceAsStream(filePath);){
                        exportedModel = IOUtils.toByteArray((InputStream)inputStream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new ModelPersistenceException("Could not read model \"" + fileName + "\" from filesystem", e);
                }
                exportedModels.put(fileName, exportedModel);
            }
        }
        catch (IOException e) {
            throw new ModelPersistenceException(e);
        }
        return exportedModels;
    }

    @Override
    public void importPersistedModels(Map<String, byte[]> exportedPersistedModels, ModelDomainType domainType) throws ModelPersistenceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PersistableModel<?, ?>> loadAllPersistedModels(ModelDomainType domainType) {
        ArrayList loadedModels = new ArrayList();
        try {
            for (String fileName : this.getResourceFiles(this.destinationFolder)) {
                if (!this.isPersistenceKeyBelongingToModelDomain(fileName, domainType)) continue;
                String filePath = this.getFilePath(fileName);
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream inputStream = this.getResourceAsStream(filePath);){
                    PersistableModel<?, ?> loadedModel;
                    ModelSerializationStrategy serializationStrategy = this.getModelSerializationStrategyFromPersistenceKey(fileName);
                    if (serializationStrategy == null) {
                        throw new ModelLoadingException("Persistence support could not be determined due to invalid filename pattern: \"" + fileName + "\"");
                    }
                    try {
                        Throwable throwable2 = null;
                        Object var12_17 = null;
                        try (InputStream input = this.getResourceAsStream(filePath);){
                            loadedModel = serializationStrategy.deserializeFromStream(input);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        throw new ModelLoadingException("Could not read model \"" + fileName + "\" from filesystem", e);
                    }
                    loadedModels.add(loadedModel);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            throw new ModelLoadingException(e);
        }
        return loadedModels;
    }
}

