/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.classifier.smile;

import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.classifier.PreprocessingConfig;
import com.sap.sailing.windestimation.model.classifier.smile.AbstractSmileClassificationModel;
import smile.classification.SVM;
import smile.math.kernel.GaussianKernel;
import smile.math.kernel.MercerKernel;

public class SVMClassifier<InstanceType, MC extends ModelContext<InstanceType>>
extends AbstractSmileClassificationModel<InstanceType, MC> {
    private static final long serialVersionUID = -3364152319152090775L;

    public SVMClassifier(MC modelContext) {
        super(new PreprocessingConfig.PreprocessingConfigBuilder().scaling().build(), modelContext);
    }

    protected SVM<double[]> trainInternalModel(double[][] x, int[] y) {
        int featuresCount = x[0].length;
        double gamma = 1.0 / (double)featuresCount;
        double sigma = Math.sqrt(0.5 / gamma);
        SVM svm = new SVM((MercerKernel)new GaussianKernel(sigma), 10.0, ((ModelContext)this.getModelContext()).getNumberOfPossibleTargetValues(), SVM.Multiclass.ONE_VS_ALL);
        svm.learn((Object[])x, y);
        svm.finish();
        svm.trainPlattScaling((Object[])x, y);
        return svm;
    }
}

