/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.classifier;

import java.io.Serializable;

public class PreprocessingConfig
implements Serializable {
    private static final long serialVersionUID = 1468758171182350224L;
    private final boolean pcaComponents;
    private final boolean pcaPercentage;
    private final double pcaValue;
    private final boolean scaling;

    public PreprocessingConfig(boolean pcaComponents, boolean pcaPercentage, double pcaValue, boolean scaling) {
        this.pcaComponents = pcaComponents;
        this.pcaPercentage = pcaPercentage;
        this.pcaValue = pcaValue;
        this.scaling = scaling;
    }

    public boolean isPca() {
        return this.pcaComponents || this.pcaPercentage;
    }

    public boolean isPcaComponents() {
        return this.pcaComponents;
    }

    public int getNumberOfPcaComponents() {
        return (int)this.pcaValue;
    }

    public double getPercentageValue() {
        return this.pcaValue;
    }

    public boolean isPcaPercentage() {
        return this.pcaPercentage;
    }

    public boolean isScaling() {
        return this.scaling;
    }

    public String toString() {
        return "PreprocessingConfig [pcaComponents=" + this.pcaComponents + ", pcaPercentage=" + this.pcaPercentage + ", pcaValue=" + this.pcaValue + ", scaling=" + this.scaling + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pcaComponents ? 1231 : 1237);
        result = 31 * result + (this.pcaPercentage ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.pcaValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.scaling ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreprocessingConfig other = (PreprocessingConfig)obj;
        if (this.pcaComponents != other.pcaComponents) {
            return false;
        }
        if (this.pcaPercentage != other.pcaPercentage) {
            return false;
        }
        if (Double.doubleToLongBits(this.pcaValue) != Double.doubleToLongBits(other.pcaValue)) {
            return false;
        }
        return this.scaling == other.scaling;
    }

    public static class PreprocessingConfigBuilder {
        private boolean pcaComponents;
        private boolean pcaPercentage;
        private double pcaValue;
        private boolean scaling;

        public PreprocessingConfigBuilder pca(int pcaComponents) {
            this.pcaComponents = true;
            this.pcaPercentage = false;
            this.pcaValue = pcaComponents;
            return this;
        }

        public PreprocessingConfigBuilder pca(double pcaPercentageValue) {
            this.pcaPercentage = true;
            this.pcaComponents = false;
            this.pcaValue = pcaPercentageValue;
            return this;
        }

        public PreprocessingConfigBuilder scaling() {
            this.scaling = true;
            return this;
        }

        public PreprocessingConfig build() {
            return new PreprocessingConfig(this.pcaComponents, this.pcaPercentage, this.pcaValue, this.scaling);
        }
    }
}

