/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.integration;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.maneuverdetection.TrackTimeInfo;
import com.sap.sailing.domain.tracking.CompleteManeuverCurve;
import com.sap.sailing.windestimation.aggregator.msthmm.MstGraphNodeTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.msthmm.MstManeuverGraphGenerator;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.integration.CompleteManeuverCurveToManeuverForEstimationConverter;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverClassifiersCache;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class IncrementalMstManeuverGraphGenerator
extends MstManeuverGraphGenerator {
    protected final Map<Competitor, ManeuverDataOfCompetitor> maneuverDataPerCompetitor = new HashMap<Competitor, ManeuverDataOfCompetitor>();
    private final ManeuverClassifiersCache maneuverClassifiersCache;
    private final CompleteManeuverCurveToManeuverForEstimationConverter maneuverConverter;

    public IncrementalMstManeuverGraphGenerator(CompleteManeuverCurveToManeuverForEstimationConverter maneuverConverter, MstGraphNodeTransitionProbabilitiesCalculator transitionProbabilitiesCalculator, ManeuverClassifiersCache maneuverClassifiersCache) {
        super(transitionProbabilitiesCalculator);
        this.maneuverConverter = maneuverConverter;
        this.maneuverClassifiersCache = maneuverClassifiersCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void add(Competitor competitor, CompleteManeuverCurve newManeuver, TrackTimeInfo trackTimeInfo) {
        CompleteManeuverCurve nextManeuver;
        CompleteManeuverCurve previousManeuver;
        CompleteManeuverCurve latestNonTemporaryAcceptedManeuver;
        ManeuverDataOfCompetitor maneuverData = this.maneuverDataPerCompetitor.get(competitor);
        if (maneuverData == null) {
            maneuverData = new ManeuverDataOfCompetitor();
            this.maneuverDataPerCompetitor.put(competitor, maneuverData);
        }
        if ((latestNonTemporaryAcceptedManeuver = maneuverData.getLatestNonTemporaryAcceptedManeuver()) != null && !newManeuver.getTimePoint().after(latestNonTemporaryAcceptedManeuver.getTimePoint())) return;
        CompleteManeuverCurve latestTemporaryAcceptedManeuver = maneuverData.getLatestTemporaryAcceptedManeuver();
        if (latestTemporaryAcceptedManeuver != null && this.isLocationOfManeuversNearlySame(latestTemporaryAcceptedManeuver, newManeuver)) {
            previousManeuver = maneuverData.getPreviousManeuver(latestTemporaryAcceptedManeuver);
            nextManeuver = null;
        } else if (latestTemporaryAcceptedManeuver != null) {
            if (!latestTemporaryAcceptedManeuver.getTimePoint().before(newManeuver.getTimePoint())) return;
            previousManeuver = latestTemporaryAcceptedManeuver;
            nextManeuver = null;
            ManeuverForEstimation temporaryAcceptedManeuverForEstimation = this.maneuverConverter.convertCleanManeuverSpotToManeuverForEstimation(latestTemporaryAcceptedManeuver, maneuverData.getPreviousManeuver(latestTemporaryAcceptedManeuver), newManeuver, competitor, trackTimeInfo);
            if (temporaryAcceptedManeuverForEstimation.isClean()) {
                maneuverData.getNonTemporaryAcceptedManeuverClassificationsToAdd().add(maneuverData.getLatestTemporaryAcceptedManeuverClassification());
                maneuverData.setLatestNonTemporaryAcceptedManeuver(latestTemporaryAcceptedManeuver);
                Iterator iterator = maneuverData.getAllManeuversAfterLatestNonTemporaryAcceptedManeuver().iterator();
                while (iterator.hasNext()) {
                    CompleteManeuverCurve maneuver = (CompleteManeuverCurve)iterator.next();
                    if (maneuver.getTimePoint().after(latestTemporaryAcceptedManeuver.getTimePoint())) continue;
                    iterator.remove();
                }
            }
        } else {
            previousManeuver = maneuverData.getPreviousManeuver(newManeuver);
            nextManeuver = null;
        }
        ManeuverForEstimation newManeuverForEstimation = this.maneuverConverter.convertCleanManeuverSpotToManeuverForEstimation(newManeuver, previousManeuver, nextManeuver, competitor, trackTimeInfo);
        if (newManeuverForEstimation == null || !newManeuverForEstimation.isClean()) {
            maneuverData.setLatestTemporaryAcceptedManeuver(null);
            maneuverData.setLatestTemporaryAcceptedManeuverClassification(null);
        } else {
            maneuverData.setLatestTemporaryAcceptedManeuver(newManeuver);
            ManeuverWithProbabilisticTypeClassification newManeuverClassification = (ManeuverWithProbabilisticTypeClassification)this.maneuverClassifiersCache.classifyInstance(newManeuverForEstimation);
            maneuverData.setLatestTemporaryAcceptedManeuverClassification(newManeuverClassification);
        }
        maneuverData.getAllManeuversAfterLatestNonTemporaryAcceptedManeuver().add(newManeuver);
    }

    private boolean isLocationOfManeuversNearlySame(CompleteManeuverCurve maneuver1, CompleteManeuverCurve maneuver2) {
        return maneuver1.getTimePoint().equals(maneuver2.getTimePoint());
    }

    @Override
    public synchronized MstManeuverGraphGenerator.MstManeuverGraphComponents parseGraph() {
        ArrayList<ManeuverWithProbabilisticTypeClassification> nonTemporaryNodes = new ArrayList<ManeuverWithProbabilisticTypeClassification>();
        ArrayList<ManeuverWithProbabilisticTypeClassification> temporaryNodes = new ArrayList<ManeuverWithProbabilisticTypeClassification>();
        for (ManeuverDataOfCompetitor maneuverData : this.maneuverDataPerCompetitor.values()) {
            nonTemporaryNodes.addAll(maneuverData.getNonTemporaryAcceptedManeuverClassificationsToAdd());
            ManeuverWithProbabilisticTypeClassification temporaryNode = maneuverData.getLatestTemporaryAcceptedManeuverClassification();
            if (temporaryNode != null) {
                temporaryNodes.add(temporaryNode);
            }
            maneuverData.getNonTemporaryAcceptedManeuverClassificationsToAdd().clear();
        }
        Collections.sort(nonTemporaryNodes);
        for (ManeuverWithProbabilisticTypeClassification node : nonTemporaryNodes) {
            this.addNode(node);
        }
        if (temporaryNodes.isEmpty()) {
            return super.parseGraph();
        }
        MstManeuverGraphGenerator clonedMstGenerator = this.clone();
        Collections.sort(temporaryNodes);
        for (ManeuverWithProbabilisticTypeClassification node : temporaryNodes) {
            clonedMstGenerator.addNode(node);
        }
        return clonedMstGenerator.parseGraph();
    }

    public CompleteManeuverCurveToManeuverForEstimationConverter getManeuverConverter() {
        return this.maneuverConverter;
    }

    protected static class ManeuverDataOfCompetitor {
        private CompleteManeuverCurve latestNonTemporaryAcceptedManeuver = null;
        private CompleteManeuverCurve latestTemporaryAcceptedManeuver = null;
        private ManeuverWithProbabilisticTypeClassification latestTemporaryAcceptedManeuverClassification = null;
        private final List<ManeuverWithProbabilisticTypeClassification> nonTemporaryAcceptedManeuverClassificationsToAdd = new ArrayList<ManeuverWithProbabilisticTypeClassification>();
        private final SortedSet<CompleteManeuverCurve> allManeuversAfterLatestNonTemporaryAcceptedManeuver = new TreeSet<CompleteManeuverCurve>(new Comparator<CompleteManeuverCurve>(){

            @Override
            public int compare(CompleteManeuverCurve o1, CompleteManeuverCurve o2) {
                return o1.getTimePoint().compareTo((Object)o2.getTimePoint());
            }
        });

        protected ManeuverDataOfCompetitor() {
        }

        public CompleteManeuverCurve getLatestNonTemporaryAcceptedManeuver() {
            return this.latestNonTemporaryAcceptedManeuver;
        }

        public void setLatestNonTemporaryAcceptedManeuver(CompleteManeuverCurve latestNonTemporaryAcceptedManeuver) {
            this.latestNonTemporaryAcceptedManeuver = latestNonTemporaryAcceptedManeuver;
        }

        public CompleteManeuverCurve getLatestTemporaryAcceptedManeuver() {
            return this.latestTemporaryAcceptedManeuver;
        }

        public void setLatestTemporaryAcceptedManeuver(CompleteManeuverCurve latestTemporaryAcceptedManeuver) {
            this.latestTemporaryAcceptedManeuver = latestTemporaryAcceptedManeuver;
        }

        public ManeuverWithProbabilisticTypeClassification getLatestTemporaryAcceptedManeuverClassification() {
            return this.latestTemporaryAcceptedManeuverClassification;
        }

        public void setLatestTemporaryAcceptedManeuverClassification(ManeuverWithProbabilisticTypeClassification latestTemporaryAcceptedManeuverClassification) {
            this.latestTemporaryAcceptedManeuverClassification = latestTemporaryAcceptedManeuverClassification;
        }

        public List<ManeuverWithProbabilisticTypeClassification> getNonTemporaryAcceptedManeuverClassificationsToAdd() {
            return this.nonTemporaryAcceptedManeuverClassificationsToAdd;
        }

        public SortedSet<CompleteManeuverCurve> getAllManeuversAfterLatestNonTemporaryAcceptedManeuver() {
            return this.allManeuversAfterLatestNonTemporaryAcceptedManeuver;
        }

        public CompleteManeuverCurve getPreviousManeuver(CompleteManeuverCurve maneuver) {
            CompleteManeuverCurve previousManeuver = this.getLatestNonTemporaryAcceptedManeuver();
            for (CompleteManeuverCurve nextManeuver : this.getAllManeuversAfterLatestNonTemporaryAcceptedManeuver()) {
                if (!nextManeuver.getTimePoint().before(maneuver.getTimePoint())) {
                    return previousManeuver;
                }
                previousManeuver = nextManeuver;
            }
            return previousManeuver;
        }
    }
}

