/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.data;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.windestimation.data.ManeuverCategory;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;

public class ManeuverForEstimation
implements Comparable<ManeuverForEstimation> {
    private final TimePoint maneuverTimePoint;
    private final Position maneuverPosition;
    private final Bearing middleCourse;
    private final SpeedWithBearing speedWithBearingBefore;
    private final SpeedWithBearing speedWithBearingAfter;
    private final double courseChangeInDegrees;
    private final double courseChangeWithinMainCurveInDegrees;
    private final double maxTurningRateInDegreesPerSecond;
    private final Double deviationFromOptimalTackAngleInDegrees;
    private final Double deviationFromOptimalJibeAngleInDegrees;
    private final double speedLossRatio;
    private final double speedGainRatio;
    private final double lowestSpeedVsExitingSpeedRatio;
    private final boolean clean;
    private final ManeuverCategory maneuverCategory;
    private final double scaledSpeedBefore;
    private final double scaledSpeedAfter;
    private final boolean markPassing;
    private final BoatClass boatClass;
    private final boolean markPassingDataAvailable;

    public ManeuverForEstimation(TimePoint maneuverTimePoint, Position maneuverPosition, Bearing middleCourse, SpeedWithBearing speedWithBearingBefore, SpeedWithBearing speedWithBearingAfter, double courseChangeInDegrees, double courseChangeWithinMainCurveInDegrees, double maxTurningRateInDegreesPerSecond, Double deviationFromOptimalTackAngleInDegrees, Double deviationFromOptimalJibeAngleInDegrees, double speedLossRatio, double speedGainRatio, double lowestSpeedVsExitingSpeedRatio, boolean clean, ManeuverCategory maneuverCategory, double scaledSpeedBefore, double scaledSpeedAfter, boolean markPassing, BoatClass boatClass, boolean markPassingDataAvailable) {
        this.maneuverTimePoint = maneuverTimePoint;
        this.maneuverPosition = maneuverPosition;
        this.middleCourse = middleCourse;
        this.speedWithBearingBefore = speedWithBearingBefore;
        this.speedWithBearingAfter = speedWithBearingAfter;
        this.courseChangeInDegrees = courseChangeInDegrees;
        this.courseChangeWithinMainCurveInDegrees = courseChangeWithinMainCurveInDegrees;
        this.maxTurningRateInDegreesPerSecond = maxTurningRateInDegreesPerSecond;
        this.deviationFromOptimalTackAngleInDegrees = deviationFromOptimalTackAngleInDegrees;
        this.deviationFromOptimalJibeAngleInDegrees = deviationFromOptimalJibeAngleInDegrees;
        this.speedLossRatio = speedLossRatio;
        this.speedGainRatio = speedGainRatio;
        this.lowestSpeedVsExitingSpeedRatio = lowestSpeedVsExitingSpeedRatio;
        this.clean = clean;
        this.maneuverCategory = maneuverCategory;
        this.scaledSpeedBefore = scaledSpeedBefore;
        this.scaledSpeedAfter = scaledSpeedAfter;
        this.markPassing = markPassing;
        this.boatClass = boatClass;
        this.markPassingDataAvailable = markPassingDataAvailable;
    }

    public TimePoint getManeuverTimePoint() {
        return this.maneuverTimePoint;
    }

    public Position getManeuverPosition() {
        return this.maneuverPosition;
    }

    public Bearing getMiddleCourse() {
        return this.middleCourse;
    }

    public SpeedWithBearing getSpeedWithBearingBefore() {
        return this.speedWithBearingBefore;
    }

    public SpeedWithBearing getSpeedWithBearingAfter() {
        return this.speedWithBearingAfter;
    }

    public double getCourseChangeInDegrees() {
        return this.courseChangeInDegrees;
    }

    public double getCourseChangeWithinMainCurveInDegrees() {
        return this.courseChangeWithinMainCurveInDegrees;
    }

    public double getMaxTurningRateInDegreesPerSecond() {
        return this.maxTurningRateInDegreesPerSecond;
    }

    public Double getDeviationFromOptimalTackAngleInDegrees() {
        return this.deviationFromOptimalTackAngleInDegrees;
    }

    public Double getDeviationFromOptimalJibeAngleInDegrees() {
        return this.deviationFromOptimalJibeAngleInDegrees;
    }

    public double getSpeedLossRatio() {
        return this.speedLossRatio;
    }

    public double getSpeedGainRatio() {
        return this.speedGainRatio;
    }

    public double getLowestSpeedVsExitingSpeedRatio() {
        return this.lowestSpeedVsExitingSpeedRatio;
    }

    public boolean isClean() {
        return this.clean;
    }

    public ManeuverCategory getManeuverCategory() {
        return this.maneuverCategory;
    }

    public double getScaledSpeedBefore() {
        return this.scaledSpeedBefore;
    }

    public double getScaledSpeedAfter() {
        return this.scaledSpeedAfter;
    }

    public boolean isMarkPassing() {
        return this.markPassing;
    }

    public BoatClass getBoatClass() {
        return this.boatClass;
    }

    public boolean isMarkPassingDataAvailable() {
        return this.markPassingDataAvailable;
    }

    @Override
    public int compareTo(ManeuverForEstimation o) {
        return this.maneuverTimePoint.compareTo((Object)o.maneuverTimePoint);
    }

    public String toString() {
        return "Maneuver at " + this.maneuverTimePoint + ", " + this.maneuverPosition + ", middleCourse=" + this.middleCourse + ", courseChangeInDegrees=" + this.courseChangeInDegrees;
    }
}

