/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.declination.impl;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.impl.BGSImporter;
import com.sap.sailing.declination.impl.ColoradoImporter;
import com.sap.sailing.declination.impl.DeclinationImporter;
import com.sap.sailing.declination.impl.DeclinationRecordImpl;
import com.sap.sailing.declination.impl.DeclinationServiceImplWithStore;
import com.sap.sailing.declination.impl.NOAAImporter;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.quadtree.QuadTree;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DeclinationStore {
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private final DeclinationImporter importer;

    public DeclinationStore(DeclinationImporter importer) {
        this.importer = importer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTree<Declination> getStoredDeclinations(int year) throws IOException, ParseException {
        QuadTree result = null;
        InputStream is = this.getInputStreamForYear(year);
        if (is != null) {
            boolean exceptionOccurred;
            Declination record;
            result = new QuadTree();
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            try {
                record = this.readExternal(in);
                exceptionOccurred = false;
            }
            catch (NumberFormatException e) {
                exceptionOccurred = true;
                record = null;
            }
            while (exceptionOccurred || record != null) {
                if (record != null) {
                    QuadTree e = result;
                    synchronized (e) {
                        result.put(record.getPosition(), (Object)record);
                    }
                }
                try {
                    record = this.readExternal(in);
                    exceptionOccurred = false;
                }
                catch (NumberFormatException e) {
                    exceptionOccurred = true;
                    record = null;
                }
            }
        }
        return result;
    }

    private String getResourceForYear(int year) {
        String filename = this.getFilenameForYear(year);
        return "resources/" + filename;
    }

    private String getFilenameForYear(int year) {
        String filename = "declination-" + year;
        return filename;
    }

    private InputStream getInputStreamForYear(int year) {
        return this.getClass().getResourceAsStream("/" + this.getFilenameForYear(year));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(Declination record, Writer out) throws IOException {
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            out.write(dateFormatter.format(record.getTimePoint().asDate()));
        }
        out.write("|" + record.getPosition().getLatDeg());
        out.write("|" + record.getPosition().getLngDeg());
        out.write("|" + record.getBearing().getDegrees());
        out.write("|" + record.getAnnualChange().getDegrees());
        out.write("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Declination readExternal(BufferedReader in) throws IOException, ParseException {
        Declination result;
        block5: {
            result = null;
            try {
                MillisecondsTimePoint timePoint;
                String line = in.readLine();
                if (line == null || line.length() <= 0) break block5;
                String[] fields = line.split("\\|");
                SimpleDateFormat simpleDateFormat = dateFormatter;
                synchronized (simpleDateFormat) {
                    timePoint = new MillisecondsTimePoint(dateFormatter.parse(fields[0]).getTime());
                }
                double lat = Double.valueOf(fields[1]);
                double lng = Double.valueOf(fields[2]);
                DegreePosition position = new DegreePosition(lat, lng);
                DegreeBearingImpl bearing = new DegreeBearingImpl(Double.valueOf(fields[3]).doubleValue());
                DegreeBearingImpl annualChange = new DegreeBearingImpl(Double.valueOf(fields[4]).doubleValue());
                return new DeclinationRecordImpl((Position)position, (TimePoint)timePoint, (Bearing)bearing, (Bearing)annualChange);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return result;
    }

    private void fetchAndAppendDeclination(TimePoint timePoint, Position position, DeclinationImporter importer, Writer out) throws IOException {
        Declination declination = null;
        int i = 0;
        while (i < 3) {
            try {
                declination = importer.importRecord(position, timePoint);
                break;
            }
            catch (IOException | ParserConfigurationException | SAXException ioe) {
                ioe.printStackTrace();
                if (i < 2) {
                    System.out.println("re-trying");
                }
                ++i;
            }
        }
        if (declination != null) {
            this.writeExternal(declination, out);
            out.flush();
        }
    }

    private void run(String[] args) throws FileNotFoundException, IOException, ClassNotFoundException, ParseException {
        if (args.length == 0) {
            this.usage();
        } else {
            int fromYear = Integer.valueOf(args[0]);
            int toYear = Integer.valueOf(args[1]);
            if (toYear < fromYear) {
                this.usage();
            } else {
                double grid = Double.valueOf(args[2]);
                int year = fromYear;
                while (year <= toYear) {
                    File fileForYear;
                    QuadTree storedDeclinations = this.getStoredDeclinations(year);
                    if (storedDeclinations == null) {
                        storedDeclinations = new QuadTree();
                    }
                    FileWriter out = (fileForYear = new File(this.getResourceForYear(year))).exists() ? new FileWriter(this.getResourceForYear(year), true) : new FileWriter(this.getResourceForYear(year));
                    int month = 6;
                    GregorianCalendar cal = new GregorianCalendar(year, month, 1);
                    MillisecondsTimePoint timePoint = new MillisecondsTimePoint(cal.getTimeInMillis());
                    double lat = 0.0;
                    while (lat < 90.0) {
                        this.fetchAndAppendDeclinationForLatitude(grid, this.importer, year, (QuadTree<Declination>)storedDeclinations, out, month, (TimePoint)timePoint, lat);
                        lat += grid;
                    }
                    lat = -grid;
                    while (lat > -90.0) {
                        this.fetchAndAppendDeclinationForLatitude(grid, this.importer, year, (QuadTree<Declination>)storedDeclinations, out, month, (TimePoint)timePoint, lat);
                        lat -= grid;
                    }
                    ((Writer)out).close();
                    ++year;
                }
            }
        }
    }

    private void fetchAndAppendDeclinationForLatitude(double grid, DeclinationImporter importer, int year, QuadTree<Declination> storedDeclinations, Writer out, int month, TimePoint timePoint, double lat) throws IOException {
        System.out.println("Date: " + year + "/" + (month + 1) + ", Latitude: " + lat);
        double lng = 0.0;
        while (lng < 180.0) {
            this.fetchAndAppendDeclination(importer, storedDeclinations, out, timePoint, lat, lng);
            lng += grid;
        }
        lng = -grid;
        while (lng > -180.0) {
            this.fetchAndAppendDeclination(importer, storedDeclinations, out, timePoint, lat, lng);
            lng -= grid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAndAppendDeclination(DeclinationImporter importer, QuadTree<Declination> storedDeclinations, Writer out, TimePoint timePoint, double lat, double lng) throws IOException {
        Declination existingDeclinationRecord;
        DegreePosition point = new DegreePosition(lat, lng);
        QuadTree<Declination> quadTree = storedDeclinations;
        synchronized (quadTree) {
            existingDeclinationRecord = (Declination)storedDeclinations.get((Position)point);
        }
        if (existingDeclinationRecord == null || DeclinationServiceImplWithStore.timeAndSpaceDistance(existingDeclinationRecord.getPosition().getDistance((Position)point), timePoint, existingDeclinationRecord.getTimePoint()) > 0.1) {
            this.fetchAndAppendDeclination(timePoint, (Position)point, importer, out);
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, ParseException {
        DeclinationStore store = new DeclinationStore(args.length > 3 && args[3].equals("c") ? new ColoradoImporter() : (args.length > 3 && args[3].equals("b") ? new BGSImporter() : new NOAAImporter()));
        store.run(args);
    }

    private void usage() {
        System.out.println("java " + this.getClass().getName() + " <fromYear> <toYear> <gridSizeInDegrees> [c|b]");
        System.out.println("The optional trailing c causes the ColoradoImporter, b the BGSImporter to be used instead of the default NOAAImporter.");
    }
}

