/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.sailwave.html.resultimport.impl;

import com.sap.sailing.resultimport.CompetitorEntry;
import com.sap.sailing.resultimport.CompetitorRow;
import com.sap.sailing.resultimport.RegattaResults;
import com.sap.sailing.resultimport.impl.CompetitorRowImpl;
import com.sap.sailing.resultimport.impl.DefaultCompetitorEntryImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class SailwaveHtmlParser {
    static final String CLASS_METADATA = "class";
    private static final Logger logger = Logger.getLogger(SailwaveHtmlParser.class.getName());

    public List<String> getRowContents(BufferedReader br) throws IOException {
        Pattern tr = Pattern.compile("<(tr|TR)([^<>]*)>");
        Pattern slashTr = Pattern.compile("</(tr|TR)([^<>]*)>");
        boolean inTr = false;
        StringBuilder trContents = new StringBuilder();
        ArrayList<String> tableRows = new ArrayList<String>();
        String readLine = br.readLine();
        int start = 0;
        int end = 0;
        while (readLine != null && !readLine.contains("</tbody>")) {
            if (!inTr) {
                Matcher trMatcher = tr.matcher(readLine);
                boolean foundTr = trMatcher.find(end);
                if (foundTr) {
                    start = trMatcher.end(0);
                    inTr = true;
                    continue;
                }
                readLine = br.readLine();
                end = 0;
                continue;
            }
            Matcher slashTrMatcher = slashTr.matcher(readLine);
            boolean foundSlashTr = slashTrMatcher.find(start);
            if (foundSlashTr) {
                end = slashTrMatcher.start();
                inTr = false;
            } else {
                end = readLine.length();
            }
            trContents.append(readLine.substring(start, end));
            if (!foundSlashTr) {
                trContents.append('\n');
                readLine = br.readLine();
                start = 0;
                continue;
            }
            tableRows.add(trContents.toString());
            trContents.delete(0, trContents.length());
        }
        return tableRows;
    }

    public List<String> getTagContents(String s, String tag) {
        Pattern tagPattern = Pattern.compile("<(" + tag.toLowerCase() + "|" + tag.toUpperCase() + ")([^<>]*)>");
        Pattern slashTag = Pattern.compile("</(" + tag.toLowerCase() + "|" + tag.toUpperCase() + ")([^<>]*)>");
        boolean inTag = false;
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int end = 0;
        boolean finished = false;
        while (!finished) {
            if (!inTag) {
                Matcher tagMatcher = tagPattern.matcher(s);
                boolean foundTag = tagMatcher.find(end);
                if (foundTag) {
                    start = tagMatcher.end(0);
                    inTag = true;
                    continue;
                }
                finished = true;
                continue;
            }
            Matcher slashTagMatcher = slashTag.matcher(s);
            boolean foundSlashTag = slashTagMatcher.find(start);
            if (foundSlashTag) {
                end = slashTagMatcher.start();
                inTag = false;
                result.add(StringEscapeUtils.unescapeHtml((String)s.substring(start, end).trim()));
                continue;
            }
            result.add(StringEscapeUtils.unescapeHtml((String)s.substring(start).trim()));
            finished = true;
            logger.warning("unclosed " + tag + " tag in string \"" + s + "\"");
        }
        return result;
    }

    public RegattaResults getRegattaResults(InputStream is) throws IOException {
        try {
            HashMap<String, Integer> classesCounts = new HashMap<String, Integer>();
            final ArrayList<CompetitorRow> result = new ArrayList<CompetitorRow>();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            final Map<String, String> metadata = this.readMetadataBeforeTable(br);
            LinkedHashMap<String, String> columnNamesAndStyles = this.readTableHeader(br);
            this.findTableBody(br);
            List<String> rowContents = this.getRowContents(br);
            for (String row : rowContents) {
                List<String> tdContent = this.getTagContents(row, "td");
                result.add(this.createCompetitorRow(tdContent, columnNamesAndStyles, classesCounts));
            }
            this.addMostLikelyClassToMetadata(classesCounts, metadata);
            RegattaResults regattaResults = new RegattaResults(){

                public Map<String, String> getMetadata() {
                    return metadata;
                }

                public List<CompetitorRow> getCompetitorResults() {
                    return result;
                }
            };
            return regattaResults;
        }
        finally {
            is.close();
        }
    }

    private void addMostLikelyClassToMetadata(Map<String, Integer> classesCounts, Map<String, String> metadata) {
        if (!classesCounts.isEmpty()) {
            metadata.put(CLASS_METADATA, (String)((Map.Entry)classesCounts.entrySet().stream().sorted((e1, e2) -> Integer.compare((Integer)e2.getValue(), (Integer)e1.getValue())).findFirst().get()).getKey());
        }
    }

    private void findTableBody(BufferedReader br) throws IOException {
        String line;
        while ((line = br.readLine()) != null && !line.contains("<tbody>")) {
        }
    }

    private LinkedHashMap<String, String> readTableHeader(BufferedReader br) throws IOException {
        String line;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        ArrayList<String> classes = new ArrayList<String>();
        Pattern colClassPattern = Pattern.compile("<col class=\"([^\"]*)\" */?>");
        Pattern colTitlePattern = Pattern.compile("<th>([^<]*)</th>");
        while ((line = br.readLine()) != null && !line.contains("<colgroup")) {
        }
        while (line != null && !line.contains("</colgroup")) {
            Matcher colMatcher = colClassPattern.matcher(line);
            if (colMatcher.matches()) {
                classes.add(colMatcher.group(1));
            }
            line = br.readLine();
        }
        while ((line = br.readLine()) != null && !line.contains("<tr class=\"titlerow\">")) {
        }
        Iterator classIter = classes.iterator();
        while (line != null && !line.contains("</tr")) {
            Matcher colTitleMatcher = colTitlePattern.matcher(line);
            if (colTitleMatcher.matches()) {
                result.put(colTitleMatcher.group(1), (String)classIter.next());
            }
            line = br.readLine();
        }
        return result;
    }

    private Map<String, String> readMetadataBeforeTable(BufferedReader br) throws IOException {
        String line;
        Pattern h3MetadataElementPattern = Pattern.compile("<h3 class=\"([^\"]*)\"[^>]*>([^<]*)</h3>");
        Pattern divMetadataElementPattern = Pattern.compile("<div class=\"([^\"]*)\"[^>]*>([^<]*)</div>");
        HashMap<String, String> result = new HashMap<String, String>();
        while ((line = br.readLine()) != null && !line.contains("<h3")) {
        }
        while (line != null && !line.contains("<table")) {
            Matcher divMatcher;
            Matcher h3Matcher = h3MetadataElementPattern.matcher(line);
            if (h3Matcher.matches()) {
                result.put(h3Matcher.group(1), h3Matcher.group(2));
            }
            if ((divMatcher = divMetadataElementPattern.matcher(line)).matches()) {
                result.put(divMatcher.group(1), divMatcher.group(2));
            }
            line = br.readLine();
        }
        return result;
    }

    private CompetitorRow createCompetitorRow(List<String> trContent, LinkedHashMap<String, String> columnNamesAndStyles, Map<String, Integer> classesCounts) throws UnsupportedEncodingException {
        Pattern rankPattern = Pattern.compile("([0-9]+)[A-Za-z]*");
        Pattern nationalityPattern = Pattern.compile("^(<img .*\\btitle=\")?([A-Za-z][A-Za-z][A-Za-z])(\".*>)?$");
        Iterator<String> columnValueIterator = trContent.iterator();
        String nationality = null;
        String sailNumber = null;
        Integer totalRank = null;
        List<String> names = null;
        ArrayList<CompetitorEntry> rankAndMaxPointsReasonAndPointsAndDiscarded = new ArrayList<CompetitorEntry>();
        Double scoreAfterDiscarding = null;
        Double totalPointsBeforeDiscarding = null;
        for (Map.Entry<String, String> columnNameAndStyle : columnNamesAndStyles.entrySet()) {
            String columnValue = columnValueIterator.next();
            switch (columnNameAndStyle.getValue()) {
                case "rank": {
                    Matcher rankMatcher = rankPattern.matcher(columnValue);
                    if (!rankMatcher.matches()) break;
                    totalRank = Integer.parseInt(rankMatcher.group(1));
                    break;
                }
                case "class": {
                    if (classesCounts.containsKey(columnValue)) {
                        classesCounts.put(columnValue, classesCounts.get(columnValue) + 1);
                        break;
                    }
                    classesCounts.put(columnValue, 1);
                    break;
                }
                case "nat": {
                    Matcher natMatcher = nationalityPattern.matcher(columnValue);
                    if (natMatcher.matches()) {
                        nationality = natMatcher.group(2);
                        break;
                    }
                    nationality = columnValue;
                    break;
                }
                case "sailno": {
                    sailNumber = columnValue;
                    break;
                }
                case "helmname": {
                    names = this.getNames(columnValue);
                    break;
                }
                case "race": {
                    CompetitorEntry rankAndMaxPointsReasonAndPointsAndDiscardedForOnceRace = this.getRankAndMaxPointsReasonAndPointsAndDiscardedForOnceRace(columnValue.trim());
                    rankAndMaxPointsReasonAndPointsAndDiscarded.add(rankAndMaxPointsReasonAndPointsAndDiscardedForOnceRace);
                    break;
                }
                case "total": {
                    totalPointsBeforeDiscarding = Double.parseDouble(columnValue);
                    break;
                }
                case "nett": {
                    scoreAfterDiscarding = Double.parseDouble(columnValue);
                }
            }
        }
        return new CompetitorRowImpl(totalRank, String.valueOf(nationality) + " " + sailNumber, names, scoreAfterDiscarding, totalPointsBeforeDiscarding, rankAndMaxPointsReasonAndPointsAndDiscarded);
    }

    private CompetitorEntry getRankAndMaxPointsReasonAndPointsAndDiscardedForOnceRace(String cell) {
        DefaultCompetitorEntryImpl result;
        Pattern oneRaceScorePattern = Pattern.compile("^\\(?([0-9]+\\.[0-9]+)( ([A-Z][A-Z][A-Z]))?.*$");
        boolean isDiscarded = cell.trim().startsWith("(") && cell.trim().endsWith(")");
        Matcher matcher = oneRaceScorePattern.matcher(cell);
        if (matcher.matches()) {
            String maxPointsReason = matcher.group(3);
            Double points = Double.parseDouble(matcher.group(1));
            result = new DefaultCompetitorEntryImpl(null, maxPointsReason, points, isDiscarded);
        } else {
            result = null;
        }
        return result;
    }

    private List<String> getNames(String cell) {
        return Arrays.asList(cell.split(", *"));
    }
}

