/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.resultimport.impl;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.resultimport.ResultUrlRegistry;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ResultUrlRegistryImpl
implements ResultUrlRegistry {
    private final Map<String, Set<URL>> resultUrls;
    private final MongoObjectFactory mongoObjectFactory;

    public ResultUrlRegistryImpl(MongoObjectFactory mongoObjectFactory, DomainObjectFactory domainObjectFactory) {
        this.mongoObjectFactory = mongoObjectFactory;
        this.resultUrls = domainObjectFactory.loadResultUrls();
    }

    @Override
    public void registerResultUrl(String resultProviderName, URL url) {
        Set<URL> urlSet = this.resultUrls.get(resultProviderName);
        if (urlSet == null) {
            urlSet = new HashSet<URL>();
            this.resultUrls.put(resultProviderName, urlSet);
        }
        urlSet.add(url);
        this.mongoObjectFactory.storeResultUrl(resultProviderName, url);
    }

    @Override
    public void unregisterResultUrl(String resultProviderName, URL url) {
        Set<URL> urlSet = this.resultUrls.get(resultProviderName);
        if (urlSet != null) {
            urlSet.remove(url);
            this.mongoObjectFactory.removeResultUrl(resultProviderName, url);
        }
    }

    @Override
    public Iterable<URL> getReadableResultUrls(String resultProviderName) {
        Subject subject = SecurityUtils.getSubject();
        Iterable<URL> result = this.getAllResultUrls(resultProviderName);
        Iterator<URL> urlIterator = result.iterator();
        while (urlIterator.hasNext()) {
            URL url = urlIterator.next();
            if (subject.isPermitted(SecuredDomainType.RESULT_IMPORT_URL.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, new TypeRelativeObjectIdentifier(new String[]{resultProviderName, url.toString()})))) continue;
            urlIterator.remove();
        }
        return result;
    }

    @Override
    public Iterable<URL> getAllResultUrls(String resultProviderName) {
        Collection<URL> result = this.resultUrls.containsKey(resultProviderName) ? new ArrayList(this.resultUrls.get(resultProviderName)) : Collections.emptySet();
        return result;
    }

    @Override
    public Iterable<String> getResultProviderNames() {
        return this.resultUrls.keySet();
    }
}

