/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.hanaexport.jaxrs.api;

import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.hanaexport.jaxrs.api.AbstractPreparedInsertStatement;
import com.sap.sse.common.TimePoint;
import java.sql.Connection;
import java.sql.SQLException;

public class InsertLegStatement
extends AbstractPreparedInsertStatement<TrackedLegAndNow> {
    protected InsertLegStatement(Connection connection) throws SQLException {
        super(connection.prepareStatement("INSERT INTO SAILING.\"Leg\" (\"race\", \"regatta\", \"number\", \"type\") VALUES (?, ?, ?, ?);"));
    }

    @Override
    public void parameterizeStatement(TrackedLegAndNow trackedLegAndNow) throws SQLException {
        this.getPreparedStatement().setString(1, trackedLegAndNow.getTrackedLeg().getTrackedRace().getRace().getName());
        this.getPreparedStatement().setString(2, trackedLegAndNow.getTrackedLeg().getTrackedRace().getTrackedRegatta().getRegatta().getName());
        this.getPreparedStatement().setInt(3, trackedLegAndNow.getTrackedLeg().getLeg().getZeroBasedIndexOfStartWaypoint());
        try {
            LegType legType = trackedLegAndNow.getTrackedLeg().getLegType(trackedLegAndNow.getNow());
            this.getPreparedStatement().setString(4, legType.name());
        }
        catch (NoWindException nwe) {
            this.getPreparedStatement().setString(4, null);
        }
    }

    static class TrackedLegAndNow {
        private final TimePoint now;
        private final TrackedLeg trackedLeg;

        public TrackedLegAndNow(TimePoint now, TrackedLeg trackedLeg) {
            this.now = now;
            this.trackedLeg = trackedLeg;
        }

        public TimePoint getNow() {
            return this.now;
        }

        public TrackedLeg getTrackedLeg() {
            return this.trackedLeg;
        }
    }
}

