/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.functions;

import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.functions.ParameterProvider;
import com.sap.sse.datamining.impl.functions.AbstractFunction;
import com.sap.sse.datamining.impl.functions.MethodWrappingFunction;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class ConcatenatingCompoundFunction<ReturnType>
extends AbstractFunction<ReturnType> {
    private static final String SIMPLE_NAME_CHAIN_CONNECTOR = ".";
    private static final String LOCALIZED_NAME_CHAIN_CONNECTOR = " ";
    private final List<Function<?>> functions;
    private final String simpleName;
    private final int ordinal;

    public ConcatenatingCompoundFunction(List<Function<?>> functions, Class<ReturnType> returnType) throws IllegalArgumentException {
        super(ConcatenatingCompoundFunction.isLastFunctionADimension(functions));
        this.checkThatReturnTypesMatch(functions, returnType);
        this.functions = new ArrayList(functions);
        this.simpleName = this.buildSimpleName();
        this.ordinal = this.calculateOrdinal();
    }

    private String buildSimpleName() {
        Iterator<Function<?>> functionsIterator = this.functions.iterator();
        StringBuilder builder = new StringBuilder(functionsIterator.next().getSimpleName());
        while (functionsIterator.hasNext()) {
            Function<?> function = functionsIterator.next();
            builder.append(SIMPLE_NAME_CHAIN_CONNECTOR + function.getSimpleName());
        }
        return builder.toString();
    }

    private int calculateOrdinal() {
        int ordinal = Integer.MAX_VALUE;
        for (Function<?> function : this.functions) {
            int functionOrdinal = function.getOrdinal();
            if (functionOrdinal >= ordinal) continue;
            ordinal = functionOrdinal;
        }
        return ordinal;
    }

    private static boolean isLastFunctionADimension(List<Function<?>> functions) {
        return functions.get(functions.size() - 1).isDimension();
    }

    private void checkThatReturnTypesMatch(List<Function<?>> functions, Class<ReturnType> returnType) {
        Class<?> lastFunctionReturnType = functions.get(functions.size() - 1).getReturnType();
        if (!lastFunctionReturnType.equals(returnType)) {
            throw new IllegalArgumentException("The method return type " + lastFunctionReturnType.getName() + " and expected return type " + returnType.getName() + " don't match");
        }
    }

    @Override
    public Class<?> getDeclaringType() {
        return this.getFirstFunction().getDeclaringType();
    }

    @Override
    public Iterable<Class<?>> getParameters() {
        return this.getFirstFunction().getParameters();
    }

    @Override
    public boolean needsLocalizationParameters() {
        for (Function<?> function : this.getFunctions()) {
            if (!function.needsLocalizationParameters()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<ReturnType> getReturnType() {
        return this.getLastFunction().getReturnType();
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getLocalizedName(Locale locale, ResourceBundleStringMessages stringMessages) {
        if (!this.isLocalizable()) {
            return this.getSimpleName();
        }
        return this.buildLocalizedNameChain(locale, stringMessages);
    }

    @Override
    public boolean isLocalizable() {
        for (Function<?> function : this.functions) {
            if (!function.isLocalizable()) continue;
            return true;
        }
        return false;
    }

    private String buildLocalizedNameChain(Locale locale, ResourceBundleStringMessages stringMessages) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Function<?> function : this.functions) {
            if (!function.isLocalizable()) continue;
            if (!first) {
                builder.append(LOCALIZED_NAME_CHAIN_CONNECTOR);
            }
            builder.append(function.getLocalizedName(locale, stringMessages));
            first = false;
        }
        return builder.toString();
    }

    @Override
    public ReturnType tryToInvoke(Object instance) {
        return this.tryToInvoke(instance, ParameterProvider.NULL);
    }

    @Override
    public ReturnType tryToInvoke(Object instance, ParameterProvider parameterProvider) {
        Iterator<Function<?>> functionsIterator = this.functions.iterator();
        Object result = functionsIterator.next().tryToInvoke(instance, parameterProvider);
        while (functionsIterator.hasNext()) {
            Function<?> function = functionsIterator.next();
            result = function.tryToInvoke(result, parameterProvider);
            if (result != null) continue;
            return null;
        }
        Object typedResult = result;
        return (ReturnType)typedResult;
    }

    @Override
    public int getResultDecimals() {
        return this.getLastFunction().getResultDecimals();
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public List<Function<?>> getFunctions() {
        return this.functions;
    }

    public List<MethodWrappingFunction<?>> getSimpleFunctions() {
        ArrayList simpleFunctions = new ArrayList();
        for (Function<?> function : this.functions) {
            if (function.getClass().equals(MethodWrappingFunction.class)) {
                simpleFunctions.add((MethodWrappingFunction)function);
                continue;
            }
            if (function.getClass().equals(ConcatenatingCompoundFunction.class)) {
                simpleFunctions.addAll(((ConcatenatingCompoundFunction)function).getSimpleFunctions());
                continue;
            }
            throw new IllegalArgumentException("Can't simplify functions of type " + function.getClass().getSimpleName());
        }
        return simpleFunctions;
    }

    private Function<?> getFirstFunction() {
        return this.functions.get(0);
    }

    private Function<?> getLastFunction() {
        return this.functions.get(this.functions.size() - 1);
    }

    public String toString() {
        return String.valueOf(this.getDeclaringType().getSimpleName()) + SIMPLE_NAME_CHAIN_CONNECTOR + this.getSimpleName() + " : " + this.getReturnType().getSimpleName();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.functions == null ? 0 : this.getSimpleFunctions().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConcatenatingCompoundFunction other = (ConcatenatingCompoundFunction)obj;
        return !(this.functions == null ? other.functions != null : !this.getSimpleFunctions().equals(other.getSimpleFunctions()));
    }
}

