/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.management;

import com.sap.sse.datamining.Query;
import com.sap.sse.datamining.components.management.DataMiningQueryManager;
import com.sap.sse.datamining.data.QueryResult;
import com.sap.sse.datamining.shared.DataMiningSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class NullDataMiningQueryManager
implements DataMiningQueryManager {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Set<Query<?>> queries = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public <ResultType> QueryResult<ResultType> runNewAndAbortPrevious(DataMiningSession session, Query<ResultType> query) {
        this.logger.info("This query manager doesn't manage anything. Just running the query " + query);
        this.queries.add(query);
        QueryResult<ResultType> result = query.run();
        this.queries.remove(query);
        return result;
    }

    @Override
    public void abortRandomQuery() {
        Random generator = new Random();
        ArrayList queries = new ArrayList(this.queries);
        Query query = (Query)queries.get(generator.nextInt(queries.size()));
        this.abortQuery(query);
    }

    @Override
    public void abortAllQueries() {
        HashSet queries = new HashSet(this.queries);
        this.queries.clear();
        queries.forEach(query -> this.abortQuery((Query<?>)query));
    }

    private void abortQuery(Query<?> query) {
        this.logger.info("Aborting query " + query);
        query.abort();
    }

    @Override
    public int getNumberOfRunningQueries() {
        return this.queries.size();
    }
}

