/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.management;

import com.sap.sse.datamining.DataSourceProvider;
import com.sap.sse.datamining.components.management.DataSourceProviderRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DataSourceProviderManager
implements DataSourceProviderRegistry {
    private static final Logger logger = Logger.getLogger(DataSourceProviderManager.class.getName());
    private final Map<Class<?>, DataSourceProvider<?>> sourceProvidersMappedBySourceType = new HashMap();

    @Override
    public <DataSourceType> DataSourceProvider<DataSourceType> get(Class<DataSourceType> dataSourceType) {
        return this.sourceProvidersMappedBySourceType.get(dataSourceType);
    }

    @Override
    public boolean register(DataSourceProvider<?> dataSourceProvider) {
        Class<?> dataSourceType = dataSourceProvider.getDataSourceType();
        DataSourceProvider<?> previousProvider = this.sourceProvidersMappedBySourceType.put(dataSourceType, dataSourceProvider);
        if (previousProvider == null) {
            logger.info("Registering data source provider " + dataSourceProvider + " for data source type " + dataSourceType.getName());
        } else {
            logger.warning("Replacing data source provider " + previousProvider + " with " + dataSourceProvider + " for data source type " + dataSourceType.getName());
        }
        return true;
    }

    @Override
    public boolean unregister(DataSourceProvider<?> dataSourceProvider) {
        boolean changed = false;
        Class<?> dataSourceType = dataSourceProvider.getDataSourceType();
        DataSourceProvider<?> currentProvider = this.sourceProvidersMappedBySourceType.get(dataSourceType);
        if (currentProvider == null) {
            logger.info("Can't unregister " + dataSourceProvider + " because there is no provider registered for data source type " + dataSourceType);
        } else if (!currentProvider.equals(dataSourceProvider)) {
            logger.info("Can't unregister " + dataSourceProvider + " because theres the different provider " + currentProvider + " registered for the data source type " + dataSourceType);
        } else {
            logger.info("Unregistering data source provider " + dataSourceProvider + " for data source type " + dataSourceType.getName());
            this.sourceProvidersMappedBySourceType.remove(dataSourceType);
            changed = true;
        }
        return changed;
    }
}

