/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.datamining.shared;

import com.sap.sailing.polars.datamining.shared.PolarAggregation;
import com.sap.sailing.polars.datamining.shared.PolarDataMiningSettings;
import com.sap.sailing.polars.datamining.shared.PolarStatistic;
import java.util.HashMap;
import java.util.Map;

public class PolarAggregationImpl
implements PolarAggregation {
    private static final long serialVersionUID = 9177124509619315748L;
    private double[] sumSpeedsPerAngle = new double[360];
    private int[] countPerAngle = new int[360];
    private Map<Integer, Map<Double, Integer>> histogramData;
    private int count = 0;
    private PolarDataMiningSettings settings;

    public PolarAggregationImpl() {
    }

    public PolarAggregationImpl(PolarDataMiningSettings polarDataMiningSettings) {
        this.settings = polarDataMiningSettings;
        this.histogramData = new HashMap<Integer, Map<Double, Integer>>();
        int i = 0;
        while (i < 360) {
            this.histogramData.put(i, new HashMap());
            ++i;
        }
    }

    @Override
    public void addElement(PolarStatistic dataEntry) {
        long roundedAngleDeg = Math.round(dataEntry.getTrueWindAngleDeg());
        int angleDeg = (int)roundedAngleDeg;
        if (angleDeg < 0) {
            angleDeg += 360;
        }
        int n = angleDeg;
        this.sumSpeedsPerAngle[n] = this.sumSpeedsPerAngle[n] + dataEntry.getBoatSpeed().getKnots();
        int n2 = angleDeg;
        this.countPerAngle[n2] = this.countPerAngle[n2] + 1;
        Double histogramXValue = this.settings.getWindSpeedStepping().getHistogramXValue(this.settings.getNumberOfHistogramColumns(), dataEntry.getWindSpeed().getKnots());
        Map<Double, Integer> histDataForAngle = this.histogramData.get(angleDeg);
        if (!histDataForAngle.containsKey(histogramXValue)) {
            histDataForAngle.put(histogramXValue, 0);
        }
        Integer currentCount = histDataForAngle.get(histogramXValue) + 1;
        histDataForAngle.put(histogramXValue, currentCount);
        ++this.count;
    }

    @Override
    public double[] getAverageSpeedsPerAngle() {
        double[] averages = new double[360];
        int i = 0;
        while (i < 360) {
            if (this.countPerAngle[i] > 0) {
                averages[i] = this.sumSpeedsPerAngle[i] / (double)this.countPerAngle[i];
            }
            ++i;
        }
        return averages;
    }

    @Override
    public int[] getCountPerAngle() {
        return this.countPerAngle;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public PolarDataMiningSettings getSettings() {
        return this.settings;
    }

    @Override
    public Map<Integer, Map<Double, Integer>> getCountHistogramPerAngle() {
        return this.histogramData;
    }
}

