/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.dispatch.client.system.batching;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.gwt.dispatch.client.system.DispatchContext;
import com.sap.sse.gwt.dispatch.client.system.DispatchSystemAsync;
import com.sap.sse.gwt.dispatch.client.system.batching.BatchResult;
import com.sap.sse.gwt.dispatch.client.system.batching.DispatchCallStack;
import com.sap.sse.gwt.dispatch.client.system.batching.NonBatchableAction;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import com.sap.sse.gwt.dispatch.shared.commands.Result;
import java.util.logging.Logger;

public class AutomaticBatchingDispatch<CTX extends DispatchContext>
implements DispatchSystemAsync<CTX> {
    private static final Logger LOG = Logger.getLogger(AutomaticBatchingDispatch.class.getName());
    private final DispatchSystemAsync<CTX> executionContext;
    private DispatchCallStack<CTX> currentCallstack;
    private boolean processResultsScheduled;

    public AutomaticBatchingDispatch(DispatchSystemAsync<CTX> service) {
        this(service, false);
    }

    public AutomaticBatchingDispatch(DispatchSystemAsync<CTX> service, boolean processResultsScheduled) {
        this.executionContext = service;
        this.processResultsScheduled = processResultsScheduled;
    }

    @Override
    public <R extends Result, A extends Action<R, CTX>> void execute(A action, AsyncCallback<R> callback) {
        if (action instanceof NonBatchableAction) {
            this.executionContext.execute(action, callback);
            return;
        }
        if (this.currentCallstack == null) {
            this.currentCallstack = new DispatchCallStack();
            this.triggerExecution();
        }
        this.currentCallstack.addCall(action, callback);
    }

    private void triggerExecution() {
        Scheduler.get().scheduleFinally(new Scheduler.ScheduledCommand(){

            public void execute() {
                LOG.fine("executing batch callstack ");
                final DispatchCallStack callStackInExecution = AutomaticBatchingDispatch.this.currentCallstack;
                AutomaticBatchingDispatch.this.currentCallstack = null;
                AutomaticBatchingDispatch.this.executionContext.execute(callStackInExecution.getBatchAction(), new AsyncCallback<BatchResult>(){

                    public void onFailure(Throwable caught) {
                        LOG.finest("Failure on call execution: " + caught.getMessage());
                        callStackInExecution.fail(caught);
                    }

                    public void onSuccess(BatchResult result) {
                        callStackInExecution.processResult(result, AutomaticBatchingDispatch.this.processResultsScheduled);
                    }
                });
            }
        });
    }
}

