/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.useragent;

public class UserAgentDetails {
    static final String[] MOBILE_SPECIFIC_SUBSTRING = new String[]{"iPhone", "Android", "MIDP", "Opera Mobi", "iPad", "Opera Mini", "BlackBerry", "HP iPAQ", "IEMobile", "MSIEMobile", "Windows Phone", "HTC", "LG", "MOT", "Nokia", "Symbian", "Fennec", "Maemo", "Tear", "Midori", "armv", "Windows CE", "WindowsCE", "Smartphone", "240x320", "176x220", "320x320", "160x160", "webOS", "Palm", "Sagem", "Samsung", "SGH", "SIE", "SonyEricsson", "MMP", "UCWEB"};
    private AgentTypes type;
    private Integer[] version;
    private PlatformTypes platform;
    private String userAgentRaw;

    public UserAgentDetails(String userAgent) {
        userAgent = userAgent.toLowerCase();
        try {
            if (userAgent.indexOf("msie") != -1 && userAgent.indexOf("opera") == -1 && userAgent.indexOf("webtv") == -1) {
                String ieVersionString = userAgent.substring(userAgent.indexOf("msie ") + 5);
                ieVersionString = this.safeSubstring(ieVersionString, 0, ieVersionString.indexOf(";"));
                this.setType(AgentTypes.MSIE);
                this.setVersion(this.parseVersionString(ieVersionString));
            } else if (userAgent.indexOf(" firefox/") != -1) {
                int i = userAgent.indexOf(" firefox/") + 9;
                this.setType(AgentTypes.FIREFOX);
                this.setVersion(this.parseVersionString(this.safeSubstring(userAgent, i, i + 5)));
            } else if (userAgent.indexOf(" chrome/") != -1) {
                int i = userAgent.indexOf(" chrome/") + 8;
                this.setType(AgentTypes.CHROME);
                this.setVersion(this.parseVersionString(this.safeSubstring(userAgent, i, i + 5)));
            } else if (userAgent.indexOf(" chrome/") == -1 && userAgent.indexOf("safari") != -1) {
                int i = userAgent.indexOf(" version/") + 9;
                this.setType(AgentTypes.SAFARI);
                this.setVersion(this.parseVersionString(this.safeSubstring(userAgent, i, i + 5)));
            } else if (userAgent.indexOf("opera") != -1) {
                int i = userAgent.indexOf(" version/");
                i = i != -1 ? (i += 9) : userAgent.indexOf("opera/") + 6;
                this.setType(AgentTypes.OPERA);
                this.setVersion(this.parseVersionString(this.safeSubstring(userAgent, i, i + 5)));
            }
        }
        catch (Exception e) {
            this.setType(AgentTypes.UNKNOWN);
            this.setVersion(new Integer[]{-1, -1});
        }
        this.userAgentRaw = userAgent;
    }

    public PlatformTypes isMobile() {
        this.setPlatform(PlatformTypes.DESKTOP);
        String[] stringArray = MOBILE_SPECIFIC_SUBSTRING;
        int n = MOBILE_SPECIFIC_SUBSTRING.length;
        int n2 = 0;
        while (n2 < n) {
            String mobile = stringArray[n2];
            if (this.userAgentRaw.contains(mobile) || this.userAgentRaw.contains(mobile.toUpperCase()) || this.userAgentRaw.contains(mobile.toLowerCase())) {
                this.setPlatform(PlatformTypes.MOBILE);
                break;
            }
            ++n2;
        }
        return this.getPlatform();
    }

    private Integer[] parseVersionString(String versionString) {
        Integer[] version = new Integer[]{-1, -1};
        int idx = versionString.indexOf(46);
        if (idx < 0) {
            idx = versionString.length();
        }
        version[0] = Integer.parseInt(this.safeSubstring(versionString, 0, idx));
        int idx2 = versionString.indexOf(46, idx + 1);
        if (idx2 < 0) {
            idx2 = versionString.length();
        }
        try {
            version[1] = Integer.parseInt(this.safeSubstring(versionString, idx + 1, idx2).replaceAll("[^0-9].*", ""));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    private String safeSubstring(String string, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0 || endIndex > string.length()) {
            endIndex = string.length();
        }
        return string.substring(beginIndex, endIndex);
    }

    public AgentTypes getType() {
        return this.type;
    }

    public void setType(AgentTypes name) {
        this.type = name;
    }

    public Integer[] getVersion() {
        return this.version;
    }

    public void setVersion(Integer[] version) {
        this.version = version;
    }

    public PlatformTypes getPlatform() {
        return this.platform;
    }

    public void setPlatform(PlatformTypes platform) {
        this.platform = platform;
    }

    public static enum AgentTypes {
        MSIE,
        FIREFOX,
        SAFARI,
        OPERA,
        CHROME,
        UNKNOWN;

    }

    public static enum PlatformTypes {
        DESKTOP,
        MOBILE,
        UNKNOWN;

    }
}

