/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.perspective;

import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.shared.components.ComponentLifecycle;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeTabbedSettingsDialogComponent;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveLifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractPerspectiveLifecycle<PS extends Settings>
implements PerspectiveLifecycle<PS> {
    final List<ComponentLifecycle<?>> componentLifecycles = new ArrayList();

    protected final void addLifeCycle(ComponentLifecycle<?> cycle) {
        for (ComponentLifecycle<?> old : this.componentLifecycles) {
            if (!old.getComponentId().equals(cycle.getComponentId())) continue;
            throw new IllegalStateException("LifeCycle with duplicate ID " + cycle.getComponentId());
        }
        this.componentLifecycles.add(cycle);
    }

    @Override
    public PerspectiveCompositeTabbedSettingsDialogComponent<PS> getSettingsDialogComponent(PerspectiveCompositeSettings<PS> settings) {
        return new PerspectiveCompositeTabbedSettingsDialogComponent<PS>(this, settings);
    }

    @Override
    public PerspectiveCompositeSettings<PS> createDefaultSettings() {
        Object perspectiveOwnSettings = this.createPerspectiveOwnDefaultSettings();
        return new PerspectiveCompositeSettings(perspectiveOwnSettings, this.createDefaultComponentIdsAndSettings());
    }

    @Override
    public Map<String, Settings> createDefaultComponentIdsAndSettings() {
        HashMap<String, Settings> componentIdsAndSettings = new HashMap<String, Settings>();
        for (ComponentLifecycle<?> componentLifecycle : this.componentLifecycles) {
            componentIdsAndSettings.put(componentLifecycle.getComponentId(), (Settings)componentLifecycle.createDefaultSettings());
        }
        return componentIdsAndSettings;
    }

    @Override
    public Iterable<ComponentLifecycle<?>> getComponentLifecycles() {
        return this.componentLifecycles;
    }

    @Override
    public <SS extends Settings> ComponentLifecycle<SS> getLifecycleForId(String id) {
        for (ComponentLifecycle<?> componentLifecycle : this.componentLifecycles) {
            if (!id.equals(componentLifecycle.getComponentId())) continue;
            return componentLifecycle;
        }
        throw new IllegalStateException("No componentlivecycle for id " + id + " found");
    }

    @Override
    public final PerspectiveCompositeSettings<PS> extractDocumentSettings(PerspectiveCompositeSettings<PS> settings) {
        HashMap<String, Settings> settingsPerComponent = new HashMap<String, Settings>();
        for (Map.Entry<String, Settings> childSet : settings.getSettingsPerComponentId().entrySet()) {
            String childId = childSet.getKey();
            Settings childNewSettings = childSet.getValue();
            ComponentLifecycle childLiveCycle = this.getLifecycleForId(childId);
            Settings extracted = childLiveCycle.extractDocumentSettings(childNewSettings);
            settingsPerComponent.put(childId, extracted);
        }
        PS ownGlobalSettings = this.extractOwnDocumentSettings(this.hasSettings() ? settings.getPerspectiveOwnSettings() : this.createPerspectiveOwnDefaultSettings());
        return new PerspectiveCompositeSettings<PS>(ownGlobalSettings, settingsPerComponent);
    }

    @Override
    public final PerspectiveCompositeSettings<PS> extractUserSettings(PerspectiveCompositeSettings<PS> settings) {
        HashMap<String, Settings> settingsPerComponent = new HashMap<String, Settings>();
        for (Map.Entry<String, Settings> childSet : settings.getSettingsPerComponentId().entrySet()) {
            String childId = childSet.getKey();
            Settings childNewSettings = childSet.getValue();
            ComponentLifecycle childLiveCycle = this.getLifecycleForId(childId);
            Settings extracted = childLiveCycle.extractUserSettings(childNewSettings);
            settingsPerComponent.put(childId, extracted);
        }
        PS ownGlobalSettings = this.extractOwnUserSettings(this.hasSettings() ? settings.getPerspectiveOwnSettings() : this.createPerspectiveOwnDefaultSettings());
        return new PerspectiveCompositeSettings<PS>(ownGlobalSettings, settingsPerComponent);
    }

    protected abstract PS extractOwnUserSettings(PS var1);

    protected abstract PS extractOwnDocumentSettings(PS var1);
}

