/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.messaging;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.dom.client.Node;
import com.sap.sse.gwt.client.messaging.MessageListener;
import com.sap.sse.gwt.client.messaging.MessageListenerHandle;
import java.util.function.Consumer;

public class MessagePort
extends JavaScriptObject {
    protected MessagePort() {
    }

    public static void createInDocument(Document document, String urlForMessagingEntryPoint, Consumer<MessagePort> resultCallback) {
        IFrameElement iframe = document.createIFrameElement();
        iframe.setAttribute("style", "width:0; height:0; border:0; border:none;");
        iframe.setAttribute("importance", "high");
        Document.get().getBody().appendChild((Node)iframe);
        MessagePort result = MessagePort.getFromIframe(iframe);
        MessageListenerHandle[] listenerHandle = new MessageListenerHandle[1];
        MessagePort iframeParent = MessagePort.getGlobalWindow();
        MessageListener readyListener = messageEvent -> {
            if (((String)messageEvent.getData()).equals("I'm ready to rock")) {
                iframeParent.removeMessageListener(listenerHandle[0]);
                resultCallback.accept(result);
            }
        };
        listenerHandle[0] = iframeParent.addMessageListener(readyListener);
        iframe.setSrc(urlForMessagingEntryPoint);
    }

    public static final native MessagePort getGlobalWindow();

    public static final native MessagePort getCurrentWindow();

    public final native MessagePort getParentWindow();

    public final native String getOrigin();

    public static final native MessagePort getFromIframe(IFrameElement var0);

    public final native <T> void postMessage(T var1, String var2);

    public final native <T> MessageListenerHandle addMessageListener(MessageListener<T> var1);

    public final native void removeMessageListener(MessageListenerHandle var1);

    public final <T> ResponseListenerHandle addResponseListener(MessageListener<T> listener) {
        return new ResponseListenerHandle(MessagePort.getCurrentWindow().addMessageListener(listener));
    }

    public final void removeResponseListener(ResponseListenerHandle listenerHandle) {
        MessagePort.getCurrentWindow().removeMessageListener(listenerHandle.getMessageListenerHandle());
    }

    public static class ResponseListenerHandle {
        private final MessageListenerHandle messageListenerHandle;

        public ResponseListenerHandle(MessageListenerHandle messageListenerHandle) {
            this.messageListenerHandle = messageListenerHandle;
        }

        private MessageListenerHandle getMessageListenerHandle() {
            return this.messageListenerHandle;
        }
    }
}

