/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.Result;
import com.chargebee.internal.Request;
import com.chargebee.models.Subscription;
import com.chargebee.models.enums.CreditOptionForCurrentTermCharges;
import com.chargebee.models.enums.RefundableCreditsHandling;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import com.sap.sse.security.subscription.chargebee.ChargebeeApiRequest;
import com.sap.sse.security.subscription.chargebee.ChargebeeInternalApiRequestWrapper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChargebeeCancelSubscriptionRequest
extends ChargebeeApiRequest {
    private static final Logger logger = Logger.getLogger(ChargebeeCancelSubscriptionRequest.class.getName());
    private final String subscriptionId;
    private final OnResultListener listener;

    public ChargebeeCancelSubscriptionRequest(String subscriptionId, OnResultListener listener, SubscriptionApiRequestProcessor requestProcessor, SubscriptionApiBaseService chargebeeApiServiceParams) {
        super(requestProcessor, chargebeeApiServiceParams);
        this.subscriptionId = subscriptionId;
        this.listener = listener;
    }

    @Override
    protected ChargebeeInternalApiRequestWrapper createRequest() {
        logger.info(() -> "Cancel Chargebee subscription, subscription id: " + this.subscriptionId);
        Subscription.CancelForItemsRequest request = Subscription.cancelForItems((String)this.subscriptionId).creditOptionForCurrentTermCharges(CreditOptionForCurrentTermCharges.PRORATE).refundableCreditsHandling(RefundableCreditsHandling.SCHEDULE_REFUND).endOfTerm(Boolean.valueOf(false));
        return new ChargebeeInternalApiRequestWrapper((Request<?>)request);
    }

    @Override
    protected void processResult(ChargebeeInternalApiRequestWrapper request) {
        Result result = request.getResult();
        if (result != null) {
            this.onDone(result.subscription());
        } else {
            this.onDone(null);
        }
    }

    @Override
    protected void handleError(Exception e) {
        logger.log(Level.SEVERE, "Cancel Chargebee subscription failed, subscription id: " + this.subscriptionId, e);
        this.onDone(null);
    }

    private void onDone(Subscription subscription) {
        if (this.listener != null) {
            this.listener.onSubscriptionCancelResult(subscription);
        }
    }

    public static interface OnResultListener {
        public void onSubscriptionCancelResult(Subscription var1);
    }
}

