/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.chargebee.models.Invoice;
import com.chargebee.models.Subscription;
import com.chargebee.models.Transaction;
import com.sap.sse.common.TimePoint;
import com.sap.sse.security.shared.SubscriptionPlanProvider;
import com.sap.sse.security.shared.subscription.SubscriptionPlan;
import com.sap.sse.security.shared.subscription.SubscriptionPrice;
import com.sap.sse.security.shared.subscription.chargebee.ChargebeeSubscription;
import java.sql.Timestamp;
import java.util.Date;

public class ChargebeeApiSubscriptionData {
    private final Subscription subscription;
    private final Invoice invoice;
    private final Transaction transaction;

    public ChargebeeApiSubscriptionData(Subscription subscription, Invoice invoice, Transaction transaction) {
        this.subscription = subscription;
        this.invoice = invoice;
        this.transaction = transaction;
    }

    public ChargebeeSubscription toSubscription(SubscriptionPlanProvider subscriptionPlanProvider) {
        String subscriptionStatus = null;
        if (this.subscription.status() != null) {
            subscriptionStatus = this.stringToLowerCase(this.subscription.status().name());
        }
        String transactionType = null;
        String transactionStatus = null;
        if (this.transaction != null) {
            transactionType = this.stringToLowerCase(this.transaction.type().name());
            transactionStatus = this.stringToLowerCase(this.transaction.status().name());
        }
        String invoiceId = null;
        String invoiceStatus = null;
        if (this.invoice != null) {
            invoiceId = this.invoice.id();
            invoiceStatus = this.stringToLowerCase(this.invoice.status().name());
        }
        String paymentStatus = ChargebeeSubscription.determinePaymentStatus((String)transactionType, transactionStatus, invoiceStatus);
        String planId = this.getPlanId(subscriptionPlanProvider);
        int reoccuringPaymentValue = this.calculateReoccuringPaymentValue();
        return new ChargebeeSubscription(this.subscription.id(), planId, this.subscription.customerId(), this.getTime(this.subscription.trialStart()), this.getTime(this.subscription.trialEnd()), subscriptionStatus, paymentStatus, transactionType, transactionStatus, invoiceId, invoiceStatus, Integer.valueOf(reoccuringPaymentValue), this.subscription.currencyCode(), this.getTime(this.subscription.createdAt()), this.getTime(this.subscription.updatedAt()), this.getTime(this.subscription.activatedAt()), this.getTime(this.subscription.nextBillingAt()), this.getTime(this.subscription.currentTermEnd()), this.getTime(this.subscription.cancelledAt()), TimePoint.now(), com.sap.sse.security.shared.subscription.Subscription.emptyTime());
    }

    private int calculateReoccuringPaymentValue() {
        int reoccuringPaymentValue = 0;
        for (Subscription.SubscriptionItem item : this.subscription.subscriptionItems()) {
            if (item.amount() == null) continue;
            reoccuringPaymentValue += item.amount().intValue();
        }
        return reoccuringPaymentValue;
    }

    private String getPlanId(SubscriptionPlanProvider subscriptionPlanProvider) {
        for (Subscription.SubscriptionItem item : this.subscription.subscriptionItems()) {
            if (!item.itemType().equals((Object)Subscription.SubscriptionItem.ItemType.PLAN)) continue;
            String itemPriceId = item.itemPriceId();
            for (SubscriptionPlan plan : subscriptionPlanProvider.getAllSubscriptionPlans().values()) {
                for (SubscriptionPrice price : plan.getPrices()) {
                    if (!price.getPriceId().equals(itemPriceId)) continue;
                    return plan.getId();
                }
            }
        }
        return null;
    }

    private TimePoint getTime(Timestamp millis) {
        return millis == null ? com.sap.sse.security.shared.subscription.Subscription.emptyTime() : TimePoint.of((Date)millis);
    }

    private String stringToLowerCase(String str) {
        return str == null ? null : str.toLowerCase();
    }
}

