/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.security.subscription.SubscriptionApiBaseService;
import com.sap.sse.security.subscription.SubscriptionApiRequest;
import com.sap.sse.security.subscription.SubscriptionApiRequestProcessor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SubscriptionApiRequestProcessorImpl
implements SubscriptionApiRequestProcessor {
    private static final Logger logger = Logger.getLogger(SubscriptionApiRequestProcessorImpl.class.getName());
    private final ScheduledExecutorService executor;
    private ConcurrentHashMap<String, TimePoint> startOfLatestRequestByProviderName;

    public SubscriptionApiRequestProcessorImpl(ScheduledExecutorService executor) {
        this.executor = executor;
        this.startOfLatestRequestByProviderName = new ConcurrentHashMap();
    }

    @Override
    public void addRequest(SubscriptionApiRequest request) {
        this.scheduleRequest(request, this.getDelayToNextRequestStartTimePoint(request.getSubscriptionApiBaseService()));
    }

    @Override
    public void rescheduleRequestAfterRateLimitExceeded(SubscriptionApiRequest request) {
        this.scheduleRequest(request, this.getDelayWhenRateLimitWasExceeded(request.getSubscriptionApiBaseService()));
    }

    private void scheduleRequest(SubscriptionApiRequest request, Duration delay) {
        assert (request != null);
        this.executor.schedule(() -> {
            try {
                request.run();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Process subscription API request error", e);
            }
        }, delay.asMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Duration getDelayWhenRateLimitWasExceeded(SubscriptionApiBaseService subscriptionApiBaseService) {
        TimePoint now = TimePoint.now();
        SubscriptionApiRequestProcessorImpl subscriptionApiRequestProcessorImpl = this;
        synchronized (subscriptionApiRequestProcessorImpl) {
            this.startOfLatestRequestByProviderName.put(subscriptionApiBaseService.getProviderName(), now.plus(subscriptionApiBaseService.getLimitReachedResumeDelay()));
        }
        return subscriptionApiBaseService.getLimitReachedResumeDelay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Duration getDelayToNextRequestStartTimePoint(SubscriptionApiBaseService subscriptionApiBaseService) {
        TimePoint startOfLatestRequest;
        TimePoint now = TimePoint.now();
        SubscriptionApiRequestProcessorImpl subscriptionApiRequestProcessorImpl = this;
        synchronized (subscriptionApiRequestProcessorImpl) {
            if (!this.startOfLatestRequestByProviderName.containsKey(subscriptionApiBaseService.getProviderName())) {
                startOfLatestRequest = now;
            } else {
                startOfLatestRequest = this.startOfLatestRequestByProviderName.get(subscriptionApiBaseService.getProviderName()).plus(subscriptionApiBaseService.getTimeBetweenApiRequestStart());
                if (startOfLatestRequest.before(now)) {
                    startOfLatestRequest = now;
                }
            }
            this.startOfLatestRequestByProviderName.put(subscriptionApiBaseService.getProviderName(), startOfLatestRequest);
        }
        return now.until(startOfLatestRequest);
    }
}

