/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.mongodb.impl;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.session.ClientSession;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.landscape.mongodb.MongoEndpoint;
import com.sap.sse.mongodb.MongoDBService;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class MongoEndpointImpl
implements MongoEndpoint {
    private static final Logger logger = Logger.getLogger(MongoEndpointImpl.class.getName());

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    @Override
    public Iterable<MongoDatabase> getMongoDatabases() throws URISyntaxException {
        MongoClient client = this.getClient();
        return Util.map((Iterable)client.listDatabaseNames(), dbName -> client.getDatabase(dbName));
    }

    @Override
    public MongoDatabase getMongoDatabase(String dbName) throws URISyntaxException {
        return this.getClient().getDatabase(dbName);
    }

    @Override
    public MongoDatabase importDatabase(MongoDatabase from) throws URISyntaxException {
        int BATCH_SIZE = 100;
        MongoDatabase targetDatabase = this.getMongoDatabase(from.getName());
        logger.info("Importing database " + from.getName() + " into " + targetDatabase.getName() + " on " + this);
        for (String collectionName : from.listCollectionNames()) {
            MongoCollection sourceCollection = from.getCollection(collectionName);
            targetDatabase.createCollection(collectionName);
            MongoCollection targetCollection = targetDatabase.getCollection(collectionName);
            logger.info("...importing " + sourceCollection.estimatedDocumentCount() + " documents from collection " + collectionName + " from " + from + " into " + this);
            ArrayList<Document> documentsToInsert = new ArrayList<Document>(100);
            int i = 0;
            for (Document document : sourceCollection.find()) {
                documentsToInsert.add(document);
                if (++i < 100) continue;
                targetCollection.insertMany(documentsToInsert);
                i = 0;
                documentsToInsert.clear();
            }
            if (i <= 0) continue;
            targetCollection.insertMany(documentsToInsert);
        }
        return targetDatabase;
    }

    @Override
    public boolean isInReplicaSet() throws URISyntaxException {
        return this.getClient().getClusterDescription().getConnectionMode() != ClusterConnectionMode.SINGLE;
    }

    @Override
    public ConnectionString getConnectionString(Optional<Database> optionalDb) throws URISyntaxException {
        return new ConnectionString(this.getURI(optionalDb).toString());
    }

    @Override
    public ConnectionString getConnectionString(Optional<Database> optionalDb, Optional<Duration> timeoutEmptyMeaningForever) throws URISyntaxException {
        return new ConnectionString(this.getURI(optionalDb, timeoutEmptyMeaningForever).toString());
    }

    @Override
    public MongoClient getClient() throws URISyntaxException {
        return MongoDBService.INSTANCE.getMongo(this.getConnectionString(Optional.empty()));
    }

    @Override
    public MongoClient getClient(Optional<Duration> timeoutEmptyMeaningForever) throws URISyntaxException {
        return MongoDBService.INSTANCE.getMongo(this.getConnectionString(Optional.empty(), timeoutEmptyMeaningForever));
    }

    @Override
    public ClientSession getClientSession() throws URISyntaxException {
        return this.getClient().startSession(ClientSessionOptions.builder().causallyConsistent(true).build());
    }

    @Override
    public String getMD5Hash(MongoDatabase database) throws URISyntaxException {
        return database.runCommand((Bson)new Document("dbHash", (Object)1)).get((Object)"md5").toString();
    }

    public String toString() {
        String uri;
        try {
            uri = this.getURI(Optional.empty()).toString();
        }
        catch (URISyntaxException e) {
            uri = "<Error determining URI: " + e.getMessage() + ">";
        }
        return "MongoEndpointImpl [" + uri + "]";
    }
}

