/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.application;

import com.jcraft.jsch.JSchException;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.landscape.AvailabilityZone;
import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.Process;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.ReleaseRepository;
import com.sap.sse.landscape.RotatingFileBasedLog;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.application.ProcessFactory;
import com.sap.sse.replication.ReplicationServletActions;
import com.sap.sse.shared.util.Wait;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface ApplicationProcess<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends Process<RotatingFileBasedLog, MetricsT> {
    public static final String HEALTH_CHECK_PATH = "/gwt/status";
    public static final Logger logger = Logger.getLogger(ApplicationProcess.class.getName());
    public static final String REPLICATION_STATUS_POST_URL_PATH_AND_QUERY = "/replication/replication?action=" + ReplicationServletActions.Action.STATUS.name();
    public static final String STOP_REPLICATION_POST_URL_PATH_AND_QUERY = "/replication/replication?action=" + ReplicationServletActions.Action.STOP_REPLICATING.name();

    public Release getRelease(ReleaseRepository var1, Optional<Duration> var2, Optional<String> var3, byte[] var4) throws Exception;

    public void tryShutdown(Optional<Duration> var1, Optional<String> var2, byte[] var3) throws IOException, InterruptedException, JSchException, Exception;

    public int getTelnetPortToOSGiConsole(Optional<Duration> var1, Optional<String> var2, byte[] var3) throws Exception;

    public String getServerDirectory(Optional<Duration> var1) throws TimeoutException, Exception;

    public String getServerName(Optional<Duration> var1, Optional<String> var2, byte[] var3) throws Exception;

    public String getEnvSh(Optional<Duration> var1, Optional<String> var2, byte[] var3) throws Exception;

    public String getHealthCheckPath();

    public String getMasterServerName(Optional<Duration> var1) throws Exception;

    public String getEnvShValueFor(ProcessConfigurationVariable var1, Optional<Duration> var2, Optional<String> var3, byte[] var4) throws Exception;

    public String getEnvShValueFor(String var1, Optional<Duration> var2, Optional<String> var3, byte[] var4) throws Exception;

    @Override
    default public boolean isReady(Optional<Duration> optionalTimeout) throws IOException {
        try {
            HttpURLConnection connection = (HttpURLConnection)HttpUrlConnectionHelper.redirectConnection((URL)this.getHealthCheckUrl(optionalTimeout));
            return connection.getResponseCode() == 200;
        }
        catch (Exception e) {
            logger.info("Ready-check failed for " + this + ": " + e.getMessage());
            return false;
        }
    }

    default public URL getHealthCheckUrl(Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        return this.getUrl(this.getHealthCheckPath(), optionalTimeout);
    }

    default public URL getReplicationStatusPostUrlAndQuery(Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        return this.getUrl(REPLICATION_STATUS_POST_URL_PATH_AND_QUERY, optionalTimeout);
    }

    default public URL getReplicationStatusPostUrlAndQuery(String hostname, int port) throws MalformedURLException {
        return new URL(port == 443 ? "https" : "http", hostname, port, REPLICATION_STATUS_POST_URL_PATH_AND_QUERY);
    }

    public void stopReplicatingFromMaster(String var1, Optional<Duration> var2) throws MalformedURLException, IOException, TimeoutException, Exception;

    default public URL getUrl(String pathAndQuery, Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        int port = this.getPort();
        return new URL(port == 443 ? "https" : "http", ((InetAddress)Wait.wait(() -> this.getHost().getPublicAddress(optionalTimeout), publicAddress -> publicAddress != null, (boolean)true, optionalTimeout, (Duration)Duration.ONE_SECOND.times(10L), (Level)Level.INFO, (String)"Waiting for non-null public address")).getCanonicalHostName(), port, pathAndQuery);
    }

    default public boolean waitUntilReady(Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        return Wait.wait(() -> this.isReady(optionalTimeout), optionalTimeout, (Duration)Duration.ONE_SECOND.times(5L), (Level)Level.INFO, (String)(this + " not yet ready"));
    }

    public Release getVersion(Optional<Duration> var1, Optional<String> var2, byte[] var3) throws Exception;

    public TimePoint getStartTimePoint(Optional<Duration> var1) throws Exception;

    public void restart(Optional<Duration> var1, Optional<String> var2, byte[] var3) throws Exception;

    @FunctionalInterface
    public static interface ApplicationProcessFactory<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>> {
        public ProcessT createApplicationProcess(String var1, AvailabilityZone var2, Landscape<ShardingKey> var3, ProcessFactory<ShardingKey, MetricsT, ProcessT, Host> var4);
    }
}

