/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape;

import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.UserDataProvider;
import com.sap.sse.landscape.impl.OutboundReplicationConfigurationImpl;
import com.sap.sse.landscape.rabbitmq.RabbitMQEndpoint;
import java.util.HashMap;
import java.util.Map;

public interface OutboundReplicationConfiguration
extends UserDataProvider {
    public static Builder builder() {
        return new OutboundReplicationConfigurationImpl.BuilderImpl();
    }

    public static Builder copy(OutboundReplicationConfiguration outboundReplicationConfiguration) {
        return new OutboundReplicationConfigurationImpl.BuilderImpl(outboundReplicationConfiguration.getOutboundReplicationExchangeName(), outboundReplicationConfiguration.getOutboundRabbitMQEndpoint());
    }

    public String getOutboundReplicationExchangeName();

    public RabbitMQEndpoint getOutboundRabbitMQEndpoint();

    @Override
    default public Map<ProcessConfigurationVariable, String> getUserData() {
        HashMap<ProcessConfigurationVariable, String> result = new HashMap<ProcessConfigurationVariable, String>();
        if (this.getOutboundReplicationExchangeName() != null) {
            result.put(DefaultProcessConfigurationVariables.REPLICATION_CHANNEL, this.getOutboundReplicationExchangeName());
        }
        if (this.getOutboundRabbitMQEndpoint() != null) {
            result.put(DefaultProcessConfigurationVariables.REPLICATION_PORT, Integer.toString(this.getOutboundRabbitMQEndpoint().getPort()));
            if (this.getOutboundRabbitMQEndpoint().getNodeName() != null) {
                result.put(DefaultProcessConfigurationVariables.REPLICATION_HOST, this.getOutboundRabbitMQEndpoint().getNodeName());
            }
        }
        return result;
    }

    public static interface Builder {
        public Builder setOutboundReplicationExchangeName(String var1);

        public Builder setOutboundRabbitMQEndpoint(RabbitMQEndpoint var1);

        public OutboundReplicationConfiguration build();
    }
}

